/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.apache.http.HttpHost;
import org.elasticsearch.xpack.monitoring.exporter.http.Scheme;

public class HttpHostBuilder {
    private Scheme scheme = Scheme.HTTP;
    private String host = null;
    private int port = -1;

    public static HttpHostBuilder builder() {
        return new HttpHostBuilder();
    }

    public static HttpHostBuilder builder(String uri) {
        return new HttpHostBuilder(uri);
    }

    HttpHostBuilder() {
    }

    HttpHostBuilder(String uri) {
        Objects.requireNonNull(uri, "uri must not be null");
        try {
            URI parsedUri;
            String cleanedUri = uri;
            if (!uri.contains("://")) {
                cleanedUri = "http://" + uri;
            }
            if ((parsedUri = new URI(cleanedUri)).getScheme() != null) {
                this.scheme(Scheme.fromString(parsedUri.getScheme()));
            }
            if (parsedUri.getHost() != null) {
                this.host(parsedUri.getHost());
            } else {
                String host = parsedUri.getRawAuthority();
                if (host.contains(":")) {
                    String[] hostPort = host.split(":", 2);
                    this.host(hostPort[0]);
                    this.port(Integer.parseInt(hostPort[1]));
                } else {
                    this.host(host);
                }
            }
            if (parsedUri.getPort() != -1) {
                this.port(parsedUri.getPort());
            }
            if (parsedUri.getRawPath() != null && !parsedUri.getRawPath().isEmpty()) {
                throw new IllegalArgumentException("HttpHosts do not use paths [" + parsedUri.getRawPath() + "]. see setRequestConfigCallback for proxies. value: [" + uri + "]");
            }
        }
        catch (IndexOutOfBoundsException | NullPointerException | URISyntaxException e) {
            throw new IllegalArgumentException("error parsing host: [" + uri + "]", e);
        }
    }

    public HttpHostBuilder scheme(Scheme scheme) {
        this.scheme = Objects.requireNonNull(scheme);
        return this;
    }

    public HttpHostBuilder host(String host) {
        this.host = Objects.requireNonNull(host);
        return this;
    }

    public HttpHostBuilder port(int port) {
        if (port != -1 && (port < 1 || port > 65535)) {
            throw new IllegalArgumentException("port must be -1 for the default or [1, 65535]. was: " + port);
        }
        this.port = port;
        return this;
    }

    public HttpHost build() {
        if (this.host == null) {
            throw new IllegalStateException("host must be set");
        }
        return new HttpHost(this.host, this.port == -1 ? 9200 : this.port, this.scheme.toString());
    }
}

