/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.eql.execution.search;

import java.time.Instant;
import org.elasticsearch.xpack.eql.execution.search.Timestamp;

public class MillisTimestamp
extends Timestamp {
    private final long timestamp;
    private Instant instant = null;

    MillisTimestamp(long millis) {
        this.timestamp = millis;
    }

    @Override
    public int compareTo(Timestamp other) {
        return other instanceof MillisTimestamp ? Long.compare(this.timestamp, ((MillisTimestamp)other).timestamp) : super.compareTo(other);
    }

    @Override
    public long delta(Timestamp other) {
        return other instanceof MillisTimestamp ? (this.timestamp - ((MillisTimestamp)other).timestamp) * 1000000L : super.delta(other);
    }

    @Override
    public Instant instant() {
        if (this.instant == null) {
            this.instant = Instant.ofEpochMilli(this.timestamp);
        }
        return this.instant;
    }

    @Override
    public String asString() {
        return String.valueOf(this.timestamp);
    }
}

