/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.session;

import java.time.Clock;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.function.Function;

public class Configuration {
    private final String clusterName;
    private final String username;
    private final ZonedDateTime now;
    private final ZoneId zoneId;
    private final Function<String, Collection<String>> versionIncompatibleClusters;

    public Configuration(ZoneId zi, String username, String clusterName, Function<String, Collection<String>> versionIncompatibleClusters) {
        this.zoneId = zi.normalized();
        Clock clock = Clock.system(this.zoneId);
        this.now = ZonedDateTime.now(Clock.tick(clock, Duration.ofNanos(1L)));
        this.username = username;
        this.clusterName = clusterName;
        this.versionIncompatibleClusters = versionIncompatibleClusters;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public ZonedDateTime now() {
        return this.now;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public String username() {
        return this.username;
    }

    public Function<String, Collection<String>> versionIncompatibleClusters() {
        return this.versionIncompatibleClusters;
    }
}

