/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.function.grouping;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.Function;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.AggNameInput;
import org.elasticsearch.xpack.ql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public abstract class GroupingFunction
extends Function {
    private final Expression field;
    private final List<Expression> parameters;

    protected GroupingFunction(Source source, Expression field) {
        this(source, field, Collections.emptyList());
    }

    protected GroupingFunction(Source source, Expression field, List<Expression> parameters) {
        super(source, CollectionUtils.combine(Collections.singletonList(field), parameters));
        this.field = field;
        this.parameters = parameters;
    }

    public Expression field() {
        return this.field;
    }

    public List<Expression> parameters() {
        return this.parameters;
    }

    @Override
    protected Pipe makePipe() {
        return new AggNameInput(this.source(), (Expression)this, this.sourceText());
    }

    @Override
    public ScriptTemplate asScript() {
        throw new QlIllegalArgumentException("Grouping functions cannot be scripted");
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        GroupingFunction other = (GroupingFunction)obj;
        return Objects.equals(other.field(), this.field()) && Objects.equals(other.parameters(), this.parameters());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.parameters());
    }
}

