/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.saml;

import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestRequestFilter;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateRequestBuilder;
import org.elasticsearch.xpack.core.security.action.saml.SamlAuthenticateResponse;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.saml.SamlBaseRestHandler;

public class RestSamlAuthenticateAction
extends SamlBaseRestHandler
implements RestRequestFilter {
    private static final Logger logger = LogManager.getLogger();
    static final ObjectParser<Input, Void> PARSER = new ObjectParser("saml_authenticate", Input::new);
    private static final Set<String> FILTERED_FIELDS;

    public RestSamlAuthenticateAction(Settings settings, XPackLicenseState licenseState) {
        super(settings, licenseState);
    }

    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object)RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_security/saml/authenticate").replaces(RestRequest.Method.POST, "/_xpack/security/saml/authenticate", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "security_saml_authenticate_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentParser();){
            Input input = (Input)PARSER.parse(parser, null);
            logger.trace("SAML Authenticate: [{}...] [{}]", (Object)Strings.cleanTruncate((String)input.content, (int)128), input.ids);
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> {
                byte[] bytes = this.decodeBase64(input.content);
                SamlAuthenticateRequestBuilder requestBuilder = new SecurityClient((ElasticsearchClient)client).prepareSamlAuthenticate(bytes, input.ids).authenticatingRealm(input.realm);
                requestBuilder.execute((ActionListener)new RestBuilderListener<SamlAuthenticateResponse>(channel){

                    public RestResponse buildResponse(SamlAuthenticateResponse response, XContentBuilder builder) throws Exception {
                        builder.startObject();
                        builder.field("username", response.getPrincipal());
                        builder.field("realm", response.getRealm());
                        builder.field("access_token", response.getTokenString());
                        builder.field("refresh_token", response.getRefreshToken());
                        builder.field("expires_in", response.getExpiresIn().seconds());
                        if (response.getAuthentication() != null) {
                            builder.field("authentication", (ToXContent)response.getAuthentication());
                        }
                        builder.endObject();
                        return new BytesRestResponse(RestStatus.OK, builder);
                    }
                });
            };
            return restChannelConsumer;
        }
    }

    private byte[] decodeBase64(String content) {
        content = content.replaceAll("\\s+", "");
        try {
            return Base64.getDecoder().decode(content);
        }
        catch (IllegalArgumentException e) {
            logger.info("Failed to decode base64 string [{}] - {}", (Object)content, (Object)e.toString());
            throw e;
        }
    }

    public Set<String> getFilteredFields() {
        return FILTERED_FIELDS;
    }

    static {
        PARSER.declareString(Input::setContent, new ParseField("content", new String[0]));
        PARSER.declareStringArray(Input::setIds, new ParseField("ids", new String[0]));
        PARSER.declareStringOrNull(Input::setRealm, new ParseField("realm", new String[0]));
        FILTERED_FIELDS = Collections.singleton("content");
    }

    static class Input {
        String content;
        List<String> ids;
        String realm;

        Input() {
        }

        void setContent(String content) {
            this.content = content;
        }

        void setIds(List<String> ids) {
            this.ids = ids;
        }

        void setRealm(String realm) {
            this.realm = realm;
        }
    }
}

