/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.http.HttpPreRequest;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authz.AuthorizationEngine;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class AuditTrailService {
    private static final Logger logger = LogManager.getLogger(AuditTrailService.class);
    private static final AuditTrail NOOP_AUDIT_TRAIL = new NoopAuditTrail();
    private final CompositeAuditTrail compositeAuditTrail;
    private final XPackLicenseState licenseState;
    private final Duration minLogPeriod = Duration.ofMinutes(30L);
    protected AtomicReference<Instant> nextLogInstantAtomic = new AtomicReference<Instant>(Instant.EPOCH);

    public AuditTrailService(List<AuditTrail> auditTrails, XPackLicenseState licenseState) {
        this.compositeAuditTrail = new CompositeAuditTrail(Collections.unmodifiableList(auditTrails));
        this.licenseState = licenseState;
    }

    public AuditTrail get() {
        if (!this.compositeAuditTrail.isEmpty() && this.licenseState.isSecurityEnabled()) {
            if (Security.AUDITING_FEATURE.check(this.licenseState)) {
                return this.compositeAuditTrail;
            }
            this.maybeLogAuditingDisabled();
            return NOOP_AUDIT_TRAIL;
        }
        return NOOP_AUDIT_TRAIL;
    }

    public List<AuditTrail> getAuditTrails() {
        return this.compositeAuditTrail.auditTrails;
    }

    private void maybeLogAuditingDisabled() {
        Instant nowInstant = Instant.now();
        Instant nextLogInstant = this.nextLogInstantAtomic.get();
        if (nextLogInstant.isBefore(nowInstant) && this.nextLogInstantAtomic.compareAndSet(nextLogInstant, nowInstant.plus(this.minLogPeriod))) {
            logger.warn("Auditing logging is DISABLED because the currently active license [" + this.licenseState.getOperationMode() + "] does not permit it");
        }
    }

    private static class CompositeAuditTrail
    implements AuditTrail {
        private final List<AuditTrail> auditTrails;

        private CompositeAuditTrail(List<AuditTrail> auditTrails) {
            this.auditTrails = auditTrails;
        }

        boolean isEmpty() {
            return this.auditTrails.isEmpty();
        }

        @Override
        public String name() {
            return "service";
        }

        @Override
        public void authenticationSuccess(RestRequest request) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationSuccess(request);
            }
        }

        @Override
        public void authenticationSuccess(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationSuccess(requestId, authentication, action, transportRequest);
            }
        }

        @Override
        public void anonymousAccessDenied(String requestId, String action, TransportRequest transportRequest) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.anonymousAccessDenied(requestId, action, transportRequest);
            }
        }

        @Override
        public void anonymousAccessDenied(String requestId, HttpPreRequest request) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.anonymousAccessDenied(requestId, request);
            }
        }

        @Override
        public void authenticationFailed(String requestId, HttpPreRequest request) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, request);
            }
        }

        @Override
        public void authenticationFailed(String requestId, String action, TransportRequest transportRequest) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, action, transportRequest);
            }
        }

        @Override
        public void authenticationFailed(String requestId, AuthenticationToken token, String action, TransportRequest transportRequest) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, token, action, transportRequest);
            }
        }

        @Override
        public void authenticationFailed(String requestId, String realm, AuthenticationToken token, String action, TransportRequest transportRequest) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, realm, token, action, transportRequest);
            }
        }

        @Override
        public void authenticationFailed(String requestId, AuthenticationToken token, HttpPreRequest request) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, token, request);
            }
        }

        @Override
        public void authenticationFailed(String requestId, String realm, AuthenticationToken token, HttpPreRequest request) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.authenticationFailed(requestId, realm, token, request);
            }
        }

        @Override
        public void accessGranted(String requestId, Authentication authentication, String action, TransportRequest msg, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.accessGranted(requestId, authentication, action, msg, authorizationInfo);
            }
        }

        @Override
        public void accessDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.accessDenied(requestId, authentication, action, transportRequest, authorizationInfo);
            }
        }

        @Override
        public void coordinatingActionResponse(String requestId, Authentication authentication, String action, TransportRequest transportRequest, TransportResponse transportResponse) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.coordinatingActionResponse(requestId, authentication, action, transportRequest, transportResponse);
            }
        }

        @Override
        public void tamperedRequest(String requestId, HttpPreRequest request) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(requestId, request);
            }
        }

        @Override
        public void tamperedRequest(String requestId, String action, TransportRequest transportRequest) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(requestId, action, transportRequest);
            }
        }

        @Override
        public void tamperedRequest(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.tamperedRequest(requestId, authentication, action, transportRequest);
            }
        }

        @Override
        public void connectionGranted(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.connectionGranted(inetAddress, profile, rule);
            }
        }

        @Override
        public void connectionDenied(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.connectionDenied(inetAddress, profile, rule);
            }
        }

        @Override
        public void runAsGranted(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsGranted(requestId, authentication, action, transportRequest, authorizationInfo);
            }
        }

        @Override
        public void runAsDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsDenied(requestId, authentication, action, transportRequest, authorizationInfo);
            }
        }

        @Override
        public void runAsDenied(String requestId, Authentication authentication, HttpPreRequest request, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.runAsDenied(requestId, authentication, request, authorizationInfo);
            }
        }

        @Override
        public void explicitIndexAccessEvent(String requestId, AuditLevel eventType, Authentication authentication, String action, String indices, String requestName, TransportAddress remoteAddress, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
            for (AuditTrail auditTrail : this.auditTrails) {
                auditTrail.explicitIndexAccessEvent(requestId, eventType, authentication, action, indices, requestName, remoteAddress, authorizationInfo);
            }
        }
    }

    private static class NoopAuditTrail
    implements AuditTrail {
        private NoopAuditTrail() {
        }

        @Override
        public String name() {
            return "noop";
        }

        @Override
        public void authenticationSuccess(RestRequest request) {
        }

        @Override
        public void authenticationSuccess(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
        }

        @Override
        public void anonymousAccessDenied(String requestId, String action, TransportRequest transportRequest) {
        }

        @Override
        public void anonymousAccessDenied(String requestId, HttpPreRequest request) {
        }

        @Override
        public void authenticationFailed(String requestId, HttpPreRequest request) {
        }

        @Override
        public void authenticationFailed(String requestId, String action, TransportRequest transportRequest) {
        }

        @Override
        public void authenticationFailed(String requestId, AuthenticationToken token, String action, TransportRequest transportRequest) {
        }

        @Override
        public void authenticationFailed(String requestId, AuthenticationToken token, HttpPreRequest request) {
        }

        @Override
        public void authenticationFailed(String requestId, String realm, AuthenticationToken token, String action, TransportRequest transportRequest) {
        }

        @Override
        public void authenticationFailed(String requestId, String realm, AuthenticationToken token, HttpPreRequest request) {
        }

        @Override
        public void accessGranted(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void accessDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void tamperedRequest(String requestId, HttpPreRequest request) {
        }

        @Override
        public void tamperedRequest(String requestId, String action, TransportRequest transportRequest) {
        }

        @Override
        public void tamperedRequest(String requestId, Authentication authentication, String action, TransportRequest transportRequest) {
        }

        @Override
        public void connectionGranted(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        }

        @Override
        public void connectionDenied(InetSocketAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        }

        @Override
        public void runAsGranted(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void runAsDenied(String requestId, Authentication authentication, String action, TransportRequest transportRequest, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void runAsDenied(String requestId, Authentication authentication, HttpPreRequest request, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void explicitIndexAccessEvent(String requestId, AuditLevel eventType, Authentication authentication, String action, String indices, String requestName, TransportAddress remoteAddress, AuthorizationEngine.AuthorizationInfo authorizationInfo) {
        }

        @Override
        public void coordinatingActionResponse(String requestId, Authentication authentication, String action, TransportRequest transportRequest, TransportResponse transportResponse) {
        }
    }
}

