/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xpack.core.security.action.CreateApiKeyResponse;
import org.elasticsearch.xpack.core.security.action.GrantApiKeyRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.support.ApiKeyGenerator;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public final class TransportGrantApiKeyAction
extends HandledTransportAction<GrantApiKeyRequest, CreateApiKeyResponse> {
    private final ThreadContext threadContext;
    private final ApiKeyGenerator generator;
    private final AuthenticationService authenticationService;
    private final TokenService tokenService;

    @Inject
    public TransportGrantApiKeyAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ApiKeyService apiKeyService, AuthenticationService authenticationService, TokenService tokenService, CompositeRolesStore rolesStore, NamedXContentRegistry xContentRegistry) {
        this(transportService, actionFilters, threadPool.getThreadContext(), new ApiKeyGenerator(apiKeyService, rolesStore, xContentRegistry), authenticationService, tokenService);
    }

    TransportGrantApiKeyAction(TransportService transportService, ActionFilters actionFilters, ThreadContext threadContext, ApiKeyGenerator generator, AuthenticationService authenticationService, TokenService tokenService) {
        super("cluster:admin/xpack/security/api_key/grant", transportService, actionFilters, GrantApiKeyRequest::new);
        this.threadContext = threadContext;
        this.generator = generator;
        this.authenticationService = authenticationService;
        this.tokenService = tokenService;
    }

    protected void doExecute(Task task, GrantApiKeyRequest request, ActionListener<CreateApiKeyResponse> listener) {
        try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
            this.resolveAuthentication(request.getGrant(), (TransportRequest)request, (ActionListener<Authentication>)ActionListener.wrap(authentication -> this.generator.generateApiKey((Authentication)authentication, request.getApiKeyRequest(), listener), arg_0 -> listener.onFailure(arg_0)));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void resolveAuthentication(GrantApiKeyRequest.Grant grant, TransportRequest transportRequest, ActionListener<Authentication> listener) {
        switch (grant.getType()) {
            case "password": {
                UsernamePasswordToken token = new UsernamePasswordToken(grant.getUsername(), grant.getPassword());
                this.authenticationService.authenticate(this.actionName, transportRequest, (AuthenticationToken)token, listener);
                return;
            }
            case "access_token": {
                this.tokenService.authenticateToken(grant.getAccessToken(), listener);
                return;
            }
        }
        listener.onFailure((Exception)((Object)new ElasticsearchSecurityException("the grant type [{}] is not supported", new Object[]{grant.getType()})));
    }
}

