/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.AccessControlException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.CertParsingUtils;
import org.elasticsearch.xpack.core.ssl.TrustConfig;
import org.elasticsearch.xpack.core.ssl.cert.CertificateInfo;

class StoreTrustConfig
extends TrustConfig {
    private static final String TRUSTSTORE_FILE = "truststore";
    final String trustStorePath;
    final String trustStoreType;
    final SecureString trustStorePassword;
    final String trustStoreAlgorithm;

    StoreTrustConfig(String trustStorePath, String trustStoreType, SecureString trustStorePassword, String trustStoreAlgorithm) {
        this.trustStorePath = trustStorePath;
        this.trustStoreType = trustStoreType;
        this.trustStorePassword = Objects.requireNonNull(trustStorePassword, "truststore password must be specified").clone();
        this.trustStoreAlgorithm = trustStoreAlgorithm;
    }

    @Override
    X509ExtendedTrustManager createTrustManager(@Nullable Environment environment) {
        Path storePath = this.resolveTrustStorePath(environment);
        try {
            KeyStore trustStore = this.getStore(storePath, this.trustStoreType, this.trustStorePassword);
            return CertParsingUtils.trustManager(trustStore, this.trustStoreAlgorithm);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw this.missingTrustConfigFile(e, TRUSTSTORE_FILE, storePath);
        }
        catch (AccessDeniedException e) {
            throw this.unreadableTrustConfigFile(e, TRUSTSTORE_FILE, storePath);
        }
        catch (AccessControlException e) {
            throw this.blockedTrustConfigFile(e, environment, TRUSTSTORE_FILE, Collections.singletonList(storePath));
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to initialize SSL TrustManager", (Throwable)e, new Object[0]);
        }
    }

    @Override
    Collection<CertificateInfo> certificates(Environment environment) throws GeneralSecurityException, IOException {
        KeyStore trustStore = this.getStore(environment, this.trustStorePath, this.trustStoreType, this.trustStorePassword);
        ArrayList<CertificateInfo> certificates = new ArrayList<CertificateInfo>();
        Enumeration<String> aliases = trustStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate certificate = trustStore.getCertificate(alias);
            if (!(certificate instanceof X509Certificate)) continue;
            boolean hasKey = trustStore.isKeyEntry(alias);
            certificates.add(new CertificateInfo(this.trustStorePath, this.trustStoreType, alias, hasKey, (X509Certificate)certificate));
        }
        return certificates;
    }

    protected Path resolveTrustStorePath(Environment environment) {
        return CertParsingUtils.resolvePath(this.trustStorePath, environment);
    }

    protected KeyStore getStore(Path path) throws GeneralSecurityException, IOException {
        return this.getStore(path, this.trustStoreType, this.trustStorePassword);
    }

    @Override
    List<Path> filesToMonitor(@Nullable Environment environment) {
        if (this.trustStorePath == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(CertParsingUtils.resolvePath(this.trustStorePath, environment));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreTrustConfig that = (StoreTrustConfig)o;
        return Objects.equals(this.trustStorePath, that.trustStorePath) && Objects.equals(this.trustStoreType, that.trustStoreType) && Objects.equals(this.trustStorePassword, that.trustStorePassword) && Objects.equals(this.trustStoreAlgorithm, that.trustStoreAlgorithm);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.trustStorePath, this.trustStoreType, this.trustStorePassword, this.trustStoreAlgorithm);
    }

    @Override
    public String toString() {
        return "trustStorePath=[" + this.trustStorePath + "], trustStoreAlgorithm=[" + this.trustStoreAlgorithm + "]";
    }
}

