/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.output;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class FlushAcknowledgement
implements ToXContentObject,
Writeable {
    public static final ParseField TYPE = new ParseField("flush", new String[0]);
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField LAST_FINALIZED_BUCKET_END = new ParseField("last_finalized_bucket_end", new String[0]);
    public static final ConstructingObjectParser<FlushAcknowledgement, Void> PARSER = new ConstructingObjectParser(TYPE.getPreferredName(), a -> new FlushAcknowledgement((String)a[0], (Long)a[1]));
    private final String id;
    private final Instant lastFinalizedBucketEnd;

    public FlushAcknowledgement(String id, Long lastFinalizedBucketEndMs) {
        this.id = id;
        this.lastFinalizedBucketEnd = lastFinalizedBucketEndMs != null && lastFinalizedBucketEndMs > 0L ? Instant.ofEpochMilli(lastFinalizedBucketEndMs) : null;
    }

    public FlushAcknowledgement(String id, Instant lastFinalizedBucketEnd) {
        this.id = id;
        long epochMillis = lastFinalizedBucketEnd != null ? lastFinalizedBucketEnd.toEpochMilli() : 0L;
        this.lastFinalizedBucketEnd = epochMillis > 0L ? Instant.ofEpochMilli(epochMillis) : null;
    }

    public FlushAcknowledgement(StreamInput in) throws IOException {
        long epochMillis;
        this.id = in.readString();
        this.lastFinalizedBucketEnd = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readOptionalInstant() : ((epochMillis = in.readVLong()) > 0L ? Instant.ofEpochMilli(epochMillis) : null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeOptionalInstant(this.lastFinalizedBucketEnd);
        } else {
            long epochMillis = this.lastFinalizedBucketEnd != null ? this.lastFinalizedBucketEnd.toEpochMilli() : 0L;
            out.writeVLong(epochMillis);
        }
    }

    public String getId() {
        return this.id;
    }

    public Instant getLastFinalizedBucketEnd() {
        return this.lastFinalizedBucketEnd;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        if (this.lastFinalizedBucketEnd != null) {
            builder.timeField(LAST_FINALIZED_BUCKET_END.getPreferredName(), LAST_FINALIZED_BUCKET_END.getPreferredName() + "_string", this.lastFinalizedBucketEnd.toEpochMilli());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.lastFinalizedBucketEnd);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlushAcknowledgement other = (FlushAcknowledgement)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.lastFinalizedBucketEnd, other.lastFinalizedBucketEnd);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), LAST_FINALIZED_BUCKET_END);
    }
}

