/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.stats.classification;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class Hyperparameters
implements ToXContentObject,
Writeable {
    public static final ParseField CLASS_ASSIGNMENT_OBJECTIVE = new ParseField("class_assignment_objective", new String[0]);
    public static final ParseField ALPHA = new ParseField("alpha", new String[0]);
    public static final ParseField DOWNSAMPLE_FACTOR = new ParseField("downsample_factor", new String[0]);
    public static final ParseField ETA = new ParseField("eta", new String[0]);
    public static final ParseField ETA_GROWTH_RATE_PER_TREE = new ParseField("eta_growth_rate_per_tree", new String[0]);
    public static final ParseField FEATURE_BAG_FRACTION = new ParseField("feature_bag_fraction", new String[0]);
    public static final ParseField GAMMA = new ParseField("gamma", new String[0]);
    public static final ParseField LAMBDA = new ParseField("lambda", new String[0]);
    public static final ParseField MAX_ATTEMPTS_TO_ADD_TREE = new ParseField("max_attempts_to_add_tree", new String[0]);
    public static final ParseField MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER = new ParseField("max_optimization_rounds_per_hyperparameter", new String[0]);
    public static final ParseField MAX_TREES = new ParseField("max_trees", new String[0]);
    public static final ParseField NUM_FOLDS = new ParseField("num_folds", new String[0]);
    public static final ParseField NUM_SPLITS_PER_FEATURE = new ParseField("num_splits_per_feature", new String[0]);
    public static final ParseField SOFT_TREE_DEPTH_LIMIT = new ParseField("soft_tree_depth_limit", new String[0]);
    public static final ParseField SOFT_TREE_DEPTH_TOLERANCE = new ParseField("soft_tree_depth_tolerance", new String[0]);
    private final String classAssignmentObjective;
    private final double alpha;
    private final double downsampleFactor;
    private final double eta;
    private final double etaGrowthRatePerTree;
    private final double featureBagFraction;
    private final double gamma;
    private final double lambda;
    private final int maxAttemptsToAddTree;
    private final int maxOptimizationRoundsPerHyperparameter;
    private final int maxTrees;
    private final int numFolds;
    private final int numSplitsPerFeature;
    private final double softTreeDepthLimit;
    private final double softTreeDepthTolerance;

    public static Hyperparameters fromXContent(XContentParser parser, boolean ignoreUnknownFields) {
        return (Hyperparameters)Hyperparameters.createParser(ignoreUnknownFields).apply(parser, null);
    }

    private static ConstructingObjectParser<Hyperparameters, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser("classification_hyperparameters", ignoreUnknownFields, a -> new Hyperparameters((String)a[0], (Double)a[1], (Double)a[2], (Double)a[3], (Double)a[4], (Double)a[5], (Double)a[6], (Double)a[7], (Integer)a[8], (Integer)a[9], (Integer)a[10], (Integer)a[11], (Integer)a[12], (Double)a[13], (Double)a[14]));
        parser.declareString(ConstructingObjectParser.constructorArg(), CLASS_ASSIGNMENT_OBJECTIVE);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), ALPHA);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), DOWNSAMPLE_FACTOR);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), ETA);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), ETA_GROWTH_RATE_PER_TREE);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), FEATURE_BAG_FRACTION);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), GAMMA);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), LAMBDA);
        parser.declareInt(ConstructingObjectParser.constructorArg(), MAX_ATTEMPTS_TO_ADD_TREE);
        parser.declareInt(ConstructingObjectParser.constructorArg(), MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER);
        parser.declareInt(ConstructingObjectParser.constructorArg(), MAX_TREES);
        parser.declareInt(ConstructingObjectParser.constructorArg(), NUM_FOLDS);
        parser.declareInt(ConstructingObjectParser.constructorArg(), NUM_SPLITS_PER_FEATURE);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), SOFT_TREE_DEPTH_LIMIT);
        parser.declareDouble(ConstructingObjectParser.constructorArg(), SOFT_TREE_DEPTH_TOLERANCE);
        return parser;
    }

    public Hyperparameters(String classAssignmentObjective, double alpha, double downsampleFactor, double eta, double etaGrowthRatePerTree, double featureBagFraction, double gamma, double lambda, int maxAttemptsToAddTree, int maxOptimizationRoundsPerHyperparameter, int maxTrees, int numFolds, int numSplitsPerFeature, double softTreeDepthLimit, double softTreeDepthTolerance) {
        this.classAssignmentObjective = Objects.requireNonNull(classAssignmentObjective);
        this.alpha = alpha;
        this.downsampleFactor = downsampleFactor;
        this.eta = eta;
        this.etaGrowthRatePerTree = etaGrowthRatePerTree;
        this.featureBagFraction = featureBagFraction;
        this.gamma = gamma;
        this.lambda = lambda;
        this.maxAttemptsToAddTree = maxAttemptsToAddTree;
        this.maxOptimizationRoundsPerHyperparameter = maxOptimizationRoundsPerHyperparameter;
        this.maxTrees = maxTrees;
        this.numFolds = numFolds;
        this.numSplitsPerFeature = numSplitsPerFeature;
        this.softTreeDepthLimit = softTreeDepthLimit;
        this.softTreeDepthTolerance = softTreeDepthTolerance;
    }

    public Hyperparameters(StreamInput in) throws IOException {
        this.classAssignmentObjective = in.readString();
        this.alpha = in.readDouble();
        this.downsampleFactor = in.readDouble();
        this.eta = in.readDouble();
        this.etaGrowthRatePerTree = in.readDouble();
        this.featureBagFraction = in.readDouble();
        this.gamma = in.readDouble();
        this.lambda = in.readDouble();
        this.maxAttemptsToAddTree = in.readVInt();
        this.maxOptimizationRoundsPerHyperparameter = in.readVInt();
        this.maxTrees = in.readVInt();
        this.numFolds = in.readVInt();
        this.numSplitsPerFeature = in.readVInt();
        this.softTreeDepthLimit = in.readDouble();
        this.softTreeDepthTolerance = in.readDouble();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.classAssignmentObjective);
        out.writeDouble(this.alpha);
        out.writeDouble(this.downsampleFactor);
        out.writeDouble(this.eta);
        out.writeDouble(this.etaGrowthRatePerTree);
        out.writeDouble(this.featureBagFraction);
        out.writeDouble(this.gamma);
        out.writeDouble(this.lambda);
        out.writeVInt(this.maxAttemptsToAddTree);
        out.writeVInt(this.maxOptimizationRoundsPerHyperparameter);
        out.writeVInt(this.maxTrees);
        out.writeVInt(this.numFolds);
        out.writeVInt(this.numSplitsPerFeature);
        out.writeDouble(this.softTreeDepthLimit);
        out.writeDouble(this.softTreeDepthTolerance);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CLASS_ASSIGNMENT_OBJECTIVE.getPreferredName(), this.classAssignmentObjective);
        builder.field(ALPHA.getPreferredName(), this.alpha);
        builder.field(DOWNSAMPLE_FACTOR.getPreferredName(), this.downsampleFactor);
        builder.field(ETA.getPreferredName(), this.eta);
        builder.field(ETA_GROWTH_RATE_PER_TREE.getPreferredName(), this.etaGrowthRatePerTree);
        builder.field(FEATURE_BAG_FRACTION.getPreferredName(), this.featureBagFraction);
        builder.field(GAMMA.getPreferredName(), this.gamma);
        builder.field(LAMBDA.getPreferredName(), this.lambda);
        builder.field(MAX_ATTEMPTS_TO_ADD_TREE.getPreferredName(), this.maxAttemptsToAddTree);
        builder.field(MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER.getPreferredName(), this.maxOptimizationRoundsPerHyperparameter);
        builder.field(MAX_TREES.getPreferredName(), this.maxTrees);
        builder.field(NUM_FOLDS.getPreferredName(), this.numFolds);
        builder.field(NUM_SPLITS_PER_FEATURE.getPreferredName(), this.numSplitsPerFeature);
        builder.field(SOFT_TREE_DEPTH_LIMIT.getPreferredName(), this.softTreeDepthLimit);
        builder.field(SOFT_TREE_DEPTH_TOLERANCE.getPreferredName(), this.softTreeDepthTolerance);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hyperparameters that = (Hyperparameters)o;
        return Objects.equals(this.classAssignmentObjective, that.classAssignmentObjective) && this.alpha == that.alpha && this.downsampleFactor == that.downsampleFactor && this.eta == that.eta && this.etaGrowthRatePerTree == that.etaGrowthRatePerTree && this.featureBagFraction == that.featureBagFraction && this.gamma == that.gamma && this.lambda == that.lambda && this.maxAttemptsToAddTree == that.maxAttemptsToAddTree && this.maxOptimizationRoundsPerHyperparameter == that.maxOptimizationRoundsPerHyperparameter && this.maxTrees == that.maxTrees && this.numFolds == that.numFolds && this.numSplitsPerFeature == that.numSplitsPerFeature && this.softTreeDepthLimit == that.softTreeDepthLimit && this.softTreeDepthTolerance == that.softTreeDepthTolerance;
    }

    public int hashCode() {
        return Objects.hash(this.classAssignmentObjective, this.alpha, this.downsampleFactor, this.eta, this.etaGrowthRatePerTree, this.featureBagFraction, this.gamma, this.lambda, this.maxAttemptsToAddTree, this.maxOptimizationRoundsPerHyperparameter, this.maxTrees, this.numFolds, this.numSplitsPerFeature, this.softTreeDepthLimit, this.softTreeDepthTolerance);
    }
}

