/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;

public class IndexLifecycleFeatureSetUsage
extends XPackFeatureSet.Usage {
    private List<PolicyStats> policyStats;

    public IndexLifecycleFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        if (input.readBoolean()) {
            this.policyStats = input.readList(PolicyStats::new);
        }
    }

    public Version getMinimalSupportedVersion() {
        return Version.V_6_6_0;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        boolean hasPolicyStats = this.policyStats != null;
        out.writeBoolean(hasPolicyStats);
        if (hasPolicyStats) {
            out.writeList(this.policyStats);
        }
    }

    public IndexLifecycleFeatureSetUsage() {
        this((List<PolicyStats>)null);
    }

    public IndexLifecycleFeatureSetUsage(List<PolicyStats> policyStats) {
        super("ilm", true, true);
        this.policyStats = policyStats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.policyStats != null) {
            builder.field("policy_count", this.policyStats.size());
            builder.xContentList("policy_stats", this.policyStats);
        }
    }

    public List<PolicyStats> getPolicyStats() {
        return this.policyStats;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.policyStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexLifecycleFeatureSetUsage other = (IndexLifecycleFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.policyStats, other.policyStats);
    }

    public static final class ActionConfigStats
    implements ToXContentObject,
    Writeable {
        private final Integer allocateNumberOfReplicas;
        private final Integer forceMergeMaxNumberOfSegments;
        private final TimeValue rolloverMaxAge;
        private final Long rolloverMaxDocs;
        private final ByteSizeValue rolloverMaxPrimaryShardSize;
        private final ByteSizeValue rolloverMaxSize;
        private final Integer setPriorityPriority;
        private final ByteSizeValue shrinkMaxPrimaryShardSize;
        private final Integer shrinkNumberOfShards;

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(ActionConfigStats existing) {
            return new Builder(existing);
        }

        public ActionConfigStats(Integer allocateNumberOfReplicas, Integer forceMergeMaxNumberOfSegments, TimeValue rolloverMaxAge, Long rolloverMaxDocs, ByteSizeValue rolloverMaxPrimaryShardSize, ByteSizeValue rolloverMaxSize, Integer setPriorityPriority, ByteSizeValue shrinkMaxPrimaryShardSize, Integer shrinkNumberOfShards) {
            this.allocateNumberOfReplicas = allocateNumberOfReplicas;
            this.forceMergeMaxNumberOfSegments = forceMergeMaxNumberOfSegments;
            this.rolloverMaxAge = rolloverMaxAge;
            this.rolloverMaxDocs = rolloverMaxDocs;
            this.rolloverMaxPrimaryShardSize = rolloverMaxPrimaryShardSize;
            this.rolloverMaxSize = rolloverMaxSize;
            this.setPriorityPriority = setPriorityPriority;
            this.shrinkMaxPrimaryShardSize = shrinkMaxPrimaryShardSize;
            this.shrinkNumberOfShards = shrinkNumberOfShards;
        }

        public ActionConfigStats(StreamInput in) throws IOException {
            this.allocateNumberOfReplicas = in.readOptionalVInt();
            this.forceMergeMaxNumberOfSegments = in.readOptionalVInt();
            this.rolloverMaxAge = in.readOptionalTimeValue();
            this.rolloverMaxDocs = in.readOptionalVLong();
            this.rolloverMaxPrimaryShardSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.rolloverMaxSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.setPriorityPriority = in.readOptionalVInt();
            this.shrinkMaxPrimaryShardSize = (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::new);
            this.shrinkNumberOfShards = in.readOptionalVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalVInt(this.allocateNumberOfReplicas);
            out.writeOptionalVInt(this.forceMergeMaxNumberOfSegments);
            out.writeOptionalTimeValue(this.rolloverMaxAge);
            out.writeOptionalVLong(this.rolloverMaxDocs);
            out.writeOptionalWriteable((Writeable)this.rolloverMaxPrimaryShardSize);
            out.writeOptionalWriteable((Writeable)this.rolloverMaxSize);
            out.writeOptionalVInt(this.setPriorityPriority);
            out.writeOptionalWriteable((Writeable)this.shrinkMaxPrimaryShardSize);
            out.writeOptionalVInt(this.shrinkNumberOfShards);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.allocateNumberOfReplicas != null) {
                builder.startObject("allocate");
                builder.field(AllocateAction.NUMBER_OF_REPLICAS_FIELD.getPreferredName(), this.allocateNumberOfReplicas);
                builder.endObject();
            }
            if (this.forceMergeMaxNumberOfSegments != null) {
                builder.startObject("forcemerge");
                builder.field(ForceMergeAction.MAX_NUM_SEGMENTS_FIELD.getPreferredName(), this.forceMergeMaxNumberOfSegments);
                builder.endObject();
            }
            if (this.rolloverMaxAge != null || this.rolloverMaxDocs != null || this.rolloverMaxSize != null || this.rolloverMaxPrimaryShardSize != null) {
                builder.startObject("rollover");
                if (this.rolloverMaxAge != null) {
                    builder.field(RolloverAction.MAX_AGE_FIELD.getPreferredName(), this.rolloverMaxAge.getStringRep());
                    builder.field(RolloverAction.MAX_AGE_FIELD.getPreferredName() + "_millis", this.rolloverMaxAge.getMillis());
                }
                if (this.rolloverMaxDocs != null) {
                    builder.field(RolloverAction.MAX_DOCS_FIELD.getPreferredName(), this.rolloverMaxDocs);
                }
                if (this.rolloverMaxSize != null) {
                    builder.field(RolloverAction.MAX_SIZE_FIELD.getPreferredName(), this.rolloverMaxSize.getStringRep());
                    builder.field(RolloverAction.MAX_SIZE_FIELD.getPreferredName() + "_bytes", this.rolloverMaxSize.getBytes());
                }
                if (this.rolloverMaxPrimaryShardSize != null) {
                    builder.field(RolloverAction.MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName(), this.rolloverMaxPrimaryShardSize.getStringRep());
                    builder.field(RolloverAction.MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName() + "_bytes", this.rolloverMaxPrimaryShardSize.getBytes());
                }
                builder.endObject();
            }
            if (this.setPriorityPriority != null) {
                builder.startObject("set_priority");
                builder.field(SetPriorityAction.RECOVERY_PRIORITY_FIELD.getPreferredName(), this.setPriorityPriority);
                builder.endObject();
            }
            if (this.shrinkMaxPrimaryShardSize != null || this.shrinkNumberOfShards != null) {
                builder.startObject("shrink");
                if (this.shrinkMaxPrimaryShardSize != null) {
                    builder.field(ShrinkAction.MAX_PRIMARY_SHARD_SIZE.getPreferredName(), this.shrinkMaxPrimaryShardSize.getStringRep());
                    builder.field(ShrinkAction.MAX_PRIMARY_SHARD_SIZE.getPreferredName() + "_bytes", this.shrinkMaxPrimaryShardSize.getBytes());
                }
                if (this.shrinkNumberOfShards != null) {
                    builder.field(ShrinkAction.NUMBER_OF_SHARDS_FIELD.getPreferredName(), this.shrinkNumberOfShards);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public Integer getAllocateNumberOfReplicas() {
            return this.allocateNumberOfReplicas;
        }

        public Integer getForceMergeMaxNumberOfSegments() {
            return this.forceMergeMaxNumberOfSegments;
        }

        public TimeValue getRolloverMaxAge() {
            return this.rolloverMaxAge;
        }

        public Long getRolloverMaxDocs() {
            return this.rolloverMaxDocs;
        }

        public ByteSizeValue getRolloverMaxPrimaryShardSize() {
            return this.rolloverMaxPrimaryShardSize;
        }

        public ByteSizeValue getRolloverMaxSize() {
            return this.rolloverMaxSize;
        }

        public Integer getSetPriorityPriority() {
            return this.setPriorityPriority;
        }

        public ByteSizeValue getShrinkMaxPrimaryShardSize() {
            return this.shrinkMaxPrimaryShardSize;
        }

        public Integer getShrinkNumberOfShards() {
            return this.shrinkNumberOfShards;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionConfigStats that = (ActionConfigStats)o;
            return Objects.equals(this.allocateNumberOfReplicas, that.allocateNumberOfReplicas) && Objects.equals(this.forceMergeMaxNumberOfSegments, that.forceMergeMaxNumberOfSegments) && Objects.equals(this.rolloverMaxAge, that.rolloverMaxAge) && Objects.equals(this.rolloverMaxDocs, that.rolloverMaxDocs) && Objects.equals(this.rolloverMaxPrimaryShardSize, that.rolloverMaxPrimaryShardSize) && Objects.equals(this.rolloverMaxSize, that.rolloverMaxSize) && Objects.equals(this.setPriorityPriority, that.setPriorityPriority) && Objects.equals(this.shrinkMaxPrimaryShardSize, that.shrinkMaxPrimaryShardSize) && Objects.equals(this.shrinkNumberOfShards, that.shrinkNumberOfShards);
        }

        public int hashCode() {
            return Objects.hash(this.allocateNumberOfReplicas, this.forceMergeMaxNumberOfSegments, this.rolloverMaxAge, this.rolloverMaxDocs, this.rolloverMaxPrimaryShardSize, this.rolloverMaxSize, this.setPriorityPriority, this.shrinkMaxPrimaryShardSize, this.shrinkNumberOfShards);
        }

        public static final class Builder {
            private Integer allocateNumberOfReplicas;
            private Integer forceMergeMaxNumberOfSegments;
            private TimeValue rolloverMaxAge;
            private Long rolloverMaxDocs;
            private ByteSizeValue rolloverMaxPrimaryShardSize;
            private ByteSizeValue rolloverMaxSize;
            private Integer setPriorityPriority;
            private ByteSizeValue shrinkMaxPrimaryShardSize;
            private Integer shrinkNumberOfShards;

            public Builder() {
            }

            public Builder(ActionConfigStats existing) {
                this.allocateNumberOfReplicas = existing.allocateNumberOfReplicas;
                this.forceMergeMaxNumberOfSegments = existing.forceMergeMaxNumberOfSegments;
                this.rolloverMaxAge = existing.rolloverMaxAge;
                this.rolloverMaxDocs = existing.rolloverMaxDocs;
                this.rolloverMaxPrimaryShardSize = existing.rolloverMaxPrimaryShardSize;
                this.rolloverMaxSize = existing.rolloverMaxSize;
                this.setPriorityPriority = existing.setPriorityPriority;
                this.shrinkMaxPrimaryShardSize = existing.shrinkMaxPrimaryShardSize;
                this.shrinkNumberOfShards = existing.shrinkNumberOfShards;
            }

            public Builder setAllocateNumberOfReplicas(Integer allocateNumberOfReplicas) {
                this.allocateNumberOfReplicas = allocateNumberOfReplicas;
                return this;
            }

            public Builder setForceMergeMaxNumberOfSegments(Integer forceMergeMaxNumberOfSegments) {
                this.forceMergeMaxNumberOfSegments = forceMergeMaxNumberOfSegments;
                return this;
            }

            public Builder setRolloverMaxAge(TimeValue rolloverMaxAge) {
                this.rolloverMaxAge = rolloverMaxAge;
                return this;
            }

            public Builder setRolloverMaxDocs(Long rolloverMaxDocs) {
                this.rolloverMaxDocs = rolloverMaxDocs;
                return this;
            }

            public Builder setRolloverMaxPrimaryShardSize(ByteSizeValue rolloverMaxPrimaryShardSize) {
                this.rolloverMaxPrimaryShardSize = rolloverMaxPrimaryShardSize;
                return this;
            }

            public Builder setRolloverMaxSize(ByteSizeValue rolloverMaxSize) {
                this.rolloverMaxSize = rolloverMaxSize;
                return this;
            }

            public Builder setPriority(Integer priority) {
                this.setPriorityPriority = priority;
                return this;
            }

            public Builder setShrinkMaxPrimaryShardSize(ByteSizeValue shrinkMaxPrimaryShardSize) {
                this.shrinkMaxPrimaryShardSize = shrinkMaxPrimaryShardSize;
                return this;
            }

            public Builder setShrinkNumberOfShards(Integer shrinkNumberOfShards) {
                this.shrinkNumberOfShards = shrinkNumberOfShards;
                return this;
            }

            public ActionConfigStats build() {
                return new ActionConfigStats(this.allocateNumberOfReplicas, this.forceMergeMaxNumberOfSegments, this.rolloverMaxAge, this.rolloverMaxDocs, this.rolloverMaxPrimaryShardSize, this.rolloverMaxSize, this.setPriorityPriority, this.shrinkMaxPrimaryShardSize, this.shrinkNumberOfShards);
            }
        }
    }

    public static final class PhaseStats
    implements ToXContentObject,
    Writeable {
        public static final ParseField CONFIGURATIONS_FIELD = new ParseField("configurations", new String[0]);
        private final String[] actionNames;
        private final ActionConfigStats configurations;
        private final TimeValue minimumAge;

        public PhaseStats(TimeValue after, String[] actionNames, ActionConfigStats configurations) {
            this.actionNames = Objects.requireNonNull(actionNames, "Missing required action names");
            this.configurations = Objects.requireNonNull(configurations, "Missing required action configurations");
            this.minimumAge = Objects.requireNonNull(after, "Missing required minimum age");
        }

        public PhaseStats(StreamInput in) throws IOException {
            this.actionNames = in.readStringArray();
            this.minimumAge = in.readTimeValue();
            this.configurations = in.getVersion().onOrAfter(Version.V_7_15_0) ? new ActionConfigStats(in) : ActionConfigStats.builder().build();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.actionNames);
            out.writeTimeValue(this.minimumAge);
            if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
                this.configurations.writeTo(out);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Phase.MIN_AGE.getPreferredName(), this.minimumAge.getMillis());
            builder.field(Phase.ACTIONS_FIELD.getPreferredName(), (Object)this.actionNames);
            builder.field(CONFIGURATIONS_FIELD.getPreferredName(), (ToXContent)this.configurations);
            builder.endObject();
            return builder;
        }

        public String[] getActionNames() {
            return this.actionNames;
        }

        public TimeValue getAfter() {
            return this.minimumAge;
        }

        public ActionConfigStats getConfigurations() {
            return this.configurations;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.actionNames), this.configurations, this.minimumAge);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PhaseStats other = (PhaseStats)obj;
            return Objects.equals(this.minimumAge, other.minimumAge) && Objects.deepEquals(this.configurations, other.configurations) && Objects.deepEquals(this.actionNames, other.actionNames);
        }
    }

    public static final class PolicyStats
    implements ToXContentObject,
    Writeable {
        public static final ParseField INDICES_MANAGED_FIELD = new ParseField("indices_managed", new String[0]);
        private final Map<String, PhaseStats> phaseStats;
        private final int indicesManaged;

        public PolicyStats(Map<String, PhaseStats> phaseStats, int numberIndicesManaged) {
            this.phaseStats = phaseStats;
            this.indicesManaged = numberIndicesManaged;
        }

        public PolicyStats(StreamInput in) throws IOException {
            this.phaseStats = in.readMap(StreamInput::readString, PhaseStats::new);
            this.indicesManaged = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.phaseStats, StreamOutput::writeString, (o, p) -> p.writeTo(o));
            out.writeVInt(this.indicesManaged);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(LifecyclePolicy.PHASES_FIELD.getPreferredName(), this.phaseStats);
            builder.field(INDICES_MANAGED_FIELD.getPreferredName(), this.indicesManaged);
            builder.endObject();
            return builder;
        }

        public Map<String, PhaseStats> getPhaseStats() {
            return this.phaseStats;
        }

        public int getIndicesManaged() {
            return this.indicesManaged;
        }

        public int hashCode() {
            return Objects.hash(this.phaseStats, this.indicesManaged);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PolicyStats other = (PolicyStats)obj;
            return Objects.equals(this.phaseStats, other.phaseStats) && Objects.equals(this.indicesManaged, other.indicesManaged);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

