/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.TransportReloadAnalyzersAction;

public class ReloadAnalyzersResponse
extends BroadcastResponse {
    private final Map<String, ReloadDetails> reloadDetails;
    private static final ParseField RELOAD_DETAILS_FIELD = new ParseField("reload_details", new String[0]);
    private static final ParseField INDEX_FIELD = new ParseField("index", new String[0]);
    private static final ParseField RELOADED_ANALYZERS_FIELD = new ParseField("reloaded_analyzers", new String[0]);
    private static final ParseField RELOADED_NODE_IDS_FIELD = new ParseField("reloaded_node_ids", new String[0]);
    private static final ConstructingObjectParser<ReloadAnalyzersResponse, Void> PARSER = new ConstructingObjectParser("reload_analyzer", true, arg -> {
        BroadcastResponse response = (BroadcastResponse)arg[0];
        List results = (List)arg[1];
        HashMap<String, ReloadDetails> reloadedNodeIds = new HashMap<String, ReloadDetails>();
        for (ReloadDetails result : results) {
            reloadedNodeIds.put(result.getIndexName(), result);
        }
        return new ReloadAnalyzersResponse(response.getTotalShards(), response.getSuccessfulShards(), response.getFailedShards(), Arrays.asList(response.getShardFailures()), reloadedNodeIds);
    });
    private static final ConstructingObjectParser<ReloadDetails, Void> ENTRY_PARSER = new ConstructingObjectParser("reload_analyzer.entry", true, arg -> new ReloadDetails((String)arg[0], new HashSet<String>((List)arg[1]), new HashSet<String>((List)arg[2])));

    public ReloadAnalyzersResponse(StreamInput in) throws IOException {
        super(in);
        this.reloadDetails = in.readMap(StreamInput::readString, ReloadDetails::new);
    }

    public ReloadAnalyzersResponse(int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Map<String, ReloadDetails> reloadedIndicesNodes) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.reloadDetails = reloadedIndicesNodes;
    }

    public final Map<String, ReloadDetails> getReloadDetails() {
        return this.reloadDetails;
    }

    protected void addCustomXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(RELOAD_DETAILS_FIELD.getPreferredName());
        for (Map.Entry<String, ReloadDetails> indexDetails : this.reloadDetails.entrySet()) {
            builder.startObject();
            ReloadDetails value = indexDetails.getValue();
            builder.field(INDEX_FIELD.getPreferredName(), value.getIndexName());
            builder.stringListField(RELOADED_ANALYZERS_FIELD.getPreferredName(), value.getReloadedAnalyzers());
            builder.stringListField(RELOADED_NODE_IDS_FIELD.getPreferredName(), value.getReloadedIndicesNodes());
            builder.endObject();
        }
        builder.endArray();
    }

    public static ReloadAnalyzersResponse fromXContent(XContentParser parser) {
        return (ReloadAnalyzersResponse)((Object)PARSER.apply(parser, null));
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeMap(this.reloadDetails, StreamOutput::writeString, (stream, details) -> details.writeTo(stream));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReloadAnalyzersResponse that = (ReloadAnalyzersResponse)((Object)o);
        return Objects.equals(this.reloadDetails, that.reloadDetails);
    }

    public int hashCode() {
        return Objects.hash(this.reloadDetails);
    }

    static {
        ReloadAnalyzersResponse.declareBroadcastFields(PARSER);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), ENTRY_PARSER, RELOAD_DETAILS_FIELD);
        ENTRY_PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_FIELD);
        ENTRY_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), RELOADED_ANALYZERS_FIELD);
        ENTRY_PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), RELOADED_NODE_IDS_FIELD);
    }

    public static class ReloadDetails
    implements Writeable {
        private final String indexName;
        private final Set<String> reloadedIndicesNodes;
        private final Set<String> reloadedAnalyzers;

        public ReloadDetails(String name, Set<String> reloadedIndicesNodes, Set<String> reloadedAnalyzers) {
            this.indexName = name;
            this.reloadedIndicesNodes = reloadedIndicesNodes;
            this.reloadedAnalyzers = reloadedAnalyzers;
        }

        ReloadDetails(StreamInput in) throws IOException {
            this.indexName = in.readString();
            this.reloadedIndicesNodes = new HashSet<String>(in.readList(StreamInput::readString));
            this.reloadedAnalyzers = new HashSet<String>(in.readList(StreamInput::readString));
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.indexName);
            out.writeStringCollection(this.reloadedIndicesNodes);
            out.writeStringCollection(this.reloadedAnalyzers);
        }

        public String getIndexName() {
            return this.indexName;
        }

        public Set<String> getReloadedIndicesNodes() {
            return this.reloadedIndicesNodes;
        }

        public Set<String> getReloadedAnalyzers() {
            return this.reloadedAnalyzers;
        }

        void merge(TransportReloadAnalyzersAction.ReloadResult other) {
            assert (this.indexName.equals(other.index));
            this.reloadedAnalyzers.addAll(other.reloadedSearchAnalyzers);
            this.reloadedIndicesNodes.add(other.nodeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReloadDetails that = (ReloadDetails)o;
            return Objects.equals(this.indexName, that.indexName) && Objects.equals(this.reloadedIndicesNodes, that.reloadedIndicesNodes) && Objects.equals(this.reloadedAnalyzers, that.reloadedAnalyzers);
        }

        public int hashCode() {
            return Objects.hash(this.indexName, this.reloadedIndicesNodes, this.reloadedAnalyzers);
        }
    }
}

