/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.ir.ExpressionNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;

public class MapInitializationNode
extends ExpressionNode {
    private final List<ExpressionNode> keyNodes = new ArrayList<ExpressionNode>();
    private final List<ExpressionNode> valueNodes = new ArrayList<ExpressionNode>();

    public void addArgumentNode(ExpressionNode keyNode, ExpressionNode valueNode) {
        this.keyNodes.add(keyNode);
        this.valueNodes.add(valueNode);
    }

    public ExpressionNode getKeyNode(int index) {
        return this.keyNodes.get(index);
    }

    public ExpressionNode getValueNode(int index) {
        return this.valueNodes.get(index);
    }

    public int getArgumentsSize() {
        return this.keyNodes.size();
    }

    public List<ExpressionNode> getKeyNodes() {
        return this.keyNodes;
    }

    public List<ExpressionNode> getValueNodes() {
        return this.valueNodes;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitMapInitialization(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        for (ExpressionNode keyNode : this.keyNodes) {
            keyNode.visit(irTreeVisitor, scope);
        }
        for (ExpressionNode valueNode : this.valueNodes) {
            valueNode.visit(irTreeVisitor, scope);
        }
    }

    public MapInitializationNode(Location location) {
        super(location);
    }
}

