/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.shutdown;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentParser;

public class PutShutdownNodeAction
extends ActionType<AcknowledgedResponse> {
    public static final PutShutdownNodeAction INSTANCE = new PutShutdownNodeAction();
    public static final String NAME = "cluster:admin/shutdown/create";

    public PutShutdownNodeAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String nodeId;
        private final SingleNodeShutdownMetadata.Type type;
        private final String reason;
        @Nullable
        private final TimeValue allocationDelay;
        @Nullable
        private final String targetNodeName;
        private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
        private static final ParseField REASON_FIELD = new ParseField("reason", new String[0]);
        private static final ParseField ALLOCATION_DELAY_FIELD = new ParseField("allocation_delay", new String[0]);
        private static final ParseField TARGET_NODE_FIELD = new ParseField("target_node_name", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_node_shutdown_request", false, (a, nodeId) -> new Request((String)nodeId, SingleNodeShutdownMetadata.Type.parse((String)((String)a[0])), (String)a[1], a[2] == null ? null : TimeValue.parseTimeValue((String)((String)a[2]), (String)("put-shutdown-node-request-" + nodeId)), (String)a[3]));

        public static Request parseRequest(String nodeId, XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, (Object)nodeId));
        }

        public Request(String nodeId, SingleNodeShutdownMetadata.Type type, String reason, @Nullable TimeValue allocationDelay, @Nullable String targetNodeName) {
            this.nodeId = nodeId;
            this.type = type;
            this.reason = reason;
            this.allocationDelay = allocationDelay;
            this.targetNodeName = targetNodeName;
        }

        public Request(StreamInput in) throws IOException {
            this.nodeId = in.readString();
            this.type = (SingleNodeShutdownMetadata.Type)in.readEnum(SingleNodeShutdownMetadata.Type.class);
            this.reason = in.readString();
            this.allocationDelay = in.readOptionalTimeValue();
            this.targetNodeName = in.getVersion().onOrAfter(SingleNodeShutdownMetadata.REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) ? in.readOptionalString() : null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            if (out.getVersion().before(SingleNodeShutdownMetadata.REPLACE_SHUTDOWN_TYPE_ADDED_VERSION) && this.type == SingleNodeShutdownMetadata.Type.REPLACE) {
                out.writeEnum((Enum)SingleNodeShutdownMetadata.Type.REMOVE);
            } else {
                out.writeEnum((Enum)this.type);
            }
            out.writeString(this.reason);
            out.writeOptionalTimeValue(this.allocationDelay);
            if (out.getVersion().onOrAfter(SingleNodeShutdownMetadata.REPLACE_SHUTDOWN_TYPE_ADDED_VERSION)) {
                out.writeOptionalString(this.targetNodeName);
            }
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public SingleNodeShutdownMetadata.Type getType() {
            return this.type;
        }

        public String getReason() {
            return this.reason;
        }

        public TimeValue getAllocationDelay() {
            return this.allocationDelay;
        }

        public String getTargetNodeName() {
            return this.targetNodeName;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException arve = new ActionRequestValidationException();
            if (!Strings.hasText((String)this.nodeId)) {
                arve.addValidationError("the node id to shutdown is required");
            }
            if (this.type == null) {
                arve.addValidationError("the shutdown type is required");
            }
            if (!Strings.hasText((String)this.nodeId)) {
                arve.addValidationError("the reason for shutdown is required");
            }
            if (this.allocationDelay != null && !SingleNodeShutdownMetadata.Type.RESTART.equals((Object)this.type)) {
                arve.addValidationError(ALLOCATION_DELAY_FIELD + " is only allowed for RESTART-type shutdown requests");
            }
            if (this.targetNodeName != null && this.type != SingleNodeShutdownMetadata.Type.REPLACE) {
                arve.addValidationError(new ParameterizedMessage("target node name is only valid for REPLACE type shutdowns, but was given type [{}] and target node name [{}]", (Object)this.type, (Object)this.targetNodeName).getFormattedMessage());
            } else if (this.targetNodeName == null && this.type == SingleNodeShutdownMetadata.Type.REPLACE) {
                arve.addValidationError("target node name is required for REPLACE type shutdowns");
            }
            if (!arve.validationErrors().isEmpty()) {
                return arve;
            }
            return null;
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), TYPE_FIELD);
            PARSER.declareString(ConstructingObjectParser.constructorArg(), REASON_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), ALLOCATION_DELAY_FIELD);
            PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TARGET_NODE_FIELD);
        }
    }
}

