/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.ttest;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.xpack.analytics.ttest.TTestStats;

public class TTestStatsBuilder
implements Releasable {
    private LongArray counts;
    private DoubleArray sums;
    private DoubleArray compensations;
    private DoubleArray sumOfSqrs;
    private DoubleArray sumOfSqrCompensations;

    TTestStatsBuilder(BigArrays bigArrays) {
        this.counts = bigArrays.newLongArray(1L, true);
        boolean success = false;
        try {
            this.sums = bigArrays.newDoubleArray(1L, true);
            this.compensations = bigArrays.newDoubleArray(1L, true);
            this.sumOfSqrs = bigArrays.newDoubleArray(1L, true);
            this.sumOfSqrCompensations = bigArrays.newDoubleArray(1L, true);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public TTestStats get(long bucket) {
        return new TTestStats(this.counts.get(bucket), this.sums.get(bucket), this.sumOfSqrs.get(bucket));
    }

    public long build(long bucket) {
        return this.counts.get(bucket);
    }

    public long getSize() {
        return this.counts.size();
    }

    public void grow(BigArrays bigArrays, long buckets) {
        if (buckets >= this.counts.size()) {
            long overSize = BigArrays.overSize((long)buckets);
            this.counts = bigArrays.resize(this.counts, overSize);
            this.sums = bigArrays.resize(this.sums, overSize);
            this.compensations = bigArrays.resize(this.compensations, overSize);
            this.sumOfSqrs = bigArrays.resize(this.sumOfSqrs, overSize);
            this.sumOfSqrCompensations = bigArrays.resize(this.sumOfSqrCompensations, overSize);
        }
    }

    public void addValue(CompensatedSum compSum, CompensatedSum compSumOfSqr, long bucket, double val) {
        this.counts.increment(bucket, 1L);
        double sum = this.sums.get(bucket);
        double compensation = this.compensations.get(bucket);
        compSum.reset(sum, compensation);
        double sumOfSqr = this.sumOfSqrs.get(bucket);
        double sumOfSqrCompensation = this.sumOfSqrCompensations.get(bucket);
        compSumOfSqr.reset(sumOfSqr, sumOfSqrCompensation);
        compSum.add(val);
        compSumOfSqr.add(val * val);
        this.sums.set(bucket, compSum.value());
        this.compensations.set(bucket, compSum.delta());
        this.sumOfSqrs.set(bucket, compSumOfSqr.value());
        this.sumOfSqrCompensations.set(bucket, compSumOfSqr.delta());
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.sums, this.compensations, this.sumOfSqrs, this.sumOfSqrCompensations});
    }
}

