/*
 * Decompiled with CFR 0.152.
 */
package org.myworldgis.netlogo;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.util.GeometryTransformer;
import org.myworldgis.netlogo.GISExtension;
import org.myworldgis.projection.Ellipsoid;
import org.myworldgis.projection.Geographic;
import org.myworldgis.projection.Projection;
import org.ngs.ngunits.NonSI;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.quantity.Angle;
import org.ngs.ngunits.quantity.Length;
import org.nlogo.api.Argument;
import org.nlogo.api.Context;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;

public strictfp abstract class ProjectLatLon {
    public static Object projectPointGivenEllipsoid(double lat, double lon, Ellipsoid srcEllipsoid) throws ExtensionException, LogoException {
        Coordinate projected;
        boolean shouldReproject;
        LogoListBuilder result = new LogoListBuilder();
        if (lat > 90.0 || lat < -90.0 || lon > 180.0 || lon < -180.0) {
            return result.toLogoList();
        }
        Projection dstProj = GISExtension.getState().getProjection();
        if (dstProj == null) {
            throw new ExtensionException("You must use gis:load-coordinate-system or gis:set-coordinate-system before you can project lat/lon pairs.");
        }
        Point point = GISExtension.getState().factory().createPoint(new Coordinate(lon, lat));
        if (point == null) {
            return result.toLogoList();
        }
        Ellipsoid dstEllipsoid = dstProj.getEllipsoid();
        boolean bl = shouldReproject = !(dstProj instanceof Geographic) || !srcEllipsoid.equals(dstEllipsoid);
        if (shouldReproject) {
            GeometryTransformer forward = dstProj.getForwardTransformer();
            GeometryTransformer inverse = new Geographic(srcEllipsoid, Projection.DEFAULT_CENTER, (Unit<Angle>)NonSI.DEGREE_ANGLE).getInverseTransformer();
            point = forward.transform(inverse.transform((Geometry)point));
        }
        if ((projected = point.getCoordinate()) == null) {
            return result.toLogoList();
        }
        Coordinate transformed = GISExtension.getState().gisToNetLogo(projected, null);
        if (transformed != null) {
            result.add((Object)transformed.x);
            result.add((Object)transformed.y);
        }
        return result.toLogoList();
    }

    public strictfp static final class ProjectWGS84
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            double lat = args[0].getDoubleValue();
            double lon = args[1].getDoubleValue();
            return ProjectLatLon.projectPointGivenEllipsoid(lat, lon, Ellipsoid.WGS_84);
        }
    }

    public strictfp static final class ProjectFromEllipsoid
    extends GISExtension.Reporter {
        public String getAgentClassString() {
            return "OTPL";
        }

        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType(), Syntax.NumberType()}, (int)Syntax.ListType());
        }

        @Override
        public Object reportInternal(Argument[] args, Context context) throws ExtensionException, LogoException {
            double lat = args[0].getDoubleValue();
            double lon = args[1].getDoubleValue();
            double ellispoidRadius = args[2].getDoubleValue();
            double ellispoidInverseFlattening = args[3].getDoubleValue();
            Ellipsoid srcEllipsoid = new Ellipsoid("user", ellispoidRadius, (Unit<Length>)SI.METER, ellispoidInverseFlattening);
            return ProjectLatLon.projectPointGivenEllipsoid(lat, lon, srcEllipsoid);
        }
    }
}

