/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.sdm.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jhotdraw.figures.RectangleFigure;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureAttributeConstant;
import org.jhotdraw.framework.HandleEnumeration;
import org.jhotdraw.standard.HandleEnumerator;
import org.jhotdraw.standard.NullHandle;
import org.jhotdraw.standard.RelativeLocator;
import org.jhotdraw.util.StorableInput;
import org.jhotdraw.util.StorableOutput;
import org.nlogo.api.Editable;
import org.nlogo.api.Property;
import org.nlogo.sdm.ModelElement;
import org.nlogo.sdm.Stock;
import org.nlogo.sdm.gui.ModelElementFigure;
import org.nlogo.sdm.gui.Properties;
import org.nlogo.sdm.gui.WrappedStock;
import org.nlogo.sdm.gui.Wrapper;
import org.nlogo.window.InterfaceColors;
import scala.Option;

public strictfp class StockFigure
extends RectangleFigure
implements ModelElementFigure,
Editable {
    private Stock stock;
    private boolean dirty = false;

    public StockFigure() {
        this.setAttribute(FigureAttributeConstant.FILL_COLOR, InterfaceColors.MONITOR_BACKGROUND);
        this.stock = new Stock();
    }

    @Override
    public ModelElement getModelElement() {
        return this.stock;
    }

    @Override
    public boolean anyErrors() {
        return false;
    }

    @Override
    public void error(Object o, Exception e) {
    }

    @Override
    public Exception error(Object key) {
        return null;
    }

    @Override
    public int sourceOffset() {
        return 0;
    }

    public void draw(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.draw(g);
        if (this.stock != null) {
            String name;
            Color oldColor = g.getColor();
            if (!this.stock.isComplete()) {
                g.setColor(Color.RED);
            }
            if ((name = this.stock.getName()).length() == 0) {
                name = "?";
            }
            Font oldFont = g.getFont();
            g.setFont(oldFont.deriveFont(1));
            int height = g.getFontMetrics().getMaxAscent() + g.getFontMetrics().getMaxDescent();
            int width = g.getFontMetrics().stringWidth(this.stock.getName());
            g.drawString(name, this.displayBox().x + (this.displayBox().width - width) / 2, this.displayBox().y + (this.displayBox().height - height) / 2 + g.getFontMetrics().getMaxAscent());
            g.setFont(oldFont);
            g.setColor(oldColor);
        }
    }

    protected Rectangle invalidateRectangle(Rectangle r) {
        Rectangle box = super.invalidateRectangle(r);
        box.grow(50, 50);
        return box;
    }

    public Rectangle displayBox() {
        Rectangle box = super.displayBox();
        box.grow(12, 12);
        return box;
    }

    public HandleEnumeration handles() {
        ArrayList<NullHandle> handles = new ArrayList<NullHandle>();
        handles.add(new NullHandle((Figure)this, RelativeLocator.southEast()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.southWest()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.northEast()));
        handles.add(new NullHandle((Figure)this, RelativeLocator.northWest()));
        return new HandleEnumerator(handles);
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeStorable(Wrapper.wrap(this.stock));
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.stock = ((WrappedStock)dr.readStorable()).stock;
    }

    @Override
    public Option<String> helpLink() {
        return Option.apply(null);
    }

    @Override
    public List<Property> propertySet() {
        return Properties.stock();
    }

    @Override
    public String classDisplayName() {
        return "Stock";
    }

    @Override
    public boolean editFinished() {
        return true;
    }

    @Override
    public boolean dirty() {
        return this.dirty;
    }

    public void nameWrapper(String name) {
        this.dirty = this.dirty || !this.stock.getName().equals(name);
        this.stock.setName(name);
    }

    public String nameWrapper() {
        return this.stock.getName();
    }

    public void initialValueExpressionWrapper(String expression) {
        this.dirty = this.dirty || !this.stock.getInitialValueExpression().equals(expression);
        this.stock.setInitialValueExpression(expression);
    }

    public String initialValueExpressionWrapper() {
        return this.stock.getInitialValueExpression();
    }

    public boolean allowNegative() {
        return !this.stock.isNonNegative();
    }

    public void allowNegative(boolean b) {
        this.dirty = this.dirty || this.stock.isNonNegative() == b;
        this.stock.setNonNegative(!b);
    }
}

