/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.mc;

import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.nlogo.api.ModelingCommonsInterface;
import org.nlogo.mc.DownloadGroupsRequest;
import org.nlogo.mc.DownloadNewUserParametersRequest;
import org.nlogo.mc.Group;
import org.nlogo.mc.Image;
import org.nlogo.mc.ImageException;
import org.nlogo.mc.LoginDialog;
import org.nlogo.mc.NewUserDialog;
import org.nlogo.mc.Person;
import org.nlogo.mc.Request;
import org.nlogo.mc.UploadDialog;
import org.nlogo.mc.UploadSuccessDialog;
import org.nlogo.workspace.WorkspaceFactory;
import scala.Function0;

public strictfp class ModelingCommons
implements ModelingCommonsInterface {
    public static final String HOST = "http://modelingcommons.org";
    private static HttpClient http = new DefaultHttpClient();
    private Person person;
    private String newUserAgreement;
    private List<String> priorityCountries;
    private List<String> unpriorityCountries;
    private List<Group> groups;
    private Function0<String> saveModel;
    private Frame frame;
    private Function0<BufferedImage> imageSource;
    private Function0<Boolean> setupAndGoExist;
    WorkspaceFactory workspaceFactory;

    public ModelingCommons(Function0<String> saveModel, Frame frame, Function0<BufferedImage> imageSource, Function0<Boolean> setupAndGoExist, WorkspaceFactory workspaceFactory) {
        this.frame = frame;
        this.saveModel = saveModel;
        this.imageSource = imageSource;
        this.setupAndGoExist = setupAndGoExist;
        this.workspaceFactory = workspaceFactory;
    }

    public boolean isLoggedIn() {
        return this.person != null;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<String> getPriorityCountries() {
        return this.priorityCountries;
    }

    public List<String> getUnpriorityCountries() {
        return this.unpriorityCountries;
    }

    public String getNewUserAgreement() {
        return this.newUserAgreement;
    }

    public Person getPerson() {
        return this.person;
    }

    public String getModelBody() {
        return this.saveModel.apply();
    }

    void setPerson(Person person) {
        this.person = person;
    }

    public void promptForLogin(String error) {
        LoginDialog loginDialog = new LoginDialog(this.frame, this, error);
        loginDialog.setVisible(true);
    }

    public void promptForLogin() {
        this.promptForLogin(" ");
    }

    public void promptForUpload(String error) {
        this.promptForUpload(error, true);
    }

    public void promptForUpload() {
        this.promptForUpload(" ", true);
    }

    void promptForUpload(final String error, boolean downloadGroups) {
        if (downloadGroups) {
            DownloadGroupsRequest request = new DownloadGroupsRequest(this.getHttpClient(), this.frame){

                @Override
                protected void onDownloaded(String status, List<Group> groups) {
                    if (status.equals("SUCCESS")) {
                        ModelingCommons.this.groups = groups;
                        boolean enableAutoGeneratePreviewImage = (Boolean)ModelingCommons.this.setupAndGoExist.apply();
                        UploadDialog uploadDialog = new UploadDialog(ModelingCommons.this.frame, ModelingCommons.this, error, enableAutoGeneratePreviewImage);
                        uploadDialog.setVisible(true);
                    } else if (status.equals("INVALID_RESPONSE_FROM_SERVER")) {
                        ModelingCommons.this.promptForLogin("Invalid response from Modeling Commons");
                    } else if (status.equals("CONNECTION_ERROR")) {
                        ModelingCommons.this.promptForLogin("Could not connect to Modeling Commons");
                    }
                }
            };
            ((Request)request).execute();
        } else {
            boolean enableAutoGeneratePreviewImage = this.setupAndGoExist.apply();
            UploadDialog uploadDialog = new UploadDialog(this.frame, this, error, enableAutoGeneratePreviewImage);
            uploadDialog.setVisible(true);
        }
    }

    public void promptForSuccess(String error, String uploadedModelURL, String uploadedModelName) {
        UploadSuccessDialog successDialog = new UploadSuccessDialog(this.frame, this, error, uploadedModelURL, uploadedModelName);
        successDialog.setVisible(true);
    }

    public void promptForSuccess(String uploadedModelURL, String uploadedModelName) {
        this.promptForSuccess(" ", uploadedModelURL, uploadedModelName);
    }

    public void promptForCreateAccount(final String error) {
        DownloadNewUserParametersRequest request = new DownloadNewUserParametersRequest(this.getHttpClient(), this.frame){

            @Override
            protected void onDownloaded(String status, String newUserAgreement, List<String> priorityCountries, List<String> unpriorityCountries) {
                if (status.equals("SUCCESS")) {
                    ModelingCommons.this.newUserAgreement = newUserAgreement;
                    ModelingCommons.this.priorityCountries = priorityCountries;
                    ModelingCommons.this.unpriorityCountries = unpriorityCountries;
                    NewUserDialog createAccountDialog = new NewUserDialog(ModelingCommons.this.frame, ModelingCommons.this, error);
                    createAccountDialog.setVisible(true);
                } else if (status.equals("INVALID_RESPONSE_FROM_SERVER")) {
                    ModelingCommons.this.promptForLogin("Invalid response from Modeling Commons");
                } else if (status.equals("CONNECTION_ERROR")) {
                    ModelingCommons.this.promptForLogin("Could not connect to Modeling Commons");
                }
            }
        };
        ((Request)request).execute();
    }

    public void promptForCreateAccount() {
        this.promptForCreateAccount(" ");
    }

    @Override
    public void saveToModelingCommons() {
        if (!this.isLoggedIn()) {
            this.promptForLogin();
        } else {
            this.promptForUpload();
        }
    }

    public Image getCurrentModelViewImage() {
        return new Image(){

            @Override
            public BufferedImage getImage() throws ImageException {
                return (BufferedImage)ModelingCommons.this.imageSource.apply();
            }
        };
    }

    HttpClient getHttpClient() {
        return http;
    }
}

