/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.gl.render;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUtessellator;
import java.io.Serializable;
import java.nio.FloatBuffer;
import org.nlogo.gl.render.Tessellator;
import org.nlogo.shape.Polygon;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1$mcVI$sp;

public final class Polygons$ {
    public static Polygons$ MODULE$;

    static {
        new Polygons$();
    }

    public void renderPolygon(GL2 gl, GLU glu, Tessellator tessellator, GLUtessellator tess, int offset, Polygon poly, boolean rotatable, boolean is3D) {
        float zDepth = 0.01f + (float)offset * 1.0E-4f;
        if (!poly.marked()) {
            float[] rgb = poly.awtColor().getRGBColorComponents(null);
            gl.glPushAttrib(1);
            gl.glColor3fv(FloatBuffer.wrap(rgb));
        }
        if (!poly.filled()) {
            gl.glPolygonMode(1032, 6913);
        }
        gl.glDisable(2884);
        Tessellator.TessDataObject data = tessellator.createTessDataObject(gl);
        Seq<Object> xcoords = poly.xCoords();
        Seq<Object> ycoords = poly.yCoords();
        if (is3D) {
            this.renderPolygon3D(gl, glu, tess, data, xcoords, ycoords, zDepth, rotatable);
        } else {
            this.renderPolygon2D(gl, glu, tess, data, xcoords, ycoords, zDepth, rotatable);
        }
        if (!poly.filled()) {
            gl.glPolygonMode(1032, 6914);
        }
        if (rotatable) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), xcoords.size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
                void var11_9;
                void var9_8;
                void var7_7;
                float[] coords = (float[])Array$.MODULE$.apply(Predef$.MODULE$.wrapFloatArray(new float[]{(float)BoxesRunTime.unboxToInt(xcoords.apply(i)) * 0.001f - 0.15f, (float)(300 - BoxesRunTime.unboxToInt(ycoords.apply(i))) * 0.001f - 0.15f, (float)BoxesRunTime.unboxToInt(xcoords.apply((i + 1) % xcoords.size())) * 0.001f - 0.15f, (float)(300 - BoxesRunTime.unboxToInt(ycoords.apply((i + 1) % xcoords.size()))) * 0.001f - 0.15f}), ClassTag$.MODULE$.Float());
                gl.glBegin(7);
                Tuple3<Object, Object, Object> tuple3 = MODULE$.findNormal(coords[0], coords[1], -zDepth, coords[0], coords[1], zDepth, coords[2], coords[3], zDepth);
                if (tuple3 == null) {
                    throw new MatchError((Object)null);
                }
                double normalX = BoxesRunTime.unboxToDouble(tuple3._1());
                double normalY = BoxesRunTime.unboxToDouble(tuple3._2());
                double normalZ = BoxesRunTime.unboxToDouble(tuple3._3());
                gl.glNormal3d((double)var7_7, (double)var9_8, (double)var11_9);
                gl.glVertex3f(coords[0], coords[1], -zDepth);
                gl.glVertex3f(coords[0], coords[1], zDepth);
                gl.glVertex3f(coords[2], coords[3], zDepth);
                gl.glVertex3f(coords[2], coords[3], -zDepth);
                gl.glEnd();
            });
        }
        gl.glEnable(2884);
        if (!poly.marked()) {
            gl.glPopAttrib();
        }
    }

    private void renderPolygon2D(GL2 gl, GLU glu, GLUtessellator tess, Tessellator.TessDataObject data, Seq<Object> xcoords, Seq<Object> ycoords, float zDepth, boolean rotatable) {
        GLU.gluTessBeginPolygon((GLUtessellator)tess, (Object)data);
        GLU.gluTessBeginContour((GLUtessellator)tess);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), xcoords.size()).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
            double[] coords = (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{(double)BoxesRunTime.unboxToInt(xcoords.apply(i)) * 0.001 - 0.15, (double)(300 - BoxesRunTime.unboxToInt(ycoords.apply(i))) * 0.001 - 0.15, zDepth}), ClassTag$.MODULE$.Double());
            GLU.gluTessVertex((GLUtessellator)tess, (double[])coords, (int)0, (Object)coords);
        });
        GLU.gluTessEndContour((GLUtessellator)tess);
        GLU.gluTessEndPolygon((GLUtessellator)tess);
    }

    private void renderPolygon3D(GL2 gl, GLU glu, GLUtessellator tess, Tessellator.TessDataObject data, Seq<Object> xcoords, Seq<Object> ycoords, float zDepth, boolean rotatable) {
        GLU.gluTessBeginPolygon((GLUtessellator)tess, (Object)data);
        GLU.gluTessBeginContour((GLUtessellator)tess);
        ((TraversableLike)xcoords.zip(ycoords, Seq$.MODULE$.canBuildFrom())).withFilter((Function1<Tuple2, Object> & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(bl = check$ifrefutable$1 != null)).foreach((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> {
            Polygons$.$anonfun$renderPolygon3D$2(zDepth, tess, x$2);
            return BoxedUnit.UNIT;
        });
        GLU.gluTessEndContour((GLUtessellator)tess);
        GLU.gluTessEndPolygon((GLUtessellator)tess);
        if (rotatable) {
            gl.glBegin(data.tpe());
            gl.glNormal3f(0.0f, 0.0f, -1.0f);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(data.shapeData()).asScala()).foreach((Function1<Object, Object> & Serializable & scala.Serializable)element -> {
                Polygons$.$anonfun$renderPolygon3D$3(data, zDepth, gl, element);
                return BoxedUnit.UNIT;
            });
            gl.glEnd();
        }
    }

    private Tuple3<Object, Object, Object> findNormal(float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        float vectX1 = x1 - x2;
        float vectY1 = y1 - y2;
        float vectZ1 = z1 - z2;
        float vectX2 = x3 - x2;
        float vectY2 = y3 - y2;
        float vectZ2 = z3 - z2;
        float normX = vectY1 * vectZ2 - vectY2 * vectZ1;
        float normY = vectX2 * vectZ1 - vectX1 * vectZ2;
        float normZ = vectX1 * vectY2 - vectX2 * vectY1;
        double leng = package$.MODULE$.sqrt(normX * normX + normY * normY + normZ * normZ);
        return new Tuple3<Object, Object, Object>(BoxesRunTime.boxToDouble((double)(-normX) / leng), BoxesRunTime.boxToDouble((double)(-normY) / leng), BoxesRunTime.boxToDouble((double)(-normZ) / leng));
    }

    public static final /* synthetic */ void $anonfun$renderPolygon3D$2(float zDepth$3, GLUtessellator tess$2, Tuple2 x$2) {
        if (x$2 != null) {
            int x = x$2._1$mcI$sp();
            int y = x$2._2$mcI$sp();
            double[] coords = (double[])Array$.MODULE$.apply(Predef$.MODULE$.wrapDoubleArray(new double[]{(double)x * 0.001 - 0.15, (double)(300 - y) * 0.001 - 0.15, zDepth$3}), ClassTag$.MODULE$.Double());
            GLU.gluTessVertex((GLUtessellator)tess$2, (double[])coords, (int)0, (Object)coords);
            return;
        }
        throw new MatchError((Object)null);
    }

    public static final /* synthetic */ void $anonfun$renderPolygon3D$3(Tessellator.TessDataObject data$1, float zDepth$3, GL2 gl$2, Object element) {
        if (element instanceof double[]) {
            double[] dArray = (double[])element;
            data$1.gl().glVertex3d(dArray[0], dArray[1], (double)(-zDepth$3));
            return;
        }
        if (element instanceof Boolean) {
            Boolean bl = (Boolean)element;
            gl$2.glEdgeFlag(bl.booleanValue());
            return;
        }
        throw new MatchError(element);
    }

    private Polygons$() {
        MODULE$ = this;
    }
}

