/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.agent;

import java.util.List;
import org.nlogo.agent.Agent3D;
import org.nlogo.agent.AgentSet;
import org.nlogo.agent.IndexedAgentSet;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Topology3D;
import org.nlogo.agent.Turtle;
import org.nlogo.agent.Turtle3D;
import org.nlogo.agent.World;
import org.nlogo.agent.World3D;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentVariables;
import org.nlogo.api.Color;
import org.nlogo.api.Dump;
import org.nlogo.core.LogoList;

public strictfp final class Patch3D
extends Patch
implements Agent3D,
org.nlogo.api.Patch3D {
    public static final int VAR_PXCOR3D = 0;
    public static final int VAR_PYCOR3D = 1;
    public static final int VAR_PZCOR3D = 2;
    public static final int VAR_PCOLOR3D = 3;
    public static final int VAR_PLABEL3D = 4;
    public static final int VAR_PLABELCOLOR3D = 5;
    public final int pzcor;
    public AgentSet patchNeighbors6;
    public static final int LAST_PREDEFINED_VAR_3D = 5;

    @Override
    public int pzcor() {
        return this.pzcor;
    }

    @Override
    void topologyChanged() {
        super.topologyChanged();
        this.patchNeighbors6 = null;
    }

    Patch3D(World world, int id, int pxcor, int pycor, int pzcor, int numVariables) {
        super(world, pxcor, pycor);
        this.setId(id);
        this.pzcor = pzcor;
        Object[] variables = new Object[numVariables];
        block8: for (int i = 0; i < numVariables; ++i) {
            switch (i) {
                case 0: {
                    variables[i] = (double)pxcor;
                    continue block8;
                }
                case 1: {
                    variables[i] = (double)pycor;
                    continue block8;
                }
                case 2: {
                    variables[i] = (double)pzcor;
                    continue block8;
                }
                case 3: {
                    variables[i] = (double)World.Zero();
                    continue block8;
                }
                case 4: {
                    variables[i] = "";
                    continue block8;
                }
                case 5: {
                    variables[i] = Color.BoxedWhite();
                    continue block8;
                }
                default: {
                    variables[i] = World.Zero();
                }
            }
        }
        this.NUMBER_PREDEFINED_VARS = 6;
        this.setVariables(variables);
    }

    @Override
    public void setPatchVariable(int vn, Object value) throws AgentException {
        if (vn > 5) {
            this.variables()[vn] = value;
        } else {
            switch (vn) {
                case 3: {
                    if (value instanceof Double) {
                        this.pcolor((Double)value);
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.pcolor((LogoList)value, 3, true);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[vn], Double.class, value);
                    break;
                }
                case 4: {
                    this.label(value);
                    break;
                }
                case 5: {
                    if (value instanceof Double) {
                        this.labelColor((double)((Double)value));
                        break;
                    }
                    if (value instanceof LogoList) {
                        this.labelColor((LogoList)value, 5);
                        break;
                    }
                    this.wrongTypeForVariable(AgentVariables.getImplicitPatchVariables(true)[vn], Double.class, value);
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    throw new AgentException("you can't change a patch's coordinates");
                }
                default: {
                    return;
                }
            }
        }
    }

    @Override
    public void setPatchVariable(int vn, double value) throws AgentException {
        switch (vn) {
            case 0: {
                throw new AgentException("you can't change a patch's coordinates");
            }
            case 1: {
                throw new AgentException("you can't change a patch's coordinates");
            }
            case 2: {
                throw new AgentException("you can't change a patch's coordinates");
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public Object getPatchVariable(int vn) {
        return this.variables()[vn];
    }

    @Override
    public double getPatchVariableDouble(int vn) {
        switch (vn) {
            case 0: {
                return this.pxcor;
            }
            case 1: {
                return this.pycor;
            }
            case 2: {
                return this.pzcor;
            }
        }
        throw new IllegalArgumentException(vn + " is not a double variable");
    }

    @Override
    public Patch getPatchAtOffsets(double dx, double dy) throws AgentException {
        Patch3D target = ((World3D)this._world).getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy, this.pzcor);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    @Override
    public Patch3D getPatchAtOffsets(double dx, double dy, double dz) throws AgentException {
        Patch3D target = ((World3D)this._world).getPatchAt((double)this.pxcor + dx, (double)this.pycor + dy, (double)this.pzcor + dz);
        if (target == null) {
            throw new AgentException("Cannot get patch beyond limits of current world.");
        }
        return target;
    }

    public Patch getPatchAtPoint(List<Double> point) throws AgentException {
        double dx = point.get(0);
        double dy = point.get(1);
        double dz = point.size() == 3 ? point.get(2) : 0.0;
        return this.getPatchAtOffsets(dx, dy, dz);
    }

    @Override
    public Patch fastGetPatchAt(int x, int y) {
        return ((World3D)this._world).fastGetPatchAt(x, y, this.pzcor);
    }

    @Override
    public Turtle sprout(int c, int heading, AgentSet breed) {
        Turtle3D child = new Turtle3D((World3D)this._world, breed, (Number)((Double)this.variables()[0]), (Number)((Double)this.variables()[1]), (Double)this.variables()[2]);
        child.colorDouble(Double.valueOf(5 + 10 * c));
        child.heading(heading);
        return child;
    }

    @Override
    public Object pcolor() {
        return this._variables[3];
    }

    @Override
    public void pcolor(double pcolor) {
        Object currentColor;
        if (pcolor < 0.0 || pcolor >= (double)Color.MaxColor()) {
            pcolor = Color.modulateDouble(pcolor);
        }
        if (!((currentColor = this._variables[3]) instanceof Double) || (Double)currentColor != pcolor) {
            Double boxedColor = pcolor;
            this._variables[3] = boxedColor;
            this._world.patchChangedColorAt((int)this._id, pcolor);
        }
    }

    @Override
    public void pcolor(Double boxedColor) {
        Object currentColor;
        double color = boxedColor;
        if (color < 0.0 || color >= (double)Color.MaxColor()) {
            color = Color.modulateDouble(color);
            boxedColor = color;
        }
        if (!((currentColor = this._variables[3]) instanceof Double) || (Double)currentColor != color) {
            this._variables[3] = boxedColor;
            this._world.patchChangedColorAt((int)this._id, color);
        }
    }

    @Override
    public void pcolor(LogoList rgb) throws AgentException {
        this.pcolor(rgb, 3, true);
    }

    @Override
    public void pcolorDoubleUnchecked(Double boxedColor) {
        double color = boxedColor;
        Object currentColor = this._variables[3];
        if (!(currentColor instanceof Double) || (Double)currentColor != color) {
            this._variables[3] = boxedColor;
            this._world.patchColors()[(int)this._id] = Color.getARGBbyPremodulatedColorNumber(color);
            this._world.markPatchColorsDirty();
            if (color != 0.0) {
                this._world.patchesAllBlack(false);
            }
        }
    }

    @Override
    public Object label() {
        return this._variables[4];
    }

    @Override
    public String labelString() {
        return Dump.logoObject(this.variables()[4]);
    }

    @Override
    public void label(Object label) {
        if (label instanceof String && ((String)label).length() == 0) {
            if (this.hasLabel()) {
                this._world.removePatchLabel();
            }
        } else if (!this.hasLabel()) {
            this._world.addPatchLabel();
        }
        this.variables()[4] = label;
    }

    @Override
    public Object labelColor() {
        return this.variables()[5];
    }

    @Override
    public void labelColor(double labelColor) {
        this.variables()[5] = Color.modulateDouble(labelColor);
    }

    @Override
    public void labelColor(Double labelColor) {
        this.variables()[5] = labelColor;
    }

    @Override
    public IndexedAgentSet getNeighbors() {
        if (this.patchNeighbors == null) {
            this.patchNeighbors = ((Topology3D)((Object)this._world.topology())).getNeighbors3d(this);
        }
        return this.patchNeighbors;
    }

    public AgentSet getNeighbors6() {
        if (this.patchNeighbors6 == null) {
            this.patchNeighbors6 = ((Topology3D)((Object)this._world.topology())).getNeighbors6(this);
        }
        return this.patchNeighbors6;
    }

    @Override
    public String toString() {
        return "patch " + this.pxcor + " " + this.pycor + " " + this.pzcor;
    }

    @Override
    public int alpha() {
        return this.pcolor().equals(Color.BoxedBlack()) ? 0 : Color.getColor(this.pcolor()).getAlpha();
    }
}

