/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.jhotdraw.util.CollectionsFactory;

public class Iconkit {
    private Map fMap = new Hashtable(53);
    private List fRegisteredImages = CollectionsFactory.current().createList(10);
    private Component fComponent;
    private static final int ID = 123;
    private static Iconkit fgIconkit = null;
    private static boolean fgDebug = false;

    public Iconkit(Component component) {
        this.fComponent = component;
        fgIconkit = this;
    }

    public static Iconkit instance() {
        return fgIconkit;
    }

    public void loadRegisteredImages(Component component) {
        if (this.fRegisteredImages.size() == 0) {
            return;
        }
        MediaTracker mediaTracker = new MediaTracker(component);
        Iterator iterator = this.fRegisteredImages.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (this.basicGetImage(string) != null) continue;
            mediaTracker.addImage(this.loadImage(string), 123);
        }
        this.fRegisteredImages.clear();
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void registerImage(String string) {
        this.fRegisteredImages.add(string);
    }

    public Image registerAndLoadImage(Component component, String string) {
        this.registerImage(string);
        this.loadRegisteredImages(component);
        return this.getImage(string);
    }

    public Image loadImage(String string) {
        if (this.fMap.containsKey(string)) {
            return (Image)this.fMap.get(string);
        }
        Image image = this.loadImageResource(string);
        if (image != null) {
            this.fMap.put(string, image);
        }
        return image;
    }

    public Image loadImage(String string, boolean bl) {
        Image image = this.loadImage(string);
        if (image != null && bl) {
            ImageIcon imageIcon = new ImageIcon(image);
            image = imageIcon.getImage();
        }
        return image;
    }

    public Image loadImageResource(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL uRL = this.getClass().getResource(string);
            if (fgDebug) {
                System.out.println(string);
            }
            return toolkit.createImage((ImageProducer)uRL.getContent());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Image getImage(String string) {
        Image image = this.basicGetImage(string);
        if (image != null) {
            return image;
        }
        this.loadRegisteredImages(this.fComponent);
        return this.basicGetImage(string);
    }

    private Image basicGetImage(String string) {
        if (this.fMap.containsKey(string)) {
            return (Image)this.fMap.get(string);
        }
        return null;
    }
}

