/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.stream.window;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openimaj.util.function.Function;
import org.openimaj.util.stream.AbstractStream;
import org.openimaj.util.stream.Stream;

public abstract class SequentialStreamAggregator<T>
implements Function<Stream<T>, Stream<T>> {
    private Comparator<T> comp;

    public SequentialStreamAggregator(Comparator<T> comp) {
        this.comp = comp;
    }

    @Override
    public Stream<T> apply(final Stream<T> inner) {
        return new AbstractStream<T>(){
            List<T> currentList = new ArrayList();

            @Override
            public boolean hasNext() {
                return inner.hasNext() || this.currentList.size() != 0;
            }

            @Override
            public T next() {
                while (inner.hasNext()) {
                    Object next = inner.next();
                    if (this.currentList.size() == 0 || SequentialStreamAggregator.this.comp.compare(this.currentList.get(0), next) == 0) {
                        this.currentList.add(next);
                        continue;
                    }
                    Object toRet = SequentialStreamAggregator.this.combine(this.currentList);
                    this.currentList.clear();
                    this.currentList.add(next);
                    return toRet;
                }
                if (this.currentList.size() != 0) {
                    Object toRet = SequentialStreamAggregator.this.combine(this.currentList);
                    this.currentList.clear();
                    return toRet;
                }
                throw new UnsupportedOperationException("The sequential combiner failed");
            }
        };
    }

    public abstract T combine(List<T> var1);
}

