/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.queue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openimaj.util.queue.InvertedPriorityQueue;

public class BoundedPriorityQueue<T>
extends InvertedPriorityQueue<T> {
    private static final long serialVersionUID = 1L;
    private int maxSize;

    public BoundedPriorityQueue(int maxSize, Comparator<? super T> comparator) {
        super(maxSize, comparator);
        this.maxSize = maxSize;
    }

    public BoundedPriorityQueue(int maxSize) {
        super(maxSize);
        this.maxSize = maxSize;
    }

    @Override
    public boolean offer(T e) {
        if (this.size() < this.maxSize) {
            return super.offer(e);
        }
        Object object = super.peek();
        if (this.compare(object, e) < 0) {
            super.poll();
            return super.offer(e);
        }
        return false;
    }

    private int compare(T o1, T o2) {
        if (this.comparator() != null) {
            return this.comparator().compare(o1, o2);
        }
        Comparable key = (Comparable)o1;
        return key.compareTo(o2);
    }

    @Override
    public T peek() {
        Object best = super.peek();
        for (Object obj : this) {
            if (this.compare(best, obj) >= 0) continue;
            best = obj;
        }
        return (T)best;
    }

    @Override
    public T poll() {
        T best = this.peek();
        this.remove(best);
        return best;
    }

    public List<T> toOrderedList() {
        int size = this.size();
        ArrayList list = new ArrayList(size);
        for (Object obj : this) {
            list.add(obj);
        }
        Collections.sort(list, this.originalComparator());
        return list;
    }

    public Object[] toOrderedArray() {
        Object[] array = this.toArray();
        Arrays.sort(array, this.originalComparator());
        return array;
    }

    public T[] toOrderedArray(T[] a) {
        T[] array = this.toArray(a);
        Arrays.sort(array, this.originalComparator());
        return array;
    }

    public List<T> toOrderedListDestructive() {
        int size = this.size();
        Object[] list = new Object[size];
        for (int i = size - 1; i >= 0; --i) {
            list[i] = super.poll();
        }
        return Arrays.asList(list);
    }

    public Object[] toOrderedArrayDestructive() {
        int size = this.size();
        Object[] array = new Object[size];
        for (int i = size - 1; i >= 0; --i) {
            array[i] = super.poll();
        }
        return array;
    }

    public T[] toOrderedArrayDestructive(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = Arrays.copyOf(a, size, a.getClass());
        }
        if (a.length > size) {
            a[size] = null;
        }
        for (int i = size - 1; i >= 0; --i) {
            a[i] = super.poll();
        }
        return a;
    }

    public T peekTail() {
        return (T)super.peek();
    }

    public T pollTail() {
        return (T)super.poll();
    }

    public T offerItem(T item) {
        T tail = null;
        if (this.size() >= this.maxSize) {
            tail = (T)super.peek();
        }
        if (this.offer(item)) {
            return tail;
        }
        return item;
    }

    public boolean isFull() {
        return this.maxSize == this.size();
    }
}

