/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.util.iterator;

import java.util.Iterator;
import org.openimaj.util.iterator.NumericIterable;

public class UniformFloatRangeIterable
implements NumericIterable<Float> {
    private float stop;
    private float step;
    private float current;

    public UniformFloatRangeIterable(float start, float stop, float step) {
        this.stop = stop;
        this.step = step;
        this.current = start;
    }

    public UniformFloatRangeIterable(float start, float stop) {
        this(start, stop, 1.0f);
    }

    @Override
    public Iterator<Float> iterator() {
        return new Iterator<Float>(){

            @Override
            public boolean hasNext() {
                return UniformFloatRangeIterable.this.current + UniformFloatRangeIterable.this.step <= UniformFloatRangeIterable.this.stop;
            }

            @Override
            public Float next() {
                float ret = UniformFloatRangeIterable.this.current;
                UniformFloatRangeIterable.this.current = UniformFloatRangeIterable.this.current + UniformFloatRangeIterable.this.step;
                return Float.valueOf(ret);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }
}

