/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Scanner;
import org.openimaj.io.ReadWriteable;

public class ReadWriteableShort
implements ReadWriteable,
Comparable<ReadWriteableShort> {
    public short value;

    public ReadWriteableShort(short value) {
        this.value = value;
    }

    public ReadWriteableShort() {
        this.value = 0;
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.value = in.readShort();
    }

    @Override
    public void readASCII(Scanner in) throws IOException {
        this.value = in.nextShort();
    }

    @Override
    public byte[] binaryHeader() {
        return new byte[0];
    }

    @Override
    public String asciiHeader() {
        return "";
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        out.writeShort(this.value);
    }

    @Override
    public void writeASCII(PrintWriter out) throws IOException {
        out.print(this.value + "\n");
    }

    public boolean equals(Object o) {
        return o instanceof ReadWriteableShort && ((ReadWriteableShort)o).value == this.value;
    }

    public int hashCode() {
        return new Short(this.value).hashCode();
    }

    @Override
    public int compareTo(ReadWriteableShort arg0) {
        return new Short(this.value).compareTo(arg0.value);
    }
}

