/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.io.wrappers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.util.pair.IndependentPair;

public abstract class ReadWritableIndependentPair<A, B>
extends IndependentPair<A, B>
implements ReadWriteableBinary {
    public ReadWritableIndependentPair(A obj1, B obj2) {
        super(obj1, obj2);
    }

    public ReadWritableIndependentPair(IndependentPair<A, B> pair) {
        super(pair.firstObject(), pair.secondObject());
    }

    @Override
    public void readBinary(DataInput in) throws IOException {
        this.setFirstObject(this.readFirst(in));
        this.setSecondObject(this.readSecond(in));
    }

    public abstract A readFirst(DataInput var1) throws IOException;

    public abstract B readSecond(DataInput var1) throws IOException;

    public abstract void writeFirst(DataOutput var1, A var2) throws IOException;

    public abstract void writeSecond(DataOutput var1, B var2) throws IOException;

    @Override
    public byte[] binaryHeader() {
        return "RWIP".getBytes();
    }

    @Override
    public void writeBinary(DataOutput out) throws IOException {
        this.writeFirst(out, this.firstObject());
        this.writeSecond(out, this.secondObject());
    }
}

