/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.data;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.openimaj.data.AbstractDataSource;

public abstract class AbstractMultiListDataSource<DATATYPE, ELEMENTTYPE>
extends AbstractDataSource<DATATYPE> {
    protected List<? extends List<ELEMENTTYPE>> data;

    public AbstractMultiListDataSource(List<? extends List<ELEMENTTYPE>> data) {
        this.data = data;
    }

    @SafeVarargs
    public AbstractMultiListDataSource(List<ELEMENTTYPE> ... data) {
        this.data = Arrays.asList(data);
    }

    public AbstractMultiListDataSource(Map<?, ? extends List<ELEMENTTYPE>> data) {
        this.data = new ArrayList<List<ELEMENTTYPE>>(data.values());
    }

    @Override
    public void getData(int startRow, int stopRow, DATATYPE[] data) {
        int i = 0;
        int row = startRow;
        while (row < stopRow) {
            data[i] = this.getData(row);
            ++row;
            ++i;
        }
    }

    @Override
    public DATATYPE getData(int row) {
        int cumsum = 0;
        for (int i = 0; i < this.data.size(); ++i) {
            int sz = this.data.get(i).size();
            if (row < cumsum + sz) {
                return this.convert(this.data.get(i).get(row - cumsum));
            }
            cumsum += sz;
        }
        throw new IndexOutOfBoundsException();
    }

    protected abstract DATATYPE convert(ELEMENTTYPE var1);

    @Override
    public int size() {
        int sum = 0;
        for (List<ELEMENTTYPE> d : this.data) {
            sum += d.size();
        }
        return sum;
    }

    @Override
    public DATATYPE[] createTemporaryArray(int size) {
        return (Object[])Array.newInstance(this.getData(0).getClass(), size);
    }
}

