/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;

@Reference(type=ReferenceType.Inproceedings, author={"Jonathan Hare", "Sina Samangooei", "David Dupplaw"}, title="OpenIMAJ and ImageTerrier: Java Libraries and Tools for Scalable Multimedia Analysis and Indexing of Images", year="2011", booktitle="ACM Multimedia 2011", pages={"691", "694"}, url="http://eprints.soton.ac.uk/273040/", note=" Event Dates: 28/11/2011 until 1/12/2011", month="November", publisher="ACM")
public class OpenIMAJ {
    private static final String version;

    private OpenIMAJ() {
    }

    public static String getVersion() {
        return version;
    }

    public static InputStream getLogoAsStream() {
        return OpenIMAJ.class.getResourceAsStream("OpenIMAJ.png");
    }

    public static URL getLogoAsURL() {
        return OpenIMAJ.class.getResource("OpenIMAJ.png");
    }

    static {
        String versionString;
        try {
            InputStream is = OpenIMAJ.class.getResourceAsStream("OpenIMAJ.properties");
            Properties props = new Properties();
            props.load(is);
            versionString = props.getProperty("version");
        }
        catch (IOException e) {
            versionString = "unknown";
        }
        version = versionString;
    }
}

