/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.factory;

import java.util.Arrays;
import java.util.Random;
import org.la4j.factory.BasicFactory;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrix;
import org.la4j.matrix.dense.Basic1DMatrix;
import org.la4j.matrix.source.MatrixSource;

public class Basic1DFactory
extends BasicFactory
implements Factory {
    private static final long serialVersionUID = 4071505L;

    @Override
    public Matrix createMatrix() {
        return new Basic1DMatrix();
    }

    @Override
    public Matrix createMatrix(int rows, int columns) {
        return new Basic1DMatrix(rows, columns);
    }

    @Override
    public Matrix createMatrix(double[][] array) {
        return new Basic1DMatrix(array);
    }

    @Override
    public Matrix createMatrix(Matrix matrix) {
        return new Basic1DMatrix(matrix);
    }

    @Override
    public Matrix createMatrix(MatrixSource source) {
        return new Basic1DMatrix(source);
    }

    @Override
    public Matrix createConstantMatrix(int rows, int columns, double value) {
        double[] array = new double[rows * columns];
        Arrays.fill(array, value);
        return new Basic1DMatrix(rows, columns, array);
    }

    @Override
    public Matrix createRandomMatrix(int rows, int columns) {
        double[] array = new double[rows * columns];
        Random rnd = new Random();
        for (int i = 0; i < rows * columns; ++i) {
            array[i] = rnd.nextDouble();
        }
        return new Basic1DMatrix(rows, columns, array);
    }

    @Override
    public Matrix createRandomSymmetricMatrix(int size) {
        double[] array = new double[size * size];
        Random rnd = new Random();
        for (int i = 0; i < size; ++i) {
            for (int j = i; j < size; ++j) {
                double value;
                array[i * size + j] = value = rnd.nextDouble();
                array[j * size + i] = value;
            }
        }
        return new Basic1DMatrix(size, size, array);
    }

    @Override
    public Matrix createSquareMatrix(int size) {
        return new Basic1DMatrix(size, size);
    }

    @Override
    public Matrix createIdentityMatrix(int size) {
        double[] array = new double[size * size];
        for (int i = 0; i < size; ++i) {
            array[i * size + i] = 1.0;
        }
        return new Basic1DMatrix(size, size, array);
    }
}

