/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.decomposition;

import org.la4j.decomposition.MatrixDecompositor;
import org.la4j.factory.Factory;
import org.la4j.matrix.Matrices;
import org.la4j.matrix.Matrix;
import org.la4j.vector.Vector;

public class CholeskyDecompositor
implements MatrixDecompositor {
    @Override
    public Matrix[] decompose(Matrix matrix, Factory factory) {
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Wrong matrix size:");
        }
        if (!matrix.is(Matrices.SYMMETRIC_MATRIX)) {
            throw new IllegalArgumentException();
        }
        if (!this.isPositiveDefinite(matrix)) {
            throw new IllegalArgumentException();
        }
        Matrix u = factory.createMatrix(matrix.rows(), matrix.rows());
        for (int j = 0; j < u.rows(); ++j) {
            int k;
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += u.get(k, i) * u.get(j, i);
                }
                s = (matrix.get(j, k) - s) / u.get(k, k);
                u.set(j, k, s);
                d += s * s;
            }
            d = matrix.get(j, j) - d;
            u.set(j, j, Math.sqrt(Math.max(d, 0.0)));
            for (k = j + 1; k < u.rows(); ++k) {
                u.set(j, k, 0.0);
            }
        }
        return new Matrix[]{u};
    }

    private boolean isPositiveDefinite(Matrix matrix) {
        int n = matrix.rows();
        boolean result = true;
        Matrix l = matrix.blank();
        for (int j = 0; j < n; ++j) {
            int k;
            Vector rowj = l.getRow(j);
            double d = 0.0;
            for (k = 0; k < j; ++k) {
                Vector rowk = l.getRow(k);
                double s = 0.0;
                for (int i = 0; i < k; ++i) {
                    s += rowk.get(i) * rowj.get(i);
                }
                s = (matrix.get(j, k) - s) / l.get(k, k);
                rowj.set(k, s);
                l.setRow(j, rowj);
                d += s * s;
            }
            d = matrix.get(j, j) - d;
            result = result && d > 0.0;
            l.set(j, j, Math.sqrt(Math.max(d, 0.0)));
            for (k = j + 1; k < n; ++k) {
                l.set(j, k, 0.0);
            }
        }
        return result;
    }
}

