/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.h264;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jcodec.codecs.h264.decode.SliceHeaderReader;
import org.jcodec.codecs.h264.io.model.NALUnit;
import org.jcodec.codecs.h264.io.model.NALUnitType;
import org.jcodec.codecs.h264.io.model.PictureParameterSet;
import org.jcodec.codecs.h264.io.model.SeqParameterSet;
import org.jcodec.codecs.h264.io.model.SliceHeader;
import org.jcodec.codecs.h264.io.write.SliceHeaderWriter;
import org.jcodec.codecs.h264.mp4.AvcCBox;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.io.BitWriter;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.LeafBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import org.jcodec.containers.mp4.muxer.MP4Muxer;

public class H264Utils {
    private static SliceHeaderReader shr = new SliceHeaderReader();
    private static SliceHeaderWriter shw = new SliceHeaderWriter();

    public static ByteBuffer nextNALUnit(ByteBuffer buf) {
        H264Utils.skipToNALUnit(buf);
        return H264Utils.gotoNALUnit(buf);
    }

    public static final void skipToNALUnit(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return;
        }
        int val = -1;
        while (buf.hasRemaining()) {
            val <<= 8;
            if (((val |= buf.get() & 0xFF) & 0xFFFFFF) != 1) continue;
            buf.position(buf.position());
            break;
        }
    }

    public static final ByteBuffer gotoNALUnit(ByteBuffer buf) {
        if (!buf.hasRemaining()) {
            return null;
        }
        int from = buf.position();
        ByteBuffer result = buf.slice();
        result.order(ByteOrder.BIG_ENDIAN);
        int val = -1;
        while (buf.hasRemaining()) {
            val <<= 8;
            if (((val |= buf.get() & 0xFF) & 0xFFFFFF) != 1) continue;
            buf.position(buf.position() - (val == 1 ? 4 : 3));
            result.limit(buf.position() - from);
            break;
        }
        return result;
    }

    public static final void unescapeNAL(ByteBuffer _buf) {
        if (_buf.remaining() < 2) {
            return;
        }
        ByteBuffer in = _buf.duplicate();
        ByteBuffer out = _buf.duplicate();
        byte p1 = in.get();
        out.put(p1);
        byte p2 = in.get();
        out.put(p2);
        while (in.hasRemaining()) {
            byte b = in.get();
            if (p1 != 0 || p2 != 0 || b != 3) {
                out.put(b);
            }
            p1 = p2;
            p2 = b;
        }
        _buf.limit(out.position());
    }

    public static final void escapeNAL(ByteBuffer src) {
        int[] loc = H264Utils.searchEscapeLocations(src);
        int old = src.limit();
        src.limit(src.limit() + loc.length);
        int newPos = src.limit() - 1;
        int oldPos = old - 1;
        int locIdx = loc.length - 1;
        while (newPos >= src.position()) {
            src.put(newPos, src.get(oldPos));
            if (locIdx >= 0 && loc[locIdx] == oldPos) {
                src.put(--newPos, (byte)3);
                --locIdx;
            }
            --newPos;
            --oldPos;
        }
    }

    private static int[] searchEscapeLocations(ByteBuffer src) {
        IntArrayList points = new IntArrayList();
        ByteBuffer search = src.duplicate();
        int p = search.getShort();
        while (search.hasRemaining()) {
            byte b = search.get();
            if (p == 0 && (b & 0xFFFFFFFC) == 0) {
                points.add(search.position() - 1);
                p = 3;
            }
            p = (short)(p << 8);
            p = (short)(p | b & 0xFF);
        }
        int[] array = points.toArray();
        return array;
    }

    public static final void escapeNAL(ByteBuffer src, ByteBuffer dst) {
        int p1 = src.get();
        int p2 = src.get();
        dst.put((byte)p1);
        dst.put((byte)p2);
        while (src.hasRemaining()) {
            int b = src.get();
            if (p1 == 0 && p2 == 0 && (b & 0xFF) <= 3) {
                dst.put((byte)3);
                p1 = p2;
                p2 = 3;
            }
            dst.put((byte)b);
            p1 = p2;
            p2 = b;
        }
    }

    public static int golomb2Signed(int val) {
        int sign = ((val & 1) << 1) - 1;
        val = ((val >> 1) + (val & 1)) * sign;
        return val;
    }

    public static List<ByteBuffer> splitMOVPacket(ByteBuffer buf, AvcCBox avcC) {
        int len;
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        int nls = avcC.getNalLengthSize();
        ByteBuffer dup = buf.duplicate();
        while (dup.remaining() >= nls && (len = H264Utils.readLen(dup, nls)) != 0) {
            result.add(NIOUtils.read(dup, len));
        }
        return result;
    }

    private static int readLen(ByteBuffer dup, int nls) {
        switch (nls) {
            case 1: {
                return dup.get() & 0xFF;
            }
            case 2: {
                return dup.getShort() & 0xFFFF;
            }
            case 3: {
                return (dup.getShort() & 0xFFFF) << 8 | dup.get() & 0xFF;
            }
            case 4: {
                return dup.getInt();
            }
        }
        throw new IllegalArgumentException("NAL Unit length size can not be " + nls);
    }

    public static void encodeMOVPacket(ByteBuffer avcFrame) {
        ByteBuffer buf;
        ByteBuffer dup = avcFrame.duplicate();
        ByteBuffer d1 = avcFrame.duplicate();
        int tot = d1.position();
        while ((buf = H264Utils.nextNALUnit(dup)) != null) {
            d1.position(tot);
            d1.putInt(buf.remaining());
            tot += buf.remaining() + 4;
        }
    }

    public static void wipePS(ByteBuffer in, ByteBuffer out, List<ByteBuffer> spsList, List<ByteBuffer> ppsList) {
        ByteBuffer buf;
        ByteBuffer dup = in.duplicate();
        while (dup.hasRemaining() && (buf = H264Utils.nextNALUnit(dup)) != null) {
            NALUnit nu = NALUnit.read(buf.duplicate());
            if (nu.type == NALUnitType.PPS) {
                if (ppsList == null) continue;
                ppsList.add(buf);
                continue;
            }
            if (nu.type == NALUnitType.SPS) {
                if (spsList == null) continue;
                spsList.add(buf);
                continue;
            }
            out.putInt(1);
            out.put(buf);
        }
        out.flip();
    }

    public static void wipePS(ByteBuffer in, List<ByteBuffer> spsList, List<ByteBuffer> ppsList) {
        ByteBuffer buf;
        ByteBuffer dup = in.duplicate();
        while (dup.hasRemaining() && (buf = H264Utils.nextNALUnit(dup)) != null) {
            NALUnit nu = NALUnit.read(buf);
            if (nu.type == NALUnitType.PPS) {
                if (ppsList != null) {
                    ppsList.add(buf);
                }
                in.position(dup.position());
                continue;
            }
            if (nu.type == NALUnitType.SPS) {
                if (spsList != null) {
                    spsList.add(buf);
                }
                in.position(dup.position());
                continue;
            }
            if (nu.type != NALUnitType.IDR_SLICE && nu.type != NALUnitType.NON_IDR_SLICE) continue;
            break;
        }
    }

    public static AvcCBox createAvcC(SeqParameterSet sps, PictureParameterSet pps, int nalLengthSize) {
        ByteBuffer serialSps = ByteBuffer.allocate(512);
        sps.write(serialSps);
        serialSps.flip();
        H264Utils.escapeNAL(serialSps);
        ByteBuffer serialPps = ByteBuffer.allocate(512);
        pps.write(serialPps);
        serialPps.flip();
        H264Utils.escapeNAL(serialPps);
        AvcCBox avcC = new AvcCBox(sps.profile_idc, 0, sps.level_idc, nalLengthSize, Arrays.asList(serialSps), Arrays.asList(serialPps));
        return avcC;
    }

    public static AvcCBox createAvcC(List<SeqParameterSet> initSPS, List<PictureParameterSet> initPPS, int nalLengthSize) {
        ByteBuffer bb1;
        ArrayList<ByteBuffer> serialSps = new ArrayList<ByteBuffer>();
        ArrayList<ByteBuffer> serialPps = new ArrayList<ByteBuffer>();
        for (SeqParameterSet sps : initSPS) {
            bb1 = ByteBuffer.allocate(512);
            sps.write(bb1);
            bb1.flip();
            H264Utils.escapeNAL(bb1);
            serialSps.add(bb1);
        }
        for (PictureParameterSet pps : initPPS) {
            bb1 = ByteBuffer.allocate(512);
            pps.write(bb1);
            bb1.flip();
            H264Utils.escapeNAL(bb1);
            serialPps.add(bb1);
        }
        SeqParameterSet sps = initSPS.get(0);
        return new AvcCBox(sps.profile_idc, 0, sps.level_idc, nalLengthSize, serialSps, serialPps);
    }

    public static SampleEntry createMOVSampleEntry(List<ByteBuffer> spsList, List<ByteBuffer> ppsList, int nalLengthSize) {
        SeqParameterSet sps = H264Utils.readSPS(NIOUtils.duplicate(spsList.get(0)));
        AvcCBox avcC = new AvcCBox(sps.profile_idc, 0, sps.level_idc, nalLengthSize, spsList, ppsList);
        return H264Utils.createMOVSampleEntry(avcC);
    }

    public static SampleEntry createMOVSampleEntry(AvcCBox avcC) {
        SeqParameterSet sps = SeqParameterSet.read(avcC.getSpsList().get(0).duplicate());
        int codedWidth = sps.pic_width_in_mbs_minus1 + 1 << 4;
        int codedHeight = H264Utils.getPicHeightInMbs(sps) << 4;
        int width = sps.frame_cropping_flag ? codedWidth - (sps.frame_crop_right_offset + sps.frame_crop_left_offset << sps.chroma_format_idc.compWidth[1]) : codedWidth;
        int height = sps.frame_cropping_flag ? codedHeight - (sps.frame_crop_bottom_offset + sps.frame_crop_top_offset << sps.chroma_format_idc.compHeight[1]) : codedHeight;
        Size size = new Size(width, height);
        VideoSampleEntry se = MP4Muxer.videoSampleEntry("avc1", size, "JCodec");
        se.add(avcC);
        return se;
    }

    public static SampleEntry createMOVSampleEntry(SeqParameterSet initSPS, PictureParameterSet initPPS, int nalLengthSize) {
        ByteBuffer bb1 = ByteBuffer.allocate(512);
        ByteBuffer bb2 = ByteBuffer.allocate(512);
        initSPS.write(bb1);
        initPPS.write(bb2);
        bb1.flip();
        bb2.flip();
        return H264Utils.createMOVSampleEntry(Arrays.asList(bb1), Arrays.asList(bb2), nalLengthSize);
    }

    public static boolean idrSlice(ByteBuffer _data) {
        ByteBuffer segment;
        ByteBuffer data = _data.duplicate();
        while ((segment = H264Utils.nextNALUnit(data)) != null) {
            if (NALUnit.read((ByteBuffer)segment).type != NALUnitType.IDR_SLICE) continue;
            return true;
        }
        return false;
    }

    public static boolean idrSlice(List<ByteBuffer> _data) {
        for (ByteBuffer segment : _data) {
            if (NALUnit.read((ByteBuffer)segment.duplicate()).type != NALUnitType.IDR_SLICE) continue;
            return true;
        }
        return false;
    }

    public static void saveRawFrame(ByteBuffer data, AvcCBox avcC, File f) throws IOException {
        FileChannelWrapper raw = NIOUtils.writableFileChannel(f);
        H264Utils.saveStreamParams(avcC, raw);
        raw.write(data.duplicate());
        raw.close();
    }

    public static void saveStreamParams(AvcCBox avcC, SeekableByteChannel raw) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(1024);
        for (ByteBuffer byteBuffer : avcC.getSpsList()) {
            raw.write(ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 103}));
            H264Utils.escapeNAL(byteBuffer.duplicate(), bb);
            bb.flip();
            raw.write(bb);
            bb.clear();
        }
        for (ByteBuffer byteBuffer : avcC.getPpsList()) {
            raw.write(ByteBuffer.wrap(new byte[]{0, 0, 0, 1, 104}));
            H264Utils.escapeNAL(byteBuffer.duplicate(), bb);
            bb.flip();
            raw.write(bb);
            bb.clear();
        }
    }

    public static int getPicHeightInMbs(SeqParameterSet sps) {
        int picHeightInMbs = sps.pic_height_in_map_units_minus1 + 1 << (sps.frame_mbs_only_flag ? 0 : 1);
        return picHeightInMbs;
    }

    public static List<ByteBuffer> splitFrame(ByteBuffer frame) {
        ByteBuffer segment;
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        while ((segment = H264Utils.nextNALUnit(frame)) != null) {
            result.add(segment);
        }
        return result;
    }

    public static void joinNALUnits(List<ByteBuffer> nalUnits, ByteBuffer out) {
        for (ByteBuffer nal : nalUnits) {
            out.putInt(1);
            out.put(nal.duplicate());
        }
    }

    public static ByteBuffer getAvcCData(AvcCBox avcC) {
        ByteBuffer bb = ByteBuffer.allocate(2048);
        avcC.doWrite(bb);
        bb.flip();
        return bb;
    }

    public static AvcCBox parseAVCC(VideoSampleEntry vse) {
        Box lb = Box.findFirst((NodeBox)vse, Box.class, "avcC");
        if (lb instanceof AvcCBox) {
            return (AvcCBox)lb;
        }
        return H264Utils.parseAVCC(((LeafBox)lb).getData().duplicate());
    }

    public static AvcCBox parseAVCC(ByteBuffer bb) {
        AvcCBox avcC = new AvcCBox();
        avcC.parse(bb);
        return avcC;
    }

    public static ByteBuffer writeSPS(SeqParameterSet sps, int approxSize) {
        ByteBuffer output = ByteBuffer.allocate(approxSize + 8);
        sps.write(output);
        output.flip();
        H264Utils.escapeNAL(output);
        return output;
    }

    public static SeqParameterSet readSPS(ByteBuffer data) {
        ByteBuffer input = NIOUtils.duplicate(data);
        H264Utils.unescapeNAL(input);
        SeqParameterSet sps = SeqParameterSet.read(input);
        return sps;
    }

    public static ByteBuffer writePPS(PictureParameterSet pps, int approxSize) {
        ByteBuffer output = ByteBuffer.allocate(approxSize + 8);
        pps.write(output);
        output.flip();
        H264Utils.escapeNAL(output);
        return output;
    }

    public static PictureParameterSet readPPS(ByteBuffer data) {
        ByteBuffer input = NIOUtils.duplicate(data);
        H264Utils.unescapeNAL(input);
        PictureParameterSet pps = PictureParameterSet.read(input);
        return pps;
    }

    public static PictureParameterSet findPPS(List<PictureParameterSet> ppss, int id) {
        for (PictureParameterSet pps : ppss) {
            if (pps.pic_parameter_set_id != id) continue;
            return pps;
        }
        return null;
    }

    public static SeqParameterSet findSPS(List<SeqParameterSet> spss, int id) {
        for (SeqParameterSet sps : spss) {
            if (sps.seq_parameter_set_id != id) continue;
            return sps;
        }
        return null;
    }

    public static Size getPicSize(SeqParameterSet sps) {
        int w = sps.pic_width_in_mbs_minus1 + 1 << 4;
        int h = H264Utils.getPicHeightInMbs(sps) << 4;
        if (sps.frame_cropping_flag) {
            w -= sps.frame_crop_left_offset + sps.frame_crop_right_offset << sps.chroma_format_idc.compWidth[1];
            h -= sps.frame_crop_top_offset + sps.frame_crop_bottom_offset << sps.chroma_format_idc.compHeight[1];
        }
        return new Size(w, h);
    }

    public static List<SeqParameterSet> readSPS(List<ByteBuffer> spsList) {
        ArrayList<SeqParameterSet> result = new ArrayList<SeqParameterSet>();
        for (ByteBuffer byteBuffer : spsList) {
            result.add(H264Utils.readSPS(NIOUtils.duplicate(byteBuffer)));
        }
        return result;
    }

    public static List<PictureParameterSet> readPPS(List<ByteBuffer> ppsList) {
        ArrayList<PictureParameterSet> result = new ArrayList<PictureParameterSet>();
        for (ByteBuffer byteBuffer : ppsList) {
            result.add(H264Utils.readPPS(NIOUtils.duplicate(byteBuffer)));
        }
        return result;
    }

    public static List<ByteBuffer> writePPS(List<PictureParameterSet> allPps) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (PictureParameterSet pps : allPps) {
            result.add(H264Utils.writePPS(pps, 64));
        }
        return result;
    }

    public static List<ByteBuffer> writeSPS(List<SeqParameterSet> allSps) {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        for (SeqParameterSet sps : allSps) {
            result.add(H264Utils.writeSPS(sps, 256));
        }
        return result;
    }

    public static void dumpFrame(FileChannelWrapper ch, SeqParameterSet[] values, PictureParameterSet[] values2, List<ByteBuffer> nalUnits) throws IOException {
        for (SeqParameterSet sps : values) {
            NIOUtils.writeInt(ch, 1);
            NIOUtils.writeByte(ch, (byte)103);
            ch.write(H264Utils.writeSPS(sps, 128));
        }
        for (PictureParameterSet pps : values2) {
            NIOUtils.writeInt(ch, 1);
            NIOUtils.writeByte(ch, (byte)104);
            ch.write(H264Utils.writePPS(pps, 256));
        }
        for (ByteBuffer byteBuffer : nalUnits) {
            NIOUtils.writeInt(ch, 1);
            ch.write(byteBuffer.duplicate());
        }
    }

    public static void toNAL(ByteBuffer codecPrivate, SeqParameterSet sps, PictureParameterSet pps) {
        ByteBuffer bb1 = ByteBuffer.allocate(512);
        ByteBuffer bb2 = ByteBuffer.allocate(512);
        sps.write(bb1);
        pps.write(bb2);
        bb1.flip();
        bb2.flip();
        H264Utils.putNAL(codecPrivate, bb1, 103);
        H264Utils.putNAL(codecPrivate, bb2, 104);
    }

    public static void toNAL(ByteBuffer codecPrivate, List<ByteBuffer> spsList2, List<ByteBuffer> ppsList2) {
        for (ByteBuffer byteBuffer : spsList2) {
            H264Utils.putNAL(codecPrivate, byteBuffer, 103);
        }
        for (ByteBuffer byteBuffer : ppsList2) {
            H264Utils.putNAL(codecPrivate, byteBuffer, 104);
        }
    }

    private static void putNAL(ByteBuffer codecPrivate, ByteBuffer byteBuffer, int nalType) {
        ByteBuffer dst = ByteBuffer.allocate(byteBuffer.remaining() * 2);
        H264Utils.escapeNAL(byteBuffer, dst);
        dst.flip();
        codecPrivate.putInt(1);
        codecPrivate.put((byte)nalType);
        codecPrivate.put(dst);
    }

    public static abstract class SliceHeaderTweaker {
        private List<SeqParameterSet> sps;
        private List<PictureParameterSet> pps;

        public SliceHeaderTweaker() {
        }

        public SliceHeaderTweaker(List<ByteBuffer> spsList, List<ByteBuffer> ppsList) {
            this.sps = H264Utils.readSPS(spsList);
            this.pps = H264Utils.readPPS(ppsList);
        }

        protected abstract void tweak(SliceHeader var1);

        public SliceHeader run(ByteBuffer is, ByteBuffer os, NALUnit nu) {
            ByteBuffer nal = os.duplicate();
            H264Utils.unescapeNAL(is);
            BitReader reader = new BitReader(is);
            SliceHeader sh = shr.readPart1(reader);
            PictureParameterSet pp = H264Utils.findPPS(this.pps, sh.pic_parameter_set_id);
            return this.part2(is, os, nu, H264Utils.findSPS(this.sps, pp.pic_parameter_set_id), pp, nal, reader, sh);
        }

        public SliceHeader run(ByteBuffer is, ByteBuffer os, NALUnit nu, SeqParameterSet sps, PictureParameterSet pps) {
            ByteBuffer nal = os.duplicate();
            H264Utils.unescapeNAL(is);
            BitReader reader = new BitReader(is);
            SliceHeader sh = shr.readPart1(reader);
            return this.part2(is, os, nu, sps, pps, nal, reader, sh);
        }

        private SliceHeader part2(ByteBuffer is, ByteBuffer os, NALUnit nu, SeqParameterSet sps, PictureParameterSet pps, ByteBuffer nal, BitReader reader, SliceHeader sh) {
            BitWriter writer = new BitWriter(os);
            shr.readPart2(sh, nu, sps, pps, reader);
            this.tweak(sh);
            shw.write(sh, nu.type == NALUnitType.IDR_SLICE, nu.nal_ref_idc, writer);
            if (pps.entropy_coding_mode_flag) {
                this.copyDataCABAC(is, os, reader, writer);
            } else {
                this.copyDataCAVLC(is, os, reader, writer);
            }
            nal.limit(os.position());
            H264Utils.escapeNAL(nal);
            os.position(nal.limit());
            return sh;
        }

        private void copyDataCAVLC(ByteBuffer is, ByteBuffer os, BitReader reader, BitWriter writer) {
            int wLeft = 8 - writer.curBit();
            if (wLeft != 0) {
                writer.writeNBit(reader.readNBit(wLeft), wLeft);
            }
            writer.flush();
            int shift = reader.curBit();
            if (shift != 0) {
                int mShift = 8 - shift;
                int inp = reader.readNBit(mShift);
                reader.stop();
                while (is.hasRemaining()) {
                    int out = inp << shift;
                    inp = is.get() & 0xFF;
                    os.put((byte)(out |= inp >> mShift));
                }
                os.put((byte)(inp << shift));
            } else {
                reader.stop();
                os.put(is);
            }
        }

        private void copyDataCABAC(ByteBuffer is, ByteBuffer os, BitReader reader, BitWriter writer) {
            long rem;
            long bp = reader.curBit();
            if (bp != 0L && (long)((1 << (int)(8L - bp)) - 1) != (rem = (long)reader.readNBit(8 - (int)bp))) {
                throw new RuntimeException("Invalid CABAC padding");
            }
            if (writer.curBit() != 0) {
                writer.writeNBit(255, 8 - writer.curBit());
            }
            writer.flush();
            reader.stop();
            os.put(is);
        }
    }
}

