/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.sw;

import com.sun.prism.PixelFormat;
import com.sun.prism.impl.BaseResourcePool;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.TextureResourcePool;
import com.sun.prism.sw.SWArgbPreTexture;
import com.sun.prism.sw.SWTexture;

class SWTexturePool
extends BaseResourcePool<SWTexture>
implements TextureResourcePool<SWTexture> {
    static final SWTexturePool instance = new SWTexturePool();

    private static long maxVram() {
        long heapmax = Runtime.getRuntime().maxMemory();
        long setmax = PrismSettings.maxVram;
        return Math.min(heapmax / 4L, setmax);
    }

    private static long targetVram() {
        long max = SWTexturePool.maxVram();
        return Math.min(max / 2L, PrismSettings.targetVram);
    }

    private SWTexturePool() {
        super(null, SWTexturePool.targetVram(), SWTexturePool.maxVram());
    }

    @Override
    public long used() {
        return 0L;
    }

    @Override
    public long size(SWTexture resource) {
        long size = resource.getPhysicalWidth();
        size *= (long)resource.getPhysicalHeight();
        if (resource instanceof SWArgbPreTexture) {
            size *= 4L;
        }
        return size;
    }

    @Override
    public long estimateTextureSize(int width, int height, PixelFormat format) {
        switch (format) {
            case BYTE_ALPHA: {
                return (long)width * (long)height;
            }
        }
        return (long)width * (long)height * 4L;
    }

    @Override
    public long estimateRTTextureSize(int width, int height, boolean hasDepth) {
        return (long)width * (long)height * 4L;
    }
}

