/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.paint;

import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;

abstract class MultipleGradientContext {
    protected int cycleMethod;
    protected float a00;
    protected float a01;
    protected float a10;
    protected float a11;
    protected float a02;
    protected float a12;
    protected boolean isSimpleLookup;
    protected int fastGradientArraySize;
    protected int[] gradient;
    private int[][] gradients;
    private float[] normalizedIntervals;
    private float[] fractions;
    private int transparencyTest;
    protected static final int GRADIENT_SIZE = 256;
    protected static final int GRADIENT_SIZE_INDEX = 255;
    private static final int MAX_GRADIENT_ARRAY_SIZE = 5000;

    protected MultipleGradientContext(Gradient mgp, BaseTransform t, float[] fractions, Color[] colors, int cycleMethod) {
        BaseTransform tInv;
        if (t == null) {
            throw new NullPointerException("Transform cannot be null");
        }
        try {
            tInv = t.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            tInv = BaseTransform.IDENTITY_TRANSFORM;
        }
        this.a00 = (float)tInv.getMxx();
        this.a10 = (float)tInv.getMyx();
        this.a01 = (float)tInv.getMxy();
        this.a11 = (float)tInv.getMyy();
        this.a02 = (float)tInv.getMxt();
        this.a12 = (float)tInv.getMyt();
        this.cycleMethod = cycleMethod;
        this.fractions = fractions;
        this.calculateLookupData(colors);
    }

    private void calculateLookupData(Color[] colors) {
        Color[] normalizedColors = colors;
        this.normalizedIntervals = new float[this.fractions.length - 1];
        for (int i = 0; i < this.normalizedIntervals.length; ++i) {
            this.normalizedIntervals[i] = this.fractions[i + 1] - this.fractions[i];
        }
        this.transparencyTest = -16777216;
        this.gradients = new int[this.normalizedIntervals.length][];
        float Imin = 1.0f;
        for (int i = 0; i < this.normalizedIntervals.length; ++i) {
            Imin = Imin > this.normalizedIntervals[i] ? this.normalizedIntervals[i] : Imin;
        }
        float estimatedSize = 0.0f;
        for (int i = 0; i < this.normalizedIntervals.length && Float.isFinite(estimatedSize); ++i) {
            estimatedSize += this.normalizedIntervals[i] / Imin * 256.0f;
        }
        if (estimatedSize <= 5000.0f) {
            this.calculateSingleArrayGradient(normalizedColors, Imin);
        } else {
            this.calculateMultipleArrayGradient(normalizedColors);
        }
    }

    private void calculateSingleArrayGradient(Color[] colors, float Imin) {
        this.isSimpleLookup = true;
        int gradientsTot = 1;
        for (int i = 0; i < this.gradients.length; ++i) {
            int nGradients = (int)(this.normalizedIntervals[i] / Imin * 255.0f);
            gradientsTot += nGradients;
            this.gradients[i] = new int[nGradients];
            int rgb1 = colors[i].getIntArgbPre();
            int rgb2 = colors[i + 1].getIntArgbPre();
            this.interpolate(rgb1, rgb2, this.gradients[i]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
        this.gradient = new int[gradientsTot];
        int curOffset = 0;
        for (int i = 0; i < this.gradients.length; ++i) {
            System.arraycopy(this.gradients[i], 0, this.gradient, curOffset, this.gradients[i].length);
            curOffset += this.gradients[i].length;
        }
        this.gradient[this.gradient.length - 1] = colors[colors.length - 1].getIntArgbPre();
        this.fastGradientArraySize = this.gradient.length - 1;
    }

    private void calculateMultipleArrayGradient(Color[] colors) {
        this.isSimpleLookup = false;
        for (int i = 0; i < this.gradients.length; ++i) {
            this.gradients[i] = new int[256];
            int rgb1 = colors[i].getIntArgbPre();
            int rgb2 = colors[i + 1].getIntArgbPre();
            this.interpolate(rgb1, rgb2, this.gradients[i]);
            this.transparencyTest &= rgb1;
            this.transparencyTest &= rgb2;
        }
    }

    private void interpolate(int rgb1, int rgb2, int[] output) {
        float stepSize = 1.0f / (float)output.length;
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int da = (rgb2 >> 24 & 0xFF) - a1;
        int dr = (rgb2 >> 16 & 0xFF) - r1;
        int dg = (rgb2 >> 8 & 0xFF) - g1;
        int db = (rgb2 & 0xFF) - b1;
        for (int i = 0; i < output.length; ++i) {
            output[i] = (int)((double)((float)a1 + (float)(i * da) * stepSize) + 0.5) << 24 | (int)((double)((float)r1 + (float)(i * dr) * stepSize) + 0.5) << 16 | (int)((double)((float)g1 + (float)(i * dg) * stepSize) + 0.5) << 8 | (int)((double)((float)b1 + (float)(i * db) * stepSize) + 0.5);
        }
    }

    protected final int indexIntoGradientsArrays(float position) {
        if (this.cycleMethod == 0) {
            if (position > 1.0f) {
                position = 1.0f;
            } else if (position < 0.0f) {
                position = 0.0f;
            }
        } else if (this.cycleMethod == 2) {
            if ((position -= (float)((int)position)) < 0.0f) {
                position += 1.0f;
            }
        } else {
            if (position < 0.0f) {
                position = -position;
            }
            int part = (int)position;
            position -= (float)part;
            if ((part & 1) == 1) {
                position = 1.0f - position;
            }
        }
        if (this.isSimpleLookup) {
            return this.gradient[(int)(position * (float)this.fastGradientArraySize)];
        }
        if (position < this.fractions[0]) {
            return this.gradients[0][0];
        }
        for (int i = 0; i < this.gradients.length; ++i) {
            if (!(position < this.fractions[i + 1])) continue;
            float delta = position - this.fractions[i];
            int index = (int)(delta / this.normalizedIntervals[i] * 255.0f);
            return this.gradients[i][index];
        }
        return this.gradients[this.gradients.length - 1][255];
    }

    protected abstract void fillRaster(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7);
}

