/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.audio.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.audio.util.WesternScaleNote;
import org.openimaj.util.pair.IndependentPair;

public class MusicUtils {
    public static int millisPerBeat(float bpm) {
        return (int)(60000.0f / bpm);
    }

    public static List<IndependentPair<Integer, Double>> parseABCNotes(String abc) {
        ArrayList<IndependentPair<Integer, Double>> ret = new ArrayList<IndependentPair<Integer, Double>>();
        int nn = 60;
        boolean length = true;
        IndependentPair lastNote = null;
        for (int i = 0; i < abc.length(); ++i) {
            char c = abc.charAt(i);
            switch (c) {
                case '_': {
                    --nn;
                    break;
                }
                case '=': {
                    nn += 0;
                    break;
                }
                case '^': {
                    ++nn;
                    break;
                }
                case ',': {
                    nn -= 12;
                    break;
                }
                case '\'': {
                    nn += 12;
                    break;
                }
                case '/': {
                    if (lastNote == null) break;
                    lastNote.setSecondObject((Object)((Double)lastNote.getSecondObject() / 2.0));
                    break;
                }
                case '-': 
                case 'z': {
                    nn = -1;
                    break;
                }
            }
            if (Character.isDigit(c) && lastNote != null) {
                lastNote.setSecondObject((Object)((Double)lastNote.getSecondObject() * (double)(c - 48)));
            }
            if (Character.isLetter(c) && "abcdefgABCDEFG".contains("" + c)) {
                if (Character.isLowerCase(c)) {
                    nn += 12;
                }
                c = Character.toUpperCase(c);
                lastNote = new IndependentPair((Object)(nn += Arrays.asList(WesternScaleNote.noteNames).indexOf("" + c)), (Object)((double)length));
                ret.add((IndependentPair<Integer, Double>)lastNote);
                nn = 60;
                length = true;
                continue;
            }
            if (nn != -1) continue;
            ret.add((IndependentPair<Integer, Double>)new IndependentPair((Object)-1, (Object)((double)length)));
        }
        return ret;
    }
}

