/*
 * Decompiled with CFR 0.152.
 */
package view25d.view;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Set;
import org.nlogo.agent.Patch;
import org.nlogo.agent.TreeAgentSet;
import org.nlogo.agent.Turtle;
import org.nlogo.api.Agent;
import org.nlogo.api.AgentException;
import org.nlogo.api.AgentSet;
import org.nlogo.api.AnonymousReporter;
import org.nlogo.api.Color;
import org.nlogo.api.Context;
import org.nlogo.api.Link;
import org.nlogo.app.App;
import view25d.View25DExtension;
import view25d.view.LinkValue;
import view25d.view.MouseableGLWindow;
import view25d.view.PatchValue;
import view25d.view.PatchViewOptions;
import view25d.view.TurtleValue;
import view25d.view.TurtleView;
import view25d.view.VarviewWindow;
import view25d.view.gl.PatchGL;

public class PatchView
extends VarviewWindow {
    private static final long serialVersionUID = 1L;
    private PatchGL glManager;
    private AnonymousReporter reporter;
    public PatchViewOptions viewOptions;
    public PatchValue[][] reporterValueMatrix;
    public boolean doingTurtles = false;
    public ArrayList<TurtleValue> turtleValues = new ArrayList();
    public ArrayList<LinkValue> linkValues;

    @Override
    public MouseableGLWindow getGLWindow() {
        return this.glManager;
    }

    public PatchView(String title, AnonymousReporter rt) {
        super(title);
        this.reporter = rt;
    }

    public void postConstructor() {
        this.setupUI();
        this.setDefaultCloseOperation(2);
        final String myTitle = this.getTitle();
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                View25DExtension.removePatchWindowWithTitle(myTitle);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        GLCapabilities glCapabilities = new GLCapabilities(GLProfile.get((String)"GL2"));
        GLCanvas glCanvas = new GLCanvas((GLCapabilitiesImmutable)glCapabilities);
        this.glManager = new PatchGL(this);
        glCanvas.addGLEventListener((GLEventListener)this.glManager);
        glCanvas.addMouseListener((MouseListener)this.glManager);
        glCanvas.addMouseMotionListener((MouseMotionListener)this.glManager);
        glCanvas.addMouseWheelListener((MouseWheelListener)this.glManager);
        this.glManager.setCanvas(glCanvas);
        this.mainPanel.add((Component)glCanvas, "Center");
        this.viewOptions = new PatchViewOptions(this, true, false, false, true, false);
        this.mainPanel.add((Component)this.viewOptions, "North");
        this.setSize(new Dimension(600, 650));
        this.xExpand = 0;
        this.yExpand = 50;
        this.centerWindow(this);
    }

    public void setupForRendering(int wWidth, int wHeight, int minX, int maxX, int minY, int maxY) {
        this.worldWidth = wWidth;
        this.worldHeight = wHeight;
        this.minPxcor = minX;
        this.minPycor = minY;
        this.maxPxcor = maxX;
        this.maxPycor = maxY;
        this.reporterValueMatrix = new PatchValue[this.worldWidth][this.worldHeight];
    }

    public void updateValueArray(Context context) {
        for (int i = 0; i < this.worldWidth; ++i) {
            for (int j = 0; j < this.worldHeight; ++j) {
                try {
                    Patch patch = App.app().workspace().world().getPatchAt((double)(i + this.minPxcor), (double)(j + this.minPycor));
                    java.awt.Color c = Color.getColor((Object)patch.pcolor());
                    double val = (Double)this.reporter.report(context, new Object[]{patch});
                    this.reporterValueMatrix[i][j] = new PatchValue(c, val);
                    continue;
                }
                catch (AgentException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<TurtleValue> tempTurtles = new ArrayList<TurtleValue>();
        ArrayList<LinkValue> tempLinks = new ArrayList<LinkValue>();
        if (this.doingTurtles) {
            java.awt.Color c;
            TreeAgentSet as = App.app().workspace().world().turtles();
            for (Agent a : as.agents()) {
                Turtle t = (Turtle)a;
                if (t.hidden()) continue;
                double val = (Double)this.reporter.report(context, new Object[]{t});
                c = Color.getColor((Object)t.color());
                double stemColor = 4.5;
                TurtleValue tv = new TurtleValue(t.shape(), c, t.size(), t.xcor(), t.ycor(), val, stemColor);
                tv.setHeading(t.heading());
                tempTurtles.add(tv);
            }
            Set<Link> linkSet = TurtleView.getLinkSetFromTurtleSet((AgentSet)as);
            for (Link link : linkSet) {
                Turtle end1 = (Turtle)link.end1();
                Turtle end2 = (Turtle)link.end2();
                c = Color.getColor((Object)link.color());
                double zcor1 = (Double)this.reporter.report(context, new Object[]{end1});
                double zcor2 = (Double)this.reporter.report(context, new Object[]{end2});
                LinkValue lv = new LinkValue(link.shape(), c, link.lineThickness(), end1.xcor(), end1.ycor(), zcor1, end2.xcor(), end2.ycor(), zcor2);
                tempLinks.add(lv);
            }
        }
        this.turtleValues = tempTurtles;
        this.linkValues = tempLinks;
    }

    @Override
    public void manuallyRefreshReporterView(Context context) {
        this.updateValueArray(context);
        this.glManager.repaintCanvas();
    }

    public void refresh() {
        this.glManager.repaintCanvas();
    }

    public void updateTurtleShapes() {
        this.glManager.updateTurtleDisplayList();
        this.glManager.repaintCanvas();
    }

    @Override
    public void resetPerspective() {
        this.glManager.observer.goHome(this);
        this.glManager.repaintCanvas();
    }

    @Override
    public void zoomZby(double change) {
        if (-change < this.zScale) {
            this.zScale += change;
        }
        this.glManager.repaintCanvas();
    }
}

