/*
 * Decompiled with CFR 0.152.
 */
package org.ngs.ngunits.format;

import java.io.StringReader;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.ngs.ngunits.NonSI;
import org.ngs.ngunits.Prefix;
import org.ngs.ngunits.SI;
import org.ngs.ngunits.Unit;
import org.ngs.ngunits.UnitConverter;
import org.ngs.ngunits.converter.AddConverter;
import org.ngs.ngunits.converter.LogConverter;
import org.ngs.ngunits.converter.MultiplyConverter;
import org.ngs.ngunits.converter.RationalConverter;
import org.ngs.ngunits.format.ConverterFormat;
import org.ngs.ngunits.format.ParseException;
import org.ngs.ngunits.format.SymbolMap;
import org.ngs.ngunits.format.TokenMgrError;
import org.ngs.ngunits.format.UnitParser;
import org.ngs.ngunits.quantity.Mass;
import org.ngs.ngunits.unit.AlternateUnit;
import org.ngs.ngunits.unit.BaseUnit;
import org.ngs.ngunits.unit.DefaultUnitDelegate;
import org.ngs.ngunits.unit.ProductUnit;
import org.ngs.ngunits.unit.TransformedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnitFormat
extends Format {
    private static UnitFormat DEFAULT_INSTANCE = new UnitFormat(new SymbolMap(ResourceBundle.getBundle("org.ngs.ngunits.format.UnitFormat")));
    public static final int ADDITION_PRECEDENCE = 0;
    public static final int PRODUCT_PRECEDENCE = 2;
    public static final int EXPONENT_PRECEDENCE = 4;
    public static final int NOOP_PRECEDENCE = Integer.MAX_VALUE;
    protected SymbolMap _symbolMap;
    protected final Map<Class<? extends UnitConverter>, ConverterFormat> _converterFormats;
    protected boolean _asciiOnly;

    public static UnitFormat getInstance() {
        return UnitFormat.getInstance(Locale.getDefault());
    }

    public static UnitFormat getInstance(Locale locale) {
        if (locale.equals(DEFAULT_INSTANCE.getSymbols().getLocale())) {
            return DEFAULT_INSTANCE;
        }
        return new UnitFormat(new SymbolMap(ResourceBundle.getBundle("org.ngs.ngunits.format.UnitFormat", locale)));
    }

    public static UnitFormat getInstance(SymbolMap symbolMap) {
        return new UnitFormat(symbolMap);
    }

    protected UnitFormat(SymbolMap symbolMap) {
        this._symbolMap = symbolMap;
        this._converterFormats = new HashMap<Class<? extends UnitConverter>, ConverterFormat>();
        this._converterFormats.put(AddConverter.class, new AddConverterFormat());
        this._converterFormats.put(LogConverter.Log.class, new LogConverterFormat());
        this._converterFormats.put(LogConverter.Exp.class, new ExpConverterFormat());
        this._converterFormats.put(MultiplyConverter.class, new MultiplyConverterFormat());
        this._converterFormats.put(RationalConverter.class, new RationalConverterFormat());
        this._asciiOnly = false;
    }

    public SymbolMap getSymbols() {
        return this._symbolMap;
    }

    public void setSymbols(SymbolMap symbolMap) {
        this._symbolMap = symbolMap;
    }

    public boolean getAsciiOnly() {
        return this._asciiOnly;
    }

    public void setAsciiOnly(boolean bl) {
        this._asciiOnly = bl;
    }

    public void addConverterFormat(Class<? extends UnitConverter> clazz, ConverterFormat converterFormat) {
        this._converterFormats.put(clazz, converterFormat);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.formatInternal((Unit)object, stringBuffer);
        return stringBuffer;
    }

    protected int formatInternal(Unit<?> unit, StringBuffer stringBuffer) {
        String string = this._symbolMap.getSymbol(unit);
        if (string != null) {
            stringBuffer.append(string);
            return Integer.MAX_VALUE;
        }
        if (unit instanceof ProductUnit) {
            Map<Unit, Integer> map = unit.getProductUnits();
            int n = 0;
            boolean bl = true;
            for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
                if (entry.getValue() < 0) {
                    ++n;
                    continue;
                }
                this.formatExponent(entry.getKey(), entry.getValue(), !bl, stringBuffer);
                bl = false;
            }
            if (n > 0) {
                if (bl) {
                    stringBuffer.append('1');
                }
                stringBuffer.append('/');
                if (n > 1) {
                    stringBuffer.append('(');
                }
                bl = true;
                for (Map.Entry<Unit, Integer> entry : map.entrySet()) {
                    if (entry.getValue() >= 0) continue;
                    this.formatExponent(entry.getKey(), -entry.getValue().intValue(), !bl, stringBuffer);
                    bl = false;
                }
                if (n > 1) {
                    stringBuffer.append(')');
                }
            }
            return 2;
        }
        if (unit instanceof TransformedUnit || unit.equals(SI.KILOGRAM)) {
            UnitConverter unitConverter = null;
            boolean bl = false;
            StringBuffer stringBuffer2 = new StringBuffer();
            int n = Integer.MAX_VALUE;
            if (unit.equals(SI.KILOGRAM)) {
                unitConverter = Prefix.KILO.converter;
                n = this.formatInternal(SI.GRAM, stringBuffer2);
                bl = true;
            } else {
                TransformedUnit transformedUnit = (TransformedUnit)unit;
                Unit<Mass> unit2 = transformedUnit.getParent();
                unitConverter = transformedUnit.toParent();
                if (unit2.equals(SI.KILOGRAM)) {
                    unit2 = SI.GRAM;
                    unitConverter = unitConverter.concatenate(Prefix.KILO.converter);
                }
                n = this.formatInternal(unit2, stringBuffer2);
                bl = !unit2.equals(DefaultUnitDelegate.INSTANCE.one());
            }
            int n2 = this.formatConverter(unitConverter, bl, n, stringBuffer2);
            stringBuffer.append(stringBuffer2);
            return n2;
        }
        if (unit instanceof AlternateUnit) {
            stringBuffer.append(((AlternateUnit)unit).getSymbol());
            return Integer.MAX_VALUE;
        }
        if (unit instanceof BaseUnit) {
            stringBuffer.append(((BaseUnit)unit).getSymbol());
            return Integer.MAX_VALUE;
        }
        throw new IllegalArgumentException("Cannot format the given Object as a Unit (unsupported unit type " + unit.getClass().getName() + ")");
    }

    protected void formatExponent(Unit unit, int n, boolean bl, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2;
        int n2;
        if (bl) {
            stringBuffer.append(this._asciiOnly ? (char)'*' : '\u00b7');
        }
        if ((n2 = this.formatInternal(unit, stringBuffer2 = new StringBuffer())) < 2) {
            stringBuffer2.insert(0, '(');
            stringBuffer2.append(')');
        }
        stringBuffer.append(stringBuffer2);
        if (n != 1) {
            if (n > 1 && !this._asciiOnly) {
                String string = Integer.toString(n);
                block12: for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case '0': {
                            stringBuffer.append('\u2070');
                            continue block12;
                        }
                        case '1': {
                            stringBuffer.append('\u00b9');
                            continue block12;
                        }
                        case '2': {
                            stringBuffer.append('\u00b2');
                            continue block12;
                        }
                        case '3': {
                            stringBuffer.append('\u00b3');
                            continue block12;
                        }
                        case '4': {
                            stringBuffer.append('\u2074');
                            continue block12;
                        }
                        case '5': {
                            stringBuffer.append('\u2075');
                            continue block12;
                        }
                        case '6': {
                            stringBuffer.append('\u2076');
                            continue block12;
                        }
                        case '7': {
                            stringBuffer.append('\u2077');
                            continue block12;
                        }
                        case '8': {
                            stringBuffer.append('\u2078');
                            continue block12;
                        }
                        case '9': {
                            stringBuffer.append('\u2079');
                        }
                    }
                }
            } else {
                stringBuffer.append("^");
                stringBuffer.append(Integer.toString(n));
            }
        }
    }

    public int formatConverter(UnitConverter unitConverter, boolean bl, int n, StringBuffer stringBuffer) {
        Prefix prefix = this._symbolMap.getPrefix(unitConverter);
        if (prefix != null && n == Integer.MAX_VALUE) {
            stringBuffer.insert(0, this._symbolMap.getSymbol(prefix));
            return Integer.MAX_VALUE;
        }
        List<? extends UnitConverter> list = unitConverter.getCompoundConverters();
        if (list != null) {
            ListIterator<? extends UnitConverter> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                n = this.formatConverter(listIterator.previous(), bl, n, stringBuffer);
            }
            return n;
        }
        ConverterFormat converterFormat = this._converterFormats.get(unitConverter.getClass());
        if (converterFormat != null) {
            return converterFormat.formatConverter(unitConverter, bl, n, stringBuffer, this._asciiOnly);
        }
        throw new IllegalArgumentException("Unable to format converter: " + unitConverter);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        if (string == null || string.length() == 0) {
            parsePosition.setErrorIndex(0);
            return null;
        }
        try {
            UnitParser unitParser = new UnitParser(this._symbolMap, new StringReader(string));
            Unit unit = unitParser.parseUnit();
            parsePosition.setIndex(string.length());
            return unit;
        }
        catch (ParseException parseException) {
            if (parseException.currentToken != null) {
                parsePosition.setErrorIndex(parseException.currentToken.endColumn);
            } else {
                parsePosition.setErrorIndex(0);
            }
            return null;
        }
        catch (TokenMgrError tokenMgrError) {
            parsePosition.setErrorIndex(0);
            return null;
        }
    }

    private static void test(String string) {
        String string2 = "";
        boolean bl = false;
        try {
            Unit unit = (Unit)DEFAULT_INSTANCE.parseObject(string);
            string2 = DEFAULT_INSTANCE.format(unit);
            bl = string2.equals(string);
        }
        catch (java.text.ParseException parseException) {
            // empty catch block
        }
        System.out.println(string + " " + bl + (bl ? "" : ", " + string2));
    }

    public static void main(String[] stringArray) {
        UnitFormat.test("m\u00b7s+3");
        UnitFormat.test("(m+2)\u00b7s+3");
        UnitFormat.test("(km+2)\u00b7s+3");
        UnitFormat.test("(m+2)\u00b71000\u00b7s+3");
        UnitFormat.test("(m+2)\u00b71000\u00b7(s+3)");
        UnitFormat.test("m\u00b7(s+3)");
        UnitFormat.test("10^(m\u00b75)");
        UnitFormat.test("10^m\u00b75");
        UnitFormat.test("k");
        System.out.println(Locale.getDefault());
        System.out.println("  " + DEFAULT_INSTANCE.format(NonSI.GALLON_LIQUID_US));
        System.out.println("  " + DEFAULT_INSTANCE.format(NonSI.OUNCE_LIQUID_US));
        System.out.println("  " + DEFAULT_INSTANCE.format(NonSI.GALLON_UK));
        System.out.println("  " + DEFAULT_INSTANCE.format(NonSI.OUNCE_LIQUID_UK));
        System.out.println(Locale.UK);
        UnitFormat unitFormat = UnitFormat.getInstance(Locale.UK);
        System.out.println("  " + unitFormat.format(NonSI.GALLON_LIQUID_US));
        System.out.println("  " + unitFormat.format(NonSI.OUNCE_LIQUID_US));
        System.out.println("  " + unitFormat.format(NonSI.GALLON_UK));
        System.out.println("  " + unitFormat.format(NonSI.OUNCE_LIQUID_UK));
    }

    private static class RationalConverterFormat
    implements ConverterFormat {
        RationalConverterFormat() {
        }

        public int formatConverter(UnitConverter unitConverter, boolean bl, int n, StringBuffer stringBuffer, boolean bl2) {
            RationalConverter rationalConverter;
            if (n < 2) {
                stringBuffer.insert(0, '(');
                stringBuffer.append(')');
            }
            if ((rationalConverter = (RationalConverter)unitConverter).getDividend() != 1L) {
                if (bl) {
                    stringBuffer.append(bl2 ? (char)'*' : '\u00b7');
                }
                stringBuffer.append(rationalConverter.getDividend());
            }
            if (rationalConverter.getDivisor() != 1L) {
                stringBuffer.append('/');
                stringBuffer.append(rationalConverter.getDivisor());
            }
            return 2;
        }
    }

    private static class MultiplyConverterFormat
    implements ConverterFormat {
        MultiplyConverterFormat() {
        }

        public int formatConverter(UnitConverter unitConverter, boolean bl, int n, StringBuffer stringBuffer, boolean bl2) {
            double d;
            long l;
            if (n < 2) {
                stringBuffer.insert(0, '(');
                stringBuffer.append(')');
            }
            if (bl) {
                stringBuffer.append(bl2 ? (char)'*' : '\u00b7');
            }
            if ((double)(l = (long)(d = ((MultiplyConverter)unitConverter).getFactor())) == d) {
                stringBuffer.append(l);
            } else {
                stringBuffer.append(d);
            }
            return 2;
        }
    }

    private static class ExpConverterFormat
    implements ConverterFormat {
        ExpConverterFormat() {
        }

        public int formatConverter(UnitConverter unitConverter, boolean bl, int n, StringBuffer stringBuffer, boolean bl2) {
            if (n < 4) {
                stringBuffer.insert(0, '(');
                stringBuffer.append(')');
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            double d = ((LogConverter)unitConverter).getBase();
            if (d == Math.E) {
                stringBuffer2.append('e');
            } else {
                stringBuffer2.append((int)d);
            }
            stringBuffer2.append('^');
            stringBuffer.insert(0, stringBuffer2);
            return 4;
        }
    }

    private static class LogConverterFormat
    implements ConverterFormat {
        LogConverterFormat() {
        }

        public int formatConverter(UnitConverter unitConverter, boolean bl, int n, StringBuffer stringBuffer, boolean bl2) {
            double d = ((LogConverter)unitConverter).getBase();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (d == Math.E) {
                stringBuffer2.append("ln");
            } else {
                stringBuffer2.append("log");
                if (d != 10.0) {
                    stringBuffer2.append((int)d);
                }
            }
            stringBuffer2.append("(");
            stringBuffer.insert(0, stringBuffer2);
            stringBuffer.append(")");
            return 4;
        }
    }

    private static class AddConverterFormat
    implements ConverterFormat {
        AddConverterFormat() {
        }

        public int formatConverter(UnitConverter unitConverter, boolean bl, int n, StringBuffer stringBuffer, boolean bl2) {
            double d;
            if (n < 0) {
                stringBuffer.insert(0, '(');
                stringBuffer.append(')');
            }
            if ((d = ((AddConverter)unitConverter).getOffset()) < 0.0) {
                stringBuffer.append("-");
                d = -d;
            } else if (bl) {
                stringBuffer.append("+");
            }
            long l = (long)d;
            if ((double)l == d) {
                stringBuffer.append(l);
            } else {
                stringBuffer.append(d);
            }
            return 0;
        }
    }
}

