/*
 * Decompiled with CFR 0.152.
 */
package com.flickr4java.flickr.commons;

import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.Response;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.commons.Institution;
import com.flickr4java.flickr.util.XMLUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommonsInterface {
    public static final String METHOD_GET_INSTITUTIONS = "flickr.commons.getInstitutions";
    private final String apiKey;
    private final String sharedSecret;
    private final Transport transportAPI;

    public CommonsInterface(String apiKey, String sharedSecret, Transport transportAPI) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transportAPI = transportAPI;
    }

    public ArrayList<Institution> getInstitutions() throws FlickrException {
        ArrayList<Institution> institutions = new ArrayList<Institution>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("method", METHOD_GET_INSTITUTIONS);
        Response response = this.transportAPI.get(this.transportAPI.getPath(), parameters, this.apiKey, this.sharedSecret);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element mElement = response.getPayload();
        NodeList mNodes = mElement.getElementsByTagName("institution");
        for (int i = 0; i < mNodes.getLength(); ++i) {
            Element element = (Element)mNodes.item(i);
            institutions.add(this.parseInstitution(element));
        }
        return institutions;
    }

    private Institution parseInstitution(Element mElement) {
        Institution inst = new Institution();
        inst.setId(mElement.getAttribute("nsid"));
        inst.setDateLaunch(mElement.getAttribute("date_launch"));
        inst.setName(XMLUtilities.getChildValue(mElement, "name"));
        NodeList urlNodes = mElement.getElementsByTagName("url");
        for (int i = 0; i < urlNodes.getLength(); ++i) {
            Element urlElement = (Element)urlNodes.item(i);
            if (urlElement.getAttribute("type").equals("site")) {
                inst.setSiteUrl(XMLUtilities.getValue(urlElement));
                continue;
            }
            if (urlElement.getAttribute("type").equals("license")) {
                inst.setLicenseUrl(XMLUtilities.getValue(urlElement));
                continue;
            }
            if (!urlElement.getAttribute("type").equals("flickr")) continue;
            inst.setFlickrUrl(XMLUtilities.getValue(urlElement));
        }
        return inst;
    }
}

