/*
 * Decompiled with CFR 0.152.
 */
package org.tinfour.utils.loaders;

import org.tinfour.utils.LinearUnits;
import org.tinfour.utils.loaders.CoordinatePair;
import org.tinfour.utils.loaders.ICoordinateTransform;

public class SimpleGeographicTransform
implements ICoordinateTransform {
    public static final double earthSemiMajorAxis = 6378137.0;
    public static final double earthFlattening = 0.003352810664781205;
    public static final double earthSemiMinorAxis = 6356752.3142;
    private final double centerLatitude;
    private final double centerLongitude;
    private final LinearUnits linearUnits;
    private final double xScale;
    private final double yScale;

    public SimpleGeographicTransform(double centerLatitude, double centerLongitude, LinearUnits linearUnits) {
        this.centerLatitude = centerLatitude;
        this.centerLongitude = centerLongitude;
        this.linearUnits = linearUnits == null ? LinearUnits.METERS : linearUnits;
        if (Math.abs(centerLatitude) > 87.5) {
            throw new IllegalArgumentException("Latitude must be in range -87.5 to 87.5");
        }
        double a = 6378137.0;
        if (linearUnits != null) {
            a = linearUnits.toMeters(a);
        }
        double phi = Math.toRadians(centerLatitude);
        double sinPhi = Math.sin(phi);
        double adjustment = 1.0 - 0.003352810664781205 * sinPhi * sinPhi;
        double adjRadius = adjustment * a;
        this.xScale = Math.PI / 180 * adjRadius * Math.cos(phi);
        this.yScale = Math.PI / 180 * adjRadius;
    }

    @Override
    public boolean forward(double xSource, double ySource, CoordinatePair c) {
        if (Math.abs(ySource) > 89.0) {
            return false;
        }
        c.x = (xSource - this.getCenterLongitude()) * this.xScale;
        c.y = (ySource - this.getCenterLatitude()) * this.yScale;
        return true;
    }

    @Override
    public boolean inverse(double xOutput, double yOutput, CoordinatePair c) {
        c.x = xOutput / this.xScale + this.getCenterLongitude();
        c.y = yOutput / this.yScale + this.getCenterLatitude();
        return true;
    }

    public double getCenterLatitude() {
        return this.centerLatitude;
    }

    public double getCenterLongitude() {
        return this.centerLongitude;
    }

    public LinearUnits getLinearUnits() {
        return this.linearUnits;
    }
}

