/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.extensions.profiler;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.stream.Stream;
import org.nlogo.api.Argument;
import org.nlogo.api.Command;
import org.nlogo.api.Context;
import org.nlogo.api.DefaultClassManager;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionManager;
import org.nlogo.api.LogoException;
import org.nlogo.api.PrimitiveManager;
import org.nlogo.api.Reporter;
import org.nlogo.api.Version$;
import org.nlogo.core.LogoList;
import org.nlogo.core.Primitive;
import org.nlogo.core.Syntax;
import org.nlogo.core.SyntaxJ;
import org.nlogo.extensions.profiler.QuickTracer;
import org.nlogo.nvm.ExtensionContext;
import org.nlogo.nvm.Tracer;
import org.nlogo.nvm.Workspace;

public class ProfilerExtension
extends DefaultClassManager {
    public void load(PrimitiveManager primManager) {
        primManager.addPrimitive("start", (Primitive)new ProfilerStart());
        primManager.addPrimitive("stop", (Primitive)new ProfilerStop());
        primManager.addPrimitive("reset", (Primitive)new ProfilerReset());
        primManager.addPrimitive("report", (Primitive)new ProfilerReport());
        primManager.addPrimitive("data", (Primitive)new ProfilerData());
        primManager.addPrimitive("calls", (Primitive)new ProfilerProcedureCalls());
        primManager.addPrimitive("exclusive-time", (Primitive)new ProfilerProcedureExclusiveTime());
        primManager.addPrimitive("inclusive-time", (Primitive)new ProfilerProcedureInclusiveTime());
    }

    public void runOnce(ExtensionManager em) throws ExtensionException {
        QuickTracer tracer = new QuickTracer();
        ((org.nlogo.workspace.ExtensionManager)em).workspace().setProfilingTracer((Tracer)tracer);
        tracer.disable();
    }

    public void unload(ExtensionManager em) {
        ((org.nlogo.workspace.ExtensionManager)em).workspace().setProfilingTracer(null);
    }

    public static class ProfilerProcedureInclusiveTime
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                String arg0 = args[0].getString().toUpperCase();
                return (double)tracer.inclusiveTime(arg0) / 1000000.0;
            }
            return 0.0;
        }
    }

    public static class ProfilerProcedureExclusiveTime
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                String arg0 = args[0].getString().toUpperCase();
                return (double)tracer.exclusiveTime(arg0) / 1000000.0;
            }
            return 0.0;
        }
    }

    public static class ProfilerProcedureCalls
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int[])new int[]{Syntax.StringType()}, (int)Syntax.NumberType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException, LogoException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                String arg0 = args[0].getString().toUpperCase();
                return (double)tracer.calls(arg0);
            }
            return 0.0;
        }
    }

    public static class ProfilerData
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.ListType());
        }

        public Object report(Argument[] args, Context context) {
            Workspace workspace = ((ExtensionContext)context).workspace();
            QuickTracer tracer = (QuickTracer)workspace.profilingTracer();
            return tracer == null ? LogoList.Empty() : LogoList.fromJava(Stream.concat(Stream.of(LogoList.fromJava(Arrays.asList("procedure", "calls", "inclusive_time", "exclusive_time"))), tracer.procedureNames().stream().map(procedureName -> LogoList.fromJava(Arrays.asList(procedureName, Double.valueOf(tracer.calls((String)procedureName)), Double.valueOf(tracer.inclusiveTime((String)procedureName)), Double.valueOf(tracer.exclusiveTime((String)procedureName))))))::iterator);
        }
    }

    public static class ProfilerReport
    implements Reporter {
        public Syntax getSyntax() {
            return SyntaxJ.reporterSyntax((int)Syntax.StringType());
        }

        public Object report(Argument[] args, Context context) throws ExtensionException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                ByteArrayOutputStream outArray = new ByteArrayOutputStream();
                PrintStream out = new PrintStream(outArray);
                tracer.dump(out);
                return outArray.toString();
            }
            return "";
        }
    }

    public static class ProfilerReset
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                tracer.reset();
            }
        }
    }

    public static class ProfilerStop
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException {
            Tracer tracer = ((ExtensionContext)context).workspace().profilingTracer();
            if (tracer != null) {
                tracer.disable();
            }
        }
    }

    public static class ProfilerStart
    implements Command {
        public Syntax getSyntax() {
            return SyntaxJ.commandSyntax();
        }

        public void perform(Argument[] args, Context context) throws ExtensionException {
            if (!Version$.MODULE$.useGenerator()) {
                throw new ExtensionException("The profiler extension requires the NetLogo bytecode generator, which is currently turned off. See the org.nlogo.noGenerator property.");
            }
            ((ExtensionContext)context).workspace().profilingTracer().enable();
        }
    }
}

