/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.util;

public class Interpolation {
    public static float lerp(float x, float x0, float y0, float x1, float y1) {
        if (x == x0) {
            return y0;
        }
        return y0 + (x - x0) * ((y1 - y0) / (x1 - x0));
    }

    public static double lerp(double x, double x0, double y0, double x1, double y1) {
        if (x == x0) {
            return y0;
        }
        return y0 + (x - x0) * ((y1 - y0) / (x1 - x0));
    }

    public static double cubicInterp(double x, double y0, double y1, double y2, double y3) {
        return y1 + 0.5 * x * (y2 - y0 + x * (2.0 * y0 - 5.0 * y1 + 4.0 * y2 - y3 + x * (3.0 * (y1 - y2) + y3 - y0)));
    }

    public static float cubicInterp(float x, float y0, float y1, float y2, float y3) {
        return (float)((double)y1 + 0.5 * (double)x * ((double)(y2 - y0) + (double)x * (2.0 * (double)y0 - 5.0 * (double)y1 + 4.0 * (double)y2 - (double)y3 + (double)x * (3.0 * (double)(y1 - y2) + (double)y3 - (double)y0))));
    }

    public static double cubicInterp(double x, double[] y) {
        return y[1] + 0.5 * x * (y[2] - y[0] + x * (2.0 * y[0] - 5.0 * y[1] + 4.0 * y[2] - y[3] + x * (3.0 * (y[1] - y[2]) + y[3] - y[0])));
    }

    public static float cubicInterp(float x, float[] y) {
        return (float)((double)y[1] + 0.5 * (double)x * ((double)(y[2] - y[0]) + (double)x * (2.0 * (double)y[0] - 5.0 * (double)y[1] + 4.0 * (double)y[2] - (double)y[3] + (double)x * (3.0 * (double)(y[1] - y[2]) + (double)y[3] - (double)y[0]))));
    }

    public static double bilerp(double x, double y, double f00, double f01, double f10, double f11) {
        return f00 * (1.0 - x) * (1.0 - y) + f10 * x * (1.0 - y) + f01 * (1.0 - x) * y + f11 * x * y;
    }

    public static float bilerpf(float x, float y, float f00, float f01, float f10, float f11) {
        return f00 * (1.0f - x) * (1.0f - y) + f10 * x * (1.0f - y) + f01 * (1.0f - x) * y + f11 * x * y;
    }

    public static float bilerp(float x, float y, float f00, float f01, float f10, float f11) {
        return f00 * (1.0f - x) * (1.0f - y) + f10 * x * (1.0f - y) + f01 * (1.0f - x) * y + f11 * x * y;
    }

    public static double bicubicInterp(double x, double y, double[][] p) {
        double y0 = Interpolation.cubicInterp(y, p[0]);
        double y1 = Interpolation.cubicInterp(y, p[1]);
        double y2 = Interpolation.cubicInterp(y, p[2]);
        double y3 = Interpolation.cubicInterp(y, p[3]);
        return Interpolation.cubicInterp(x, y0, y1, y2, y3);
    }

    public static float bicubicInterp(float x, float y, float[][] p) {
        float y0 = Interpolation.cubicInterp(y, p[0]);
        float y1 = Interpolation.cubicInterp(y, p[1]);
        float y2 = Interpolation.cubicInterp(y, p[2]);
        float y3 = Interpolation.cubicInterp(y, p[3]);
        return Interpolation.cubicInterp(x, y0, y1, y2, y3);
    }
}

