/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.matrix;

import com.jmatio.types.MLArray;
import com.jmatio.types.MLDouble;
import gov.sandia.cognition.math.Ring;
import gov.sandia.cognition.math.matrix.DimensionalityMismatchException;
import gov.sandia.cognition.math.matrix.Matrix;
import gov.sandia.cognition.math.matrix.MatrixEntry;
import gov.sandia.cognition.math.matrix.MatrixFactory;
import gov.sandia.cognition.math.matrix.Vector;
import gov.sandia.cognition.math.matrix.mtj.DenseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseColumnMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseMatrixFactoryMTJ;
import gov.sandia.cognition.math.matrix.mtj.SparseRowMatrix;
import gov.sandia.cognition.math.matrix.mtj.SparseVector;
import java.util.Random;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.sparse.FlexCompColMatrix;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

public class CFMatrixUtils {
    private static final double EPS = 1.0E-100;

    public static Matrix abs(Matrix mat) {
        Matrix ret = mat.clone();
        int nrows = ret.getNumRows();
        int ncols = ret.getNumColumns();
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                ret.setElement(r, c, Math.abs(mat.getElement(r, c)));
            }
        }
        return ret;
    }

    public static double absSum(Matrix mat) {
        if (mat instanceof SparseColumnMatrix) {
            return CFMatrixUtils.absSumSparse((SparseColumnMatrix)mat);
        }
        if (mat instanceof SparseRowMatrix) {
            return CFMatrixUtils.absSumSparse((SparseRowMatrix)mat);
        }
        double tot = 0.0;
        int nrows = mat.getNumRows();
        int ncols = mat.getNumColumns();
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                double element = mat.getElement(r, c);
                if (Double.isNaN(element)) {
                    throw new RuntimeException("hmm?");
                }
                tot += Math.abs(element);
            }
        }
        return tot;
    }

    public static double absSumSparse(SparseColumnMatrix mat) {
        double sum = 0.0;
        for (int i = 0; i < mat.getNumColumns(); ++i) {
            sum += mat.getColumn(i).sum();
        }
        return sum;
    }

    public static double absSumSparse(SparseRowMatrix mat) {
        double sum = 0.0;
        for (int i = 0; i < mat.getNumRows(); ++i) {
            sum += mat.getRow(i).sum();
        }
        return sum;
    }

    public static Matrix timesInplace(Matrix mat, double etat) {
        mat.scaleEquals(etat);
        return mat;
    }

    public static Matrix asMat(MLArray mlArray) {
        MLDouble mlArrayDbl = (MLDouble)mlArray;
        int rows = mlArray.getM();
        int cols = mlArray.getN();
        SparseMatrix mat = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(rows, cols);
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                mat.setElement(r, c, ((Double)mlArrayDbl.get(r, c)).doubleValue());
            }
        }
        return mat;
    }

    public static MLArray toMLArray(String name, Matrix mat) {
        MLDouble mlArrayDbl = new MLDouble(name, new int[]{mat.getNumRows(), mat.getNumColumns()});
        for (MatrixEntry matrixEntry : mat) {
            mlArrayDbl.set((Number)matrixEntry.getValue(), matrixEntry.getRowIndex(), matrixEntry.getColumnIndex());
        }
        return mlArrayDbl;
    }

    public static double rowSparsity(Matrix mat) {
        double nrows = mat.getNumRows();
        double nsparse = 0.0;
        int r = 0;
        while ((double)r < nrows) {
            if (mat.getRow(r).sum() == 0.0) {
                nsparse += 1.0;
            }
            ++r;
        }
        return nsparse / nrows;
    }

    public static double colSparcity(Matrix mat) {
        double ncols = mat.getNumColumns();
        double nsparse = 0.0;
        int c = 0;
        while ((double)c < ncols) {
            if (mat.getColumn(c).sum() == 0.0) {
                nsparse += 1.0;
            }
            ++c;
        }
        return nsparse / ncols;
    }

    public static Matrix plusInplace(Matrix mat, double etat) {
        int nrows = mat.getNumRows();
        int ncols = mat.getNumColumns();
        for (int r = 0; r < nrows; ++r) {
            for (int c = 0; c < ncols; ++c) {
                mat.setElement(r, c, mat.getElement(r, c) + etat);
            }
        }
        return mat;
    }

    public static Vector diag(Matrix mat) {
        Vector ret = mat.getNumColumns() > mat.getNumRows() ? mat.getRow(0) : mat.getColumn(0);
        int rowcol = ret.getDimensionality();
        for (int rc = 0; rc < rowcol; ++rc) {
            ret.setElement(rc, mat.getElement(rc, rc));
        }
        return ret;
    }

    public static Matrix vstack(MatrixFactory<? extends Matrix> matrixFactory, Matrix ... matricies) {
        int nrows = 0;
        int ncols = 0;
        for (Matrix matrix : matricies) {
            nrows += matrix.getNumRows();
            ncols = matrix.getNumColumns();
        }
        Matrix ret = matrixFactory.createMatrix(nrows, ncols);
        int currentRow = 0;
        for (Matrix matrix : matricies) {
            ret.setSubMatrix(currentRow, 0, matrix);
            currentRow += matrix.getNumRows();
        }
        return ret;
    }

    public static Matrix vstack(Matrix ... matricies) {
        return CFMatrixUtils.vstack((MatrixFactory<? extends Matrix>)MatrixFactory.getDefault(), matricies);
    }

    public static double[] getData(Matrix w) {
        return ((DenseMatrix)DenseMatrixFactoryMTJ.INSTANCE.copyMatrix(w).getInternalMatrix()).getData();
    }

    public static double min(Matrix u) {
        double min = Double.MAX_VALUE;
        for (MatrixEntry matrixEntry : u) {
            min = Math.min(min, matrixEntry.getValue());
        }
        return min;
    }

    public static double max(Matrix u) {
        double max = -1.7976931348623157E308;
        for (MatrixEntry matrixEntry : u) {
            max = Math.max(max, matrixEntry.getValue());
        }
        return max;
    }

    public static double min(Vector column) {
        double min = Double.MAX_VALUE;
        for (gov.sandia.cognition.math.matrix.VectorEntry vectorEntry : column) {
            min = Math.min(min, vectorEntry.getValue());
        }
        return min;
    }

    public static double max(Vector column) {
        double max = -1.7976931348623157E308;
        for (gov.sandia.cognition.math.matrix.VectorEntry vectorEntry : column) {
            max = Math.max(max, vectorEntry.getValue());
        }
        return max;
    }

    public static double sparsity(Matrix mat) {
        double count = 0.0;
        double size = mat.getNumRows() * mat.getNumColumns();
        if (mat instanceof SparseRowMatrix) {
            for (int i = 0; i < mat.getNumRows(); ++i) {
                SparseVector row = (SparseVector)mat.getRow(i);
                count += (double)row.getNumElementsUsed();
            }
        } else if (mat instanceof SparseColumnMatrix) {
            for (int i = 0; i < mat.getNumColumns(); ++i) {
                SparseVector col = (SparseVector)mat.getColumn(i);
                count += (double)col.getNumElementsUsed();
            }
        } else {
            for (MatrixEntry matrixEntry : mat) {
                if (matrixEntry.getValue() == 0.0) continue;
                count += 1.0;
            }
        }
        return (size - count) / size;
    }

    public static <T extends Matrix> T powInplace(T degree, double d) {
        for (MatrixEntry ent : degree) {
            degree.setElement(ent.getRowIndex(), ent.getColumnIndex(), Math.pow(ent.getValue(), d));
        }
        return degree;
    }

    public static <T extends Vector> T powInplace(T degree, double d) {
        for (gov.sandia.cognition.math.matrix.VectorEntry ent : degree) {
            degree.setElement(ent.getIndex(), Math.pow(ent.getValue(), d));
        }
        return degree;
    }

    public static Jama.Matrix asJama(Matrix laplacian) {
        Jama.Matrix ret = new Jama.Matrix(laplacian.getNumRows(), laplacian.getNumColumns());
        for (MatrixEntry matrixEntry : laplacian) {
            ret.set(matrixEntry.getRowIndex(), matrixEntry.getColumnIndex(), matrixEntry.getValue());
        }
        return ret;
    }

    public static Vector rowMean(Matrix vt) {
        Vector sumOfColumns = vt.sumOfColumns();
        sumOfColumns.scaleEquals(1.0 / (double)vt.getNumColumns());
        return sumOfColumns;
    }

    public static Vector colMean(Matrix vt) {
        Vector sumOfColumns = vt.sumOfRows();
        sumOfColumns.scaleEquals(1.0 / (double)vt.getNumRows());
        return sumOfColumns;
    }

    public static void minusEqualsCol(Matrix A, Vector col) {
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumColumns(); ++j) {
                A.setElement(i, j, A.getElement(i, j) - col.getElement(i));
            }
        }
    }

    public static void minusEqualsRow(Matrix A, Vector row) {
        for (int i = 0; i < A.getNumRows(); ++i) {
            for (int j = 0; j < A.getNumColumns(); ++j) {
                A.setElement(i, j, A.getElement(i, j) - row.getElement(j));
            }
        }
    }

    public static SparseColumnMatrix randomSparseCol(int rows, int cols, double min, double max, double density, Random random) {
        SparseColumnMatrix ret = SparseMatrixFactoryMTJ.INSTANCE.createWrapper(new FlexCompColMatrix(rows, cols));
        for (int i = 0; i < cols; ++i) {
            SparseVector v = ret.getColumn(i);
            for (int j = 0; j < rows; ++j) {
                if (!(random.nextDouble() <= density)) continue;
                v.setElement(j, random.nextDouble() * (max - min) + min);
            }
        }
        return ret;
    }

    public static SparseRowMatrix randomSparseRow(int rows, int cols, double min, double max, double density, Random random) {
        SparseRowMatrix ret = SparseMatrixFactoryMTJ.INSTANCE.createWrapper(new FlexCompRowMatrix(rows, cols));
        for (int i = 0; i < rows; ++i) {
            SparseVector v = ret.getRow(i);
            for (int j = 0; j < cols; ++j) {
                if (!(random.nextDouble() <= density)) continue;
                v.setElement(j, random.nextDouble() * (max - min) + min);
            }
        }
        return ret;
    }

    public static SparseRowMatrix fastsparsedot(SparseRowMatrix a, SparseColumnMatrix b) {
        SparseMatrix ret = SparseMatrixFactoryMTJ.INSTANCE.createMatrix(a.getNumRows(), b.getNumColumns());
        if (a.getNumColumns() != b.getNumRows()) {
            return null;
        }
        for (int i = 0; i < a.getNumRows(); ++i) {
            no.uib.cipr.matrix.sparse.SparseVector arow = a.getInternalMatrix().getRow(i);
            for (int j = 0; j < b.getNumColumns(); ++j) {
                no.uib.cipr.matrix.sparse.SparseVector other;
                no.uib.cipr.matrix.sparse.SparseVector leading;
                double v = 0.0;
                no.uib.cipr.matrix.sparse.SparseVector bcol = b.getInternalMatrix().getColumn(j);
                if (arow.getUsed() < bcol.getUsed()) {
                    leading = arow;
                    other = bcol;
                } else {
                    leading = bcol;
                    other = arow;
                }
                for (VectorEntry vectorEntry : leading) {
                    v += vectorEntry.get() * other.get(vectorEntry.index());
                }
                if (!(Math.abs(v) > 1.0E-100)) continue;
                ret.setElement(i, j, v);
            }
        }
        return ret;
    }

    public static Matrix fastdot(Matrix a, Matrix b) {
        if (a instanceof SparseRowMatrix && b instanceof SparseColumnMatrix) {
            return CFMatrixUtils.fastsparsedot((SparseRowMatrix)a, (SparseColumnMatrix)b);
        }
        return a.times(b);
    }

    public static SparseColumnMatrix asSparseColumn(Matrix a) {
        return SparseMatrixFactoryMTJ.INSTANCE.createWrapper(new FlexCompColMatrix((no.uib.cipr.matrix.Matrix)SparseMatrixFactoryMTJ.INSTANCE.copyMatrix(a).getInternalMatrix()));
    }

    public static SparseRowMatrix asSparseRow(Matrix a) {
        return SparseMatrixFactoryMTJ.INSTANCE.copyMatrix(a);
    }

    public static void fastsetcol(Matrix ret, int c, Vector col) {
        if (ret instanceof SparseColumnMatrix && col instanceof SparseVector) {
            ((SparseColumnMatrix)ret).setColumn(c, (SparseVector)col);
        } else {
            ret.setColumn(c, col);
        }
    }

    public static Matrix fastminusEquals(Matrix A, Matrix B) {
        if (A instanceof SparseColumnMatrix && B instanceof SparseColumnMatrix) {
            return CFMatrixUtils.fastsparseminusEquals((SparseColumnMatrix)A, (SparseColumnMatrix)B);
        }
        A.minusEquals((Ring)B);
        return A;
    }

    public static Matrix fastminus(Matrix A, Matrix B) {
        return CFMatrixUtils.fastminusEquals(A.clone(), B);
    }

    public static Matrix fastsparseminusEquals(SparseColumnMatrix A, SparseColumnMatrix B) {
        if (A.getNumColumns() != B.getNumColumns() || A.getNumRows() != B.getNumRows()) {
            throw new DimensionalityMismatchException();
        }
        SparseColumnMatrix ret = A;
        FlexCompColMatrix retint = ret.getInternalMatrix();
        FlexCompColMatrix Bint = B.getInternalMatrix();
        for (int i = 0; i < A.getNumColumns(); ++i) {
            no.uib.cipr.matrix.sparse.SparseVector aCol = retint.getColumn(i);
            no.uib.cipr.matrix.sparse.SparseVector bCol = Bint.getColumn(i);
            aCol.add(-1.0, (no.uib.cipr.matrix.Vector)bCol);
        }
        return ret;
    }

    public static Matrix fastsparseminusEquals(SparseRowMatrix A, SparseRowMatrix B) {
        if (A.getNumColumns() != B.getNumColumns() || A.getNumRows() != B.getNumRows()) {
            throw new DimensionalityMismatchException();
        }
        SparseRowMatrix ret = A;
        FlexCompRowMatrix retInt = ret.getInternalMatrix();
        FlexCompRowMatrix bint = B.getInternalMatrix();
        for (int i = 0; i < A.getNumRows(); ++i) {
            no.uib.cipr.matrix.sparse.SparseVector aCol = retInt.getRow(i);
            no.uib.cipr.matrix.sparse.SparseVector bCol = bint.getRow(i);
            aCol.add(-1.0, (no.uib.cipr.matrix.Vector)bCol);
        }
        return ret;
    }

    public static boolean containsNaN(Matrix mat) {
        for (MatrixEntry matrixEntry : mat) {
            if (!Double.isNaN(matrixEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsNaN(Vector vec) {
        for (gov.sandia.cognition.math.matrix.VectorEntry vectorEntry : vec) {
            if (!Double.isNaN(vectorEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean containsInfinity(Matrix mat) {
        for (MatrixEntry matrixEntry : mat) {
            if (!Double.isInfinite(matrixEntry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static double sum(Matrix A) {
        double sum = 0.0;
        for (MatrixEntry matrixEntry : A) {
            sum += matrixEntry.getValue();
        }
        return sum;
    }
}

