/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.math.geometry.transforms.estimation;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.transforms.HomographyModel;
import org.openimaj.math.geometry.transforms.HomographyRefinement;
import org.openimaj.math.geometry.transforms.TransformUtilities;
import org.openimaj.math.geometry.transforms.estimation.sampling.BucketingSampler2d;
import org.openimaj.math.geometry.transforms.residuals.SymmetricTransferResidual2d;
import org.openimaj.math.model.fit.LMedS;
import org.openimaj.math.model.fit.RANSAC;
import org.openimaj.math.model.fit.RobustModelFitting;
import org.openimaj.util.function.Predicate;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.pair.Pair;

public class RobustHomographyEstimator
implements RobustModelFitting<Point2d, Point2d, HomographyModel> {
    private RobustModelFitting<Point2d, Point2d, HomographyModel> robustFitter;
    private HomographyRefinement refinement;
    List<IndependentPair<Point2d, Point2d>> inliers = new ArrayList<IndependentPair<Point2d, Point2d>>();
    List<IndependentPair<Point2d, Point2d>> outliers = new ArrayList<IndependentPair<Point2d, Point2d>>();

    public RobustHomographyEstimator(double outlierProportion, HomographyRefinement refinement) {
        this.robustFitter = new LMedS<Point2d, Point2d, HomographyModel>(new HomographyModel(false), new SymmetricTransferResidual2d(), outlierProportion, true, new BucketingSampler2d());
        this.refinement = refinement;
    }

    public RobustHomographyEstimator(double threshold, int nIterations, RANSAC.StoppingCondition stoppingCondition, HomographyRefinement refinement) {
        this.robustFitter = new RANSAC<Point2d, Point2d, HomographyModel>(new HomographyModel(false), new SymmetricTransferResidual2d(), threshold, nIterations, stoppingCondition, true, new BucketingSampler2d());
        this.refinement = refinement;
    }

    public RobustHomographyEstimator(double outlierProportion, HomographyRefinement refinement, Predicate<HomographyModel> modelCheck) {
        this.robustFitter = new LMedS<Point2d, Point2d, HomographyModel>(new HomographyModel(false, modelCheck), new SymmetricTransferResidual2d(), outlierProportion, true, new BucketingSampler2d());
        this.refinement = refinement;
    }

    public RobustHomographyEstimator(double threshold, int nIterations, RANSAC.StoppingCondition stoppingCondition, HomographyRefinement refinement, Predicate<HomographyModel> modelCheck) {
        this.robustFitter = new RANSAC<Point2d, Point2d, HomographyModel>(new HomographyModel(false, modelCheck), new SymmetricTransferResidual2d(), threshold, nIterations, stoppingCondition, true, new BucketingSampler2d());
        this.refinement = refinement;
    }

    @Override
    public boolean fitData(List<? extends IndependentPair<Point2d, Point2d>> data) {
        Pair<Matrix> norms = TransformUtilities.getNormalisations(data);
        List<? extends IndependentPair<Point2d, Point2d>> normData = TransformUtilities.normalise(data, norms);
        if (!this.robustFitter.fitData(normData)) {
            ((HomographyModel)this.robustFitter.getModel()).estimate(normData);
            ((HomographyModel)this.robustFitter.getModel()).denormaliseHomography(norms);
            return false;
        }
        this.inliers.clear();
        for (IndependentPair<Point2d, Point2d> pair : this.robustFitter.getInliers()) {
            this.inliers.add(data.get(normData.indexOf(pair)));
        }
        this.outliers.clear();
        for (IndependentPair<Point2d, Point2d> pair : this.robustFitter.getOutliers()) {
            this.outliers.add(data.get(normData.indexOf(pair)));
        }
        ((HomographyModel)this.robustFitter.getModel()).denormaliseHomography(norms);
        Matrix optimised = this.refinement.refine(((HomographyModel)this.robustFitter.getModel()).getTransform(), this.inliers);
        ((HomographyModel)this.robustFitter.getModel()).setTransform(optimised);
        return true;
    }

    @Override
    public int numItemsToEstimate() {
        return this.robustFitter.numItemsToEstimate();
    }

    @Override
    public HomographyModel getModel() {
        return (HomographyModel)this.robustFitter.getModel();
    }

    @Override
    public List<? extends IndependentPair<Point2d, Point2d>> getInliers() {
        return this.inliers;
    }

    @Override
    public List<? extends IndependentPair<Point2d, Point2d>> getOutliers() {
        return this.outliers;
    }
}

