/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.renderer;

import java.util.Arrays;
import org.openimaj.image.FImage;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.renderer.MultiBandRenderer;
import org.openimaj.image.renderer.RenderHints;

public class MBFImageRenderer
extends MultiBandRenderer<Float, MBFImage, FImage> {
    public MBFImageRenderer(MBFImage targetImage) {
        super(targetImage);
    }

    public MBFImageRenderer(MBFImage targetImage, RenderHints hints) {
        super(targetImage, hints);
    }

    @Override
    public Float[] defaultBackgroundColour() {
        return new Float[((MBFImage)this.targetImage).numBands()];
    }

    @Override
    public Float[] defaultForegroundColour() {
        Object[] c = new Float[((MBFImage)this.targetImage).numBands()];
        Arrays.fill(c, Float.valueOf(1.0f));
        return c;
    }

    @Override
    public void drawImage(MBFImage image, int x, int y) {
        int imageBands;
        int targetBands = ((MBFImage)this.targetImage).numBands();
        if (targetBands == (imageBands = image.numBands()) && targetBands == 3) {
            this.drawImage3(image, x, y);
            return;
        }
        if (targetBands < 3 || targetBands > 4 || imageBands < 3 || imageBands > 4) {
            super.drawImage(image, x, y);
            return;
        }
        int stopx = Math.min(((MBFImage)this.targetImage).getWidth(), x + image.getWidth());
        int stopy = Math.min(((MBFImage)this.targetImage).getHeight(), y + image.getHeight());
        int startx = Math.max(0, x);
        int starty = Math.max(0, y);
        float[][][] thisPixels = new float[targetBands][][];
        for (int i = 0; i < thisPixels.length; ++i) {
            thisPixels[i] = ((FImage)((MBFImage)this.targetImage).getBand((int)i)).pixels;
        }
        float[][][] thatPixels = new float[imageBands][][];
        for (int i = 0; i < thatPixels.length; ++i) {
            thatPixels[i] = ((FImage)image.getBand((int)i)).pixels;
        }
        if (thisPixels.length == 4 && thatPixels.length == 4) {
            this.drawBothAlpha(x, y, stopx, stopy, startx, starty, thisPixels, thatPixels);
        } else if (thisPixels.length == 4) {
            this.drawThisAlpha(x, y, stopx, stopy, startx, starty, thisPixels, thatPixels);
        } else {
            this.drawThatAlpha(x, y, stopx, stopy, startx, starty, thisPixels, thatPixels);
        }
    }

    private void drawBothAlpha(int x, int y, int stopx, int stopy, int startx, int starty, float[][][] thisPixels, float[][][] thatPixels) {
        float[] out = new float[4];
        for (int yy = starty; yy < stopy; ++yy) {
            int thatY = yy - y;
            for (int xx = startx; xx < stopx; ++xx) {
                int thatX = xx - x;
                float thisA = thisPixels[3][yy][xx];
                float thatA = thatPixels[3][thatY][thatX];
                ImageUtilities.alphaCompositePixel(out, thisPixels[0][yy][xx], thisPixels[1][yy][xx], thisPixels[2][yy][xx], thisA, thatPixels[0][thatY][thatX], thatPixels[1][thatY][thatX], thatPixels[2][thatY][thatX], thatA);
                thisPixels[0][yy][xx] = out[0];
                thisPixels[1][yy][xx] = out[1];
                thisPixels[2][yy][xx] = out[2];
                thisPixels[3][yy][xx] = out[3];
            }
        }
    }

    private void drawThisAlpha(int x, int y, int stopx, int stopy, int startx, int starty, float[][][] thisPixels, float[][][] thatPixels) {
        float[] out = new float[4];
        for (int yy = starty; yy < stopy; ++yy) {
            int thatY = yy - y;
            for (int xx = startx; xx < stopx; ++xx) {
                int thatX = xx - x;
                float thisA = thisPixels[3][yy][xx];
                float thatA = 1.0f;
                ImageUtilities.alphaCompositePixel(out, thisPixels[0][yy][xx], thisPixels[1][yy][xx], thisPixels[2][yy][xx], thisA, thatPixels[0][thatY][thatX], thatPixels[1][thatY][thatX], thatPixels[2][thatY][thatX], thatA);
                thisPixels[0][yy][xx] = out[0];
                thisPixels[1][yy][xx] = out[1];
                thisPixels[2][yy][xx] = out[2];
                thisPixels[3][yy][xx] = out[3];
            }
        }
    }

    private void drawThatAlpha(int x, int y, int stopx, int stopy, int startx, int starty, float[][][] thisPixels, float[][][] thatPixels) {
        float[] out = new float[4];
        for (int yy = starty; yy < stopy; ++yy) {
            int thatY = yy - y;
            for (int xx = startx; xx < stopx; ++xx) {
                int thatX = xx - x;
                float thisA = 1.0f;
                float thatA = thatPixels[3][thatY][thatX];
                ImageUtilities.alphaCompositePixel(out, thisPixels[0][yy][xx], thisPixels[1][yy][xx], thisPixels[2][yy][xx], thisA, thatPixels[0][thatY][thatX], thatPixels[1][thatY][thatX], thatPixels[2][thatY][thatX], thatA);
                thisPixels[0][yy][xx] = out[0];
                thisPixels[1][yy][xx] = out[1];
                thisPixels[2][yy][xx] = out[2];
            }
        }
    }

    protected void drawImage3(MBFImage image, int x, int y) {
        int stopx = Math.max(0, Math.min(((MBFImage)this.targetImage).getWidth(), x + image.getWidth()));
        int stopy = Math.max(0, Math.min(((MBFImage)this.targetImage).getHeight(), y + image.getHeight()));
        int startx = Math.max(0, x);
        int starty = Math.max(0, y);
        if (startx >= stopx || starty >= stopy) {
            return;
        }
        float[][][] thisPixels = new float[3][][];
        for (int i = 0; i < thisPixels.length; ++i) {
            thisPixels[i] = ((FImage)((MBFImage)this.targetImage).getBand((int)i)).pixels;
        }
        float[][][] thatPixels = new float[3][][];
        for (int i = 0; i < thatPixels.length; ++i) {
            thatPixels[i] = ((FImage)image.getBand((int)i)).pixels;
        }
        for (int yy = starty; yy < stopy; ++yy) {
            int thatY = yy - y;
            System.arraycopy(thatPixels[0][thatY], startx - x, thisPixels[0][yy], startx, stopx - startx);
            System.arraycopy(thatPixels[1][thatY], startx - x, thisPixels[1][yy], startx, stopx - startx);
            System.arraycopy(thatPixels[2][thatY], startx - x, thisPixels[2][yy], startx, stopx - startx);
        }
    }

    @Override
    protected void drawHorizLine(int x1, int x2, int y, Float[] col) {
        col = this.sanitise(col);
        if (y < 0 || y > ((MBFImage)this.targetImage).getHeight() - 1) {
            return;
        }
        int startx = Math.max(0, Math.min(x1, x2));
        int stopx = Math.min(Math.max(x1, x2), ((MBFImage)this.targetImage).getWidth() - 1);
        int nbands = Math.min(col.length, ((MBFImage)this.targetImage).numBands());
        for (int b = 0; b < nbands; ++b) {
            float[][] img = ((FImage)((MBFImage)this.targetImage).getBand((int)b)).pixels;
            float c = col[b].floatValue();
            for (int x = startx; x <= stopx; ++x) {
                img[y][x] = c;
            }
        }
    }

    @Override
    protected Float[] sanitise(Float[] colour) {
        return ((MBFImage)this.targetImage).colourSpace.sanitise(colour);
    }
}

