/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processor.connectedcomponent.render;

import java.util.EnumMap;
import java.util.EnumSet;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.image.processor.connectedcomponent.render.AxisRenderer;
import org.openimaj.image.processor.connectedcomponent.render.BlobRenderer;
import org.openimaj.image.processor.connectedcomponent.render.BorderRenderer;
import org.openimaj.image.processor.connectedcomponent.render.CentroidRenderer;
import org.openimaj.image.processor.connectedcomponent.render.ConfigurableRenderOptions;
import org.openimaj.math.geometry.shape.Polygon;

public class ConfigurableRendererMono
implements ConnectedComponentProcessor {
    protected FImage image;
    protected EnumSet<ConfigurableRenderOptions> options;
    EnumMap<ConfigurableRenderOptions, Float> shade = new EnumMap(ConfigurableRenderOptions.class);

    protected ConfigurableRendererMono(EnumSet<ConfigurableRenderOptions> options) {
        this.options = options;
        this.shade.put(ConfigurableRenderOptions.AXIS, Float.valueOf(0.8f));
        this.shade.put(ConfigurableRenderOptions.BLOB, Float.valueOf(0.5f));
        this.shade.put(ConfigurableRenderOptions.BORDER, Float.valueOf(0.7f));
        this.shade.put(ConfigurableRenderOptions.CENTROID, Float.valueOf(0.7f));
        this.shade.put(ConfigurableRenderOptions.CH_AXIS, Float.valueOf(0.9f));
        this.shade.put(ConfigurableRenderOptions.CH_BLOB, Float.valueOf(0.2f));
        this.shade.put(ConfigurableRenderOptions.CH_BORDER, Float.valueOf(1.0f));
        this.shade.put(ConfigurableRenderOptions.CH_CENTROID, Float.valueOf(1.0f));
    }

    public ConfigurableRendererMono(FImage image, EnumSet<ConfigurableRenderOptions> options) {
        this(options);
        this.image = image;
    }

    public ConfigurableRendererMono(int width, int height, EnumSet<ConfigurableRenderOptions> options) {
        this(options);
        this.image = new FImage(width, height);
    }

    public FImage getImage() {
        return this.image;
    }

    @Override
    public void process(ConnectedComponent cc) {
        Polygon ch = cc.calculateConvexHull();
        ConnectedComponent chcc = new ConnectedComponent(ch);
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_BLOB)) {
            chcc.process(new BlobRenderer<Float>(this.image, this.shade.get((Object)ConfigurableRenderOptions.CH_BLOB)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.BLOB)) {
            cc.process(new BlobRenderer<Float>(this.image, this.shade.get((Object)ConfigurableRenderOptions.BLOB)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_BORDER)) {
            this.image.createRenderer().drawPolygon(ch, this.shade.get((Object)ConfigurableRenderOptions.CH_BORDER));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.BORDER)) {
            cc.process(new BorderRenderer<Float>(this.image, this.shade.get((Object)ConfigurableRenderOptions.BLOB), ConnectedComponent.ConnectMode.CONNECT_8));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_CENTROID)) {
            chcc.process(new CentroidRenderer<Float>(this.image, this.shade.get((Object)ConfigurableRenderOptions.CH_CENTROID)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CENTROID)) {
            cc.process(new CentroidRenderer<Float>(this.image, this.shade.get((Object)ConfigurableRenderOptions.CENTROID)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.CH_AXIS)) {
            chcc.process(new AxisRenderer<Float>(this.image, this.shade.get((Object)ConfigurableRenderOptions.CH_AXIS)));
        }
        if (this.options.contains((Object)ConfigurableRenderOptions.AXIS)) {
            cc.process(new AxisRenderer<Float>(this.image, this.shade.get((Object)ConfigurableRenderOptions.AXIS)));
        }
    }

    public void setColour(ConfigurableRenderOptions r, Float colour) {
        this.shade.put(r, colour);
    }

    public Float getColour(ConfigurableRenderOptions r) {
        return this.shade.get((Object)r);
    }
}

