/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.sources;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import martin.tempest.sources.TSDRSource;

public class TSDRExtIOSource
extends TSDRSource {
    public TSDRExtIOSource() {
        super("ExtIO source", "TSDRPlugin_ExtIO", false);
    }

    private ArrayList<File> findExtIOpluginsInFolder(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                String string = file2.getName().toLowerCase();
                if (!string.startsWith("extio_") || !string.endsWith(".dll")) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private void makeDeviceSelectionDialog(Container container, final ArrayList<File> arrayList) {
        final JComboBox<String> jComboBox = new JComboBox<String>();
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = arrayList.get(i).getName();
        }
        container.add(jComboBox);
        jComboBox.setBounds(12, 12, 159, 22);
        jComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        final JButton jButton = new JButton("Choose");
        container.add(jButton);
        jButton.setBounds(12, 76, 84, 24);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        jButton.setEnabled(false);
                        TSDRExtIOSource.this.setParams(((File)arrayList.get(jComboBox.getSelectedIndex())).getAbsolutePath());
                        jButton.setEnabled(true);
                    }
                }.start();
            }
        });
    }

    private void makeFileSelectionDialog(final Container container) {
        final JFileChooser jFileChooser = new JFileChooser();
        if (jFileChooser.showOpenDialog(container) == 0) {
            this.setParams(jFileChooser.getSelectedFile().getAbsolutePath());
        }
        final JButton jButton = new JButton("Choose ExtIO dll file");
        container.add(jButton);
        jButton.setBounds(12, 12, 200, 24);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        jButton.setEnabled(false);
                        if (jFileChooser.showOpenDialog(container) == 0) {
                            TSDRExtIOSource.this.setParams(jFileChooser.getSelectedFile().getAbsolutePath());
                        }
                        jButton.setEnabled(true);
                    }
                }.start();
            }
        });
    }

    @Override
    public boolean populateGUI(Container container, String string, TSDRSource.ActionListenerRegistrator actionListenerRegistrator) {
        String[] stringArray = System.getProperty("java.library.path").split(File.pathSeparator);
        for (String string2 : stringArray) {
            ArrayList<File> arrayList = this.findExtIOpluginsInFolder(new File(string2));
            if (arrayList.size() == 1) {
                this.setParams(arrayList.get(0).getAbsolutePath());
                return false;
            }
            if (arrayList.size() <= 1) continue;
            this.makeDeviceSelectionDialog(container, arrayList);
            return false;
        }
        ArrayList<File> arrayList = this.findExtIOpluginsInFolder(new File("."));
        if (arrayList.size() == 1) {
            this.setParams(((File)arrayList.get(0)).getAbsolutePath());
            return false;
        }
        if (arrayList.size() > 1) {
            this.makeDeviceSelectionDialog(container, arrayList);
            return false;
        }
        this.makeFileSelectionDialog(container);
        return false;
    }
}

