/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.core;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import martin.tempest.core.exceptions.TSDRAlreadyRunningException;
import martin.tempest.core.exceptions.TSDRException;
import martin.tempest.core.exceptions.TSDRLibraryNotCompatible;
import martin.tempest.sources.TSDRSource;

public class TSDRLibrary {
    private static final ArrayList<String> files_to_delete_on_shutdown = new ArrayList();
    private BufferedImage bimage;
    private volatile int[] pixels;
    private volatile boolean nativerunning = false;
    private final Object float_array_locker = new Object();
    private int float_array_locker_count = 0;
    private double[] double_array;
    private static TSDRLibraryNotCompatible m_e = null;
    private final List<FrameReadyCallback> callbacks = new ArrayList<FrameReadyCallback>();
    private final List<IncomingValueCallback> value_callbacks = new ArrayList<IncomingValueCallback>();
    private final Thread unloaderhook = new Thread(){

        @Override
        public void run() {
            try {
                TSDRLibrary.this.unloadPlugin();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                TSDRLibrary.this.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                TSDRLibrary.this.free();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (String string : files_to_delete_on_shutdown) {
                try {
                    File file = new File(string);
                    file.delete();
                }
                catch (Throwable throwable) {}
            }
        }
    };

    public static final String getNativeLibraryFullName(String string) throws TSDRLibraryNotCompatible {
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = null;
        String string4 = "";
        if (string2.contains("win")) {
            string3 = ".dll";
        } else if (string2.contains("nix") || string2.contains("nux") || string2.contains("aix")) {
            string3 = ".so";
            string4 = "lib";
        } else if (string2.contains("mac")) {
            string3 = ".so";
        }
        if (string3 == null) {
            throw new TSDRLibraryNotCompatible("Your OS or CPU is not yet supported, sorry.");
        }
        return string4 + string + string3;
    }

    public static final File extractLibrary(String string) throws TSDRLibraryNotCompatible {
        File file;
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch").toLowerCase();
        String string4 = null;
        String string5 = null;
        String string6 = TSDRLibrary.getNativeLibraryFullName(string);
        if (string2.contains("win")) {
            string4 = "WINDOWS";
        } else if (string2.contains("nix") || string2.contains("nux") || string2.contains("aix")) {
            string4 = "LINUX";
        } else if (string2.contains("mac")) {
            string4 = "MAC";
        }
        string5 = string3.contains("arm") ? "ARM" : (string3.contains("64") ? "X64" : "X86");
        if (string4 == null || string5 == null) {
            throw new TSDRLibraryNotCompatible("Your OS or CPU is not yet supported, sorry.");
        }
        String string7 = "lib/" + string4 + "/" + string5 + "/" + string6;
        InputStream inputStream = TSDRLibrary.class.getClassLoader().getResourceAsStream(string7);
        if (inputStream == null) {
            try {
                inputStream = new FileInputStream(string7);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (inputStream == null) {
            throw new TSDRLibraryNotCompatible("The library has not been compiled for your OS/Architecture yet (" + string4 + "/" + string5 + ").");
        }
        try {
            byte[] byArray = new byte[inputStream.available()];
            int n = -1;
            file = new File(System.getProperty("java.io.tmpdir"), string6);
            String string8 = file.getAbsolutePath();
            if (file.exists() && files_to_delete_on_shutdown.contains(string8)) {
                return file;
            }
            if (file.exists()) {
                try {
                    file.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            while ((n = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            inputStream.close();
            if (!file.exists()) {
                throw new TSDRLibraryNotCompatible("Cannot extract library files to temporary directory.");
            }
            if (!files_to_delete_on_shutdown.contains(string8)) {
                files_to_delete_on_shutdown.add(string8);
            }
        }
        catch (IOException iOException) {
            throw new TSDRLibraryNotCompatible(iOException);
        }
        return file;
    }

    private static final void loadLibrary(String string) throws TSDRLibraryNotCompatible {
        try {
            System.loadLibrary(string);
        }
        catch (Throwable throwable) {
            File file = TSDRLibrary.extractLibrary(string);
            System.load(file.getAbsolutePath());
            file.delete();
        }
    }

    public TSDRLibrary() throws TSDRException {
        if (m_e != null) {
            throw m_e;
        }
        this.init();
    }

    private native void init();

    public native void setBaseFreq(long var1) throws TSDRException;

    private native void loadPlugin(String var1, String var2) throws TSDRException;

    private native void nativeStart() throws TSDRException;

    public native void stop() throws TSDRException;

    public native void unloadPlugin() throws TSDRException;

    public native void setGain(float var1) throws TSDRException;

    public native boolean isRunning();

    public native void setInvertedColors(boolean var1);

    public native void sync(int var1, SYNC_DIRECTION var2);

    public native void setParam(PARAM var1, long var2) throws TSDRException;

    public native void setParamDouble(PARAM_DOUBLE var1, double var2) throws TSDRException;

    public native void setResolution(int var1, double var2) throws TSDRException;

    public native void setMotionBlur(float var1) throws TSDRException;

    public native void free();

    public void loadPlugin(TSDRSource tSDRSource) throws TSDRException {
        this.loadPlugin(tSDRSource.getAbsolutePathToLibrary(), tSDRSource.getParams());
    }

    public void startAsync(int n, double d) throws TSDRException {
        if (this.nativerunning) {
            throw new TSDRAlreadyRunningException("");
        }
        this.setResolution(n, d);
        new Thread(){

            @Override
            public void run() {
                TSDRLibrary.this.nativerunning = true;
                try {
                    Runtime.getRuntime().removeShutdownHook(TSDRLibrary.this.unloaderhook);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Runtime.getRuntime().addShutdownHook(TSDRLibrary.this.unloaderhook);
                try {
                    TSDRLibrary.this.nativeStart();
                }
                catch (TSDRException tSDRException) {
                    for (FrameReadyCallback frameReadyCallback : TSDRLibrary.this.callbacks) {
                        frameReadyCallback.onException(TSDRLibrary.this, tSDRException);
                    }
                }
                for (Object object : TSDRLibrary.this.callbacks) {
                    object.onStopped(TSDRLibrary.this);
                }
                TSDRLibrary.this.nativerunning = false;
            }
        }.start();
    }

    protected void finalize() throws Throwable {
        try {
            Runtime.getRuntime().removeShutdownHook(this.unloaderhook);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.unloaderhook.run();
        super.finalize();
    }

    public boolean registerFrameReadyCallback(FrameReadyCallback frameReadyCallback) {
        if (this.callbacks.contains(frameReadyCallback)) {
            return false;
        }
        return this.callbacks.add(frameReadyCallback);
    }

    public boolean unregisterFrameReadyCallback(FrameReadyCallback frameReadyCallback) {
        return this.callbacks.remove(frameReadyCallback);
    }

    public boolean registerValueChangedCallback(IncomingValueCallback incomingValueCallback) {
        if (this.value_callbacks.contains(incomingValueCallback)) {
            return false;
        }
        return this.value_callbacks.add(incomingValueCallback);
    }

    public boolean unregisterValueChangedCallback(IncomingValueCallback incomingValueCallback) {
        return this.callbacks.remove(incomingValueCallback);
    }

    private final void fixSize(int n, int n2) {
        if (this.bimage == null || this.bimage.getWidth() != n || this.bimage.getHeight() != n2) {
            try {
                this.bimage = new BufferedImage(n, n2, 1);
                this.pixels = ((DataBufferInt)this.bimage.getRaster().getDataBuffer()).getData();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.err.flush();
                System.out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onIncomingArray(int n) {
        Object object = this.float_array_locker;
        synchronized (object) {
            if (this.float_array_locker_count > 0) {
                try {
                    this.float_array_locker.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.float_array_locker_count;
        }
        if (this.double_array == null || this.double_array.length < n) {
            this.double_array = new double[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onIncomingArrayNotify(int n, int n2, int n3, long l) {
        IncomingValueCallback.PLOT_ID[] pLOT_IDArray = IncomingValueCallback.PLOT_ID.values();
        if (n < 0 || n >= pLOT_IDArray.length) {
            System.err.println("Warning: Received unrecognized callback plot id " + n + " from JNI!");
            return;
        }
        IncomingValueCallback.PLOT_ID pLOT_ID = pLOT_IDArray[n];
        for (IncomingValueCallback incomingValueCallback : this.value_callbacks) {
            incomingValueCallback.onIncommingPlot(pLOT_ID, n2, this.double_array, n3, l);
        }
        Object object = this.float_array_locker;
        synchronized (object) {
            --this.float_array_locker_count;
            this.float_array_locker.notify();
        }
    }

    private final void notifyCallbacks() {
        try {
            for (FrameReadyCallback frameReadyCallback : this.callbacks) {
                frameReadyCallback.onFrameReady(this, this.bimage);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.flush();
            System.out.flush();
        }
    }

    private void onValueChanged(int n, double d, double d2) {
        IncomingValueCallback.VALUE_ID[] vALUE_IDArray = IncomingValueCallback.VALUE_ID.values();
        if (n < 0 || n >= vALUE_IDArray.length) {
            System.err.println("Warning: Received unrecognized callback value id " + n + " with arg0=" + d + " and arg1=" + d2 + " from JNI!");
            return;
        }
        IncomingValueCallback.VALUE_ID vALUE_ID = vALUE_IDArray[n];
        for (IncomingValueCallback incomingValueCallback : this.value_callbacks) {
            incomingValueCallback.onValueChanged(vALUE_ID, d, d2);
        }
    }

    static {
        try {
            TSDRLibrary.loadLibrary("TSDRLibraryNDK");
        }
        catch (TSDRLibraryNotCompatible tSDRLibraryNotCompatible) {
            m_e = tSDRLibraryNotCompatible;
        }
    }

    public static interface IncomingValueCallback {
        public void onValueChanged(VALUE_ID var1, double var2, double var4);

        public void onIncommingPlot(PLOT_ID var1, int var2, double[] var3, int var4, long var5);

        public static enum PLOT_ID {
            FRAME,
            LINE;

        }

        public static enum VALUE_ID {
            PLL_FRAMERATE,
            AUTOCORRECT_RESET,
            FRAMES_COUNT,
            AUTOGAIN,
            SNR,
            AUTOCORRECT_DUMPED;

        }
    }

    public static interface FrameReadyCallback {
        public void onFrameReady(TSDRLibrary var1, BufferedImage var2);

        public void onException(TSDRLibrary var1, Exception var2);

        public void onStopped(TSDRLibrary var1);
    }

    public static enum PARAM_DOUBLE {

    }

    public static enum PARAM {
        AUTOSHIFT,
        PLLFRAMERATE,
        AUTOCORR_PLOTS_RESET,
        AUTOCORR_PLOTS_OFF,
        SUPERRESOLUTION,
        NEAREST_NEIGHBOUR_RESAMPLING,
        LOW_PASS_BEFORE_SYNC,
        AUTOGAIN_AFTER_PROCESSING,
        AUTOCORR_DUMP;

    }

    public static enum SYNC_DIRECTION {
        ANY,
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

