// Code generated by github.com/Khan/genqlient, DO NOT EDIT.

package test

import (
	"encoding/json"
	"fmt"

	"github.com/Khan/genqlient/graphql"
	"github.com/Khan/genqlient/internal/testutil"
)

// ComplexNamedFragmentsResponse is returned by ComplexNamedFragments on success.
type ComplexNamedFragmentsResponse struct {
	QueryFragment `json:"-"`
}

// GetRandomItem returns ComplexNamedFragmentsResponse.RandomItem, and is useful for accessing the field via an interface.
func (v *ComplexNamedFragmentsResponse) GetRandomItem() InnerQueryFragmentRandomItemContent {
	return v.QueryFragment.InnerQueryFragment.RandomItem
}

// GetRandomLeaf returns ComplexNamedFragmentsResponse.RandomLeaf, and is useful for accessing the field via an interface.
func (v *ComplexNamedFragmentsResponse) GetRandomLeaf() InnerQueryFragmentRandomLeafLeafContent {
	return v.QueryFragment.InnerQueryFragment.RandomLeaf
}

// GetOtherLeaf returns ComplexNamedFragmentsResponse.OtherLeaf, and is useful for accessing the field via an interface.
func (v *ComplexNamedFragmentsResponse) GetOtherLeaf() InnerQueryFragmentOtherLeafLeafContent {
	return v.QueryFragment.InnerQueryFragment.OtherLeaf
}

func (v *ComplexNamedFragmentsResponse) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*ComplexNamedFragmentsResponse
		graphql.NoUnmarshalJSON
	}
	firstPass.ComplexNamedFragmentsResponse = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.QueryFragment)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalComplexNamedFragmentsResponse struct {
	RandomItem json.RawMessage `json:"randomItem"`

	RandomLeaf json.RawMessage `json:"randomLeaf"`

	OtherLeaf json.RawMessage `json:"otherLeaf"`
}

func (v *ComplexNamedFragmentsResponse) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *ComplexNamedFragmentsResponse) __premarshalJSON() (*__premarshalComplexNamedFragmentsResponse, error) {
	var retval __premarshalComplexNamedFragmentsResponse

	{

		dst := &retval.RandomItem
		src := v.QueryFragment.InnerQueryFragment.RandomItem
		var err error
		*dst, err = __marshalInnerQueryFragmentRandomItemContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal ComplexNamedFragmentsResponse.QueryFragment.InnerQueryFragment.RandomItem: %w", err)
		}
	}
	{

		dst := &retval.RandomLeaf
		src := v.QueryFragment.InnerQueryFragment.RandomLeaf
		var err error
		*dst, err = __marshalInnerQueryFragmentRandomLeafLeafContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal ComplexNamedFragmentsResponse.QueryFragment.InnerQueryFragment.RandomLeaf: %w", err)
		}
	}
	{

		dst := &retval.OtherLeaf
		src := v.QueryFragment.InnerQueryFragment.OtherLeaf
		var err error
		*dst, err = __marshalInnerQueryFragmentOtherLeafLeafContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal ComplexNamedFragmentsResponse.QueryFragment.InnerQueryFragment.OtherLeaf: %w", err)
		}
	}
	return &retval, nil
}

// ContentFields includes the GraphQL fields of Content requested by the fragment ContentFields.
// The GraphQL type's documentation follows.
//
// Content is implemented by various types like Article, Video, and Topic.
//
// ContentFields is implemented by the following types:
// ContentFieldsArticle
// ContentFieldsVideo
// ContentFieldsTopic
type ContentFields interface {
	implementsGraphQLInterfaceContentFields()
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
	// GetUrl returns the interface-field "url" from its implementation.
	GetUrl() string
}

func (v *ContentFieldsArticle) implementsGraphQLInterfaceContentFields() {}
func (v *ContentFieldsVideo) implementsGraphQLInterfaceContentFields()   {}
func (v *ContentFieldsTopic) implementsGraphQLInterfaceContentFields()   {}

func __unmarshalContentFields(b []byte, v *ContentFields) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Article":
		*v = new(ContentFieldsArticle)
		return json.Unmarshal(b, *v)
	case "Video":
		*v = new(ContentFieldsVideo)
		return json.Unmarshal(b, *v)
	case "Topic":
		*v = new(ContentFieldsTopic)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Content.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for ContentFields: "%v"`, tn.TypeName)
	}
}

func __marshalContentFields(v *ContentFields) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *ContentFieldsArticle:
		typename = "Article"

		result := struct {
			TypeName string `json:"__typename"`
			*ContentFieldsArticle
		}{typename, v}
		return json.Marshal(result)
	case *ContentFieldsVideo:
		typename = "Video"

		result := struct {
			TypeName string `json:"__typename"`
			*ContentFieldsVideo
		}{typename, v}
		return json.Marshal(result)
	case *ContentFieldsTopic:
		typename = "Topic"

		result := struct {
			TypeName string `json:"__typename"`
			*ContentFieldsTopic
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for ContentFields: "%T"`, v)
	}
}

// ContentFields includes the GraphQL fields of Article requested by the fragment ContentFields.
// The GraphQL type's documentation follows.
//
// Content is implemented by various types like Article, Video, and Topic.
type ContentFieldsArticle struct {
	Name string `json:"name"`
	Url  string `json:"url"`
}

// GetName returns ContentFieldsArticle.Name, and is useful for accessing the field via an interface.
func (v *ContentFieldsArticle) GetName() string { return v.Name }

// GetUrl returns ContentFieldsArticle.Url, and is useful for accessing the field via an interface.
func (v *ContentFieldsArticle) GetUrl() string { return v.Url }

// ContentFields includes the GraphQL fields of Topic requested by the fragment ContentFields.
// The GraphQL type's documentation follows.
//
// Content is implemented by various types like Article, Video, and Topic.
type ContentFieldsTopic struct {
	Name string `json:"name"`
	Url  string `json:"url"`
}

// GetName returns ContentFieldsTopic.Name, and is useful for accessing the field via an interface.
func (v *ContentFieldsTopic) GetName() string { return v.Name }

// GetUrl returns ContentFieldsTopic.Url, and is useful for accessing the field via an interface.
func (v *ContentFieldsTopic) GetUrl() string { return v.Url }

// ContentFields includes the GraphQL fields of Video requested by the fragment ContentFields.
// The GraphQL type's documentation follows.
//
// Content is implemented by various types like Article, Video, and Topic.
type ContentFieldsVideo struct {
	Name string `json:"name"`
	Url  string `json:"url"`
}

// GetName returns ContentFieldsVideo.Name, and is useful for accessing the field via an interface.
func (v *ContentFieldsVideo) GetName() string { return v.Name }

// GetUrl returns ContentFieldsVideo.Url, and is useful for accessing the field via an interface.
func (v *ContentFieldsVideo) GetUrl() string { return v.Url }

// InnerQueryFragment includes the GraphQL fields of Query requested by the fragment InnerQueryFragment.
// The GraphQL type's documentation follows.
//
// Query's description is probably ignored by almost all callers.
type InnerQueryFragment struct {
	RandomItem InnerQueryFragmentRandomItemContent     `json:"-"`
	RandomLeaf InnerQueryFragmentRandomLeafLeafContent `json:"-"`
	OtherLeaf  InnerQueryFragmentOtherLeafLeafContent  `json:"-"`
}

// GetRandomItem returns InnerQueryFragment.RandomItem, and is useful for accessing the field via an interface.
func (v *InnerQueryFragment) GetRandomItem() InnerQueryFragmentRandomItemContent { return v.RandomItem }

// GetRandomLeaf returns InnerQueryFragment.RandomLeaf, and is useful for accessing the field via an interface.
func (v *InnerQueryFragment) GetRandomLeaf() InnerQueryFragmentRandomLeafLeafContent {
	return v.RandomLeaf
}

// GetOtherLeaf returns InnerQueryFragment.OtherLeaf, and is useful for accessing the field via an interface.
func (v *InnerQueryFragment) GetOtherLeaf() InnerQueryFragmentOtherLeafLeafContent {
	return v.OtherLeaf
}

func (v *InnerQueryFragment) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragment
		RandomItem json.RawMessage `json:"randomItem"`
		RandomLeaf json.RawMessage `json:"randomLeaf"`
		OtherLeaf  json.RawMessage `json:"otherLeaf"`
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragment = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.RandomItem
		src := firstPass.RandomItem
		if len(src) != 0 && string(src) != "null" {
			err = __unmarshalInnerQueryFragmentRandomItemContent(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal InnerQueryFragment.RandomItem: %w", err)
			}
		}
	}

	{
		dst := &v.RandomLeaf
		src := firstPass.RandomLeaf
		if len(src) != 0 && string(src) != "null" {
			err = __unmarshalInnerQueryFragmentRandomLeafLeafContent(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal InnerQueryFragment.RandomLeaf: %w", err)
			}
		}
	}

	{
		dst := &v.OtherLeaf
		src := firstPass.OtherLeaf
		if len(src) != 0 && string(src) != "null" {
			err = __unmarshalInnerQueryFragmentOtherLeafLeafContent(
				src, dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal InnerQueryFragment.OtherLeaf: %w", err)
			}
		}
	}
	return nil
}

type __premarshalInnerQueryFragment struct {
	RandomItem json.RawMessage `json:"randomItem"`

	RandomLeaf json.RawMessage `json:"randomLeaf"`

	OtherLeaf json.RawMessage `json:"otherLeaf"`
}

func (v *InnerQueryFragment) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragment) __premarshalJSON() (*__premarshalInnerQueryFragment, error) {
	var retval __premarshalInnerQueryFragment

	{

		dst := &retval.RandomItem
		src := v.RandomItem
		var err error
		*dst, err = __marshalInnerQueryFragmentRandomItemContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal InnerQueryFragment.RandomItem: %w", err)
		}
	}
	{

		dst := &retval.RandomLeaf
		src := v.RandomLeaf
		var err error
		*dst, err = __marshalInnerQueryFragmentRandomLeafLeafContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal InnerQueryFragment.RandomLeaf: %w", err)
		}
	}
	{

		dst := &retval.OtherLeaf
		src := v.OtherLeaf
		var err error
		*dst, err = __marshalInnerQueryFragmentOtherLeafLeafContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal InnerQueryFragment.OtherLeaf: %w", err)
		}
	}
	return &retval, nil
}

// InnerQueryFragmentOtherLeafArticle includes the requested fields of the GraphQL type Article.
type InnerQueryFragmentOtherLeafArticle struct {
	Typename             string `json:"__typename"`
	ContentFieldsArticle `json:"-"`
}

// GetTypename returns InnerQueryFragmentOtherLeafArticle.Typename, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafArticle) GetTypename() string { return v.Typename }

// GetName returns InnerQueryFragmentOtherLeafArticle.Name, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafArticle) GetName() string { return v.ContentFieldsArticle.Name }

// GetUrl returns InnerQueryFragmentOtherLeafArticle.Url, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafArticle) GetUrl() string { return v.ContentFieldsArticle.Url }

func (v *InnerQueryFragmentOtherLeafArticle) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragmentOtherLeafArticle
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragmentOtherLeafArticle = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.ContentFieldsArticle)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalInnerQueryFragmentOtherLeafArticle struct {
	Typename string `json:"__typename"`

	Name string `json:"name"`

	Url string `json:"url"`
}

func (v *InnerQueryFragmentOtherLeafArticle) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragmentOtherLeafArticle) __premarshalJSON() (*__premarshalInnerQueryFragmentOtherLeafArticle, error) {
	var retval __premarshalInnerQueryFragmentOtherLeafArticle

	retval.Typename = v.Typename
	retval.Name = v.ContentFieldsArticle.Name
	retval.Url = v.ContentFieldsArticle.Url
	return &retval, nil
}

// InnerQueryFragmentOtherLeafLeafContent includes the requested fields of the GraphQL interface LeafContent.
//
// InnerQueryFragmentOtherLeafLeafContent is implemented by the following types:
// InnerQueryFragmentOtherLeafArticle
// InnerQueryFragmentOtherLeafVideo
// The GraphQL type's documentation follows.
//
// LeafContent represents content items that can't have child-nodes.
type InnerQueryFragmentOtherLeafLeafContent interface {
	implementsGraphQLInterfaceInnerQueryFragmentOtherLeafLeafContent()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
}

func (v *InnerQueryFragmentOtherLeafArticle) implementsGraphQLInterfaceInnerQueryFragmentOtherLeafLeafContent() {
}
func (v *InnerQueryFragmentOtherLeafVideo) implementsGraphQLInterfaceInnerQueryFragmentOtherLeafLeafContent() {
}

func __unmarshalInnerQueryFragmentOtherLeafLeafContent(b []byte, v *InnerQueryFragmentOtherLeafLeafContent) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Article":
		*v = new(InnerQueryFragmentOtherLeafArticle)
		return json.Unmarshal(b, *v)
	case "Video":
		*v = new(InnerQueryFragmentOtherLeafVideo)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing LeafContent.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for InnerQueryFragmentOtherLeafLeafContent: "%v"`, tn.TypeName)
	}
}

func __marshalInnerQueryFragmentOtherLeafLeafContent(v *InnerQueryFragmentOtherLeafLeafContent) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *InnerQueryFragmentOtherLeafArticle:
		typename = "Article"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalInnerQueryFragmentOtherLeafArticle
		}{typename, premarshaled}
		return json.Marshal(result)
	case *InnerQueryFragmentOtherLeafVideo:
		typename = "Video"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalInnerQueryFragmentOtherLeafVideo
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for InnerQueryFragmentOtherLeafLeafContent: "%T"`, v)
	}
}

// InnerQueryFragmentOtherLeafVideo includes the requested fields of the GraphQL type Video.
type InnerQueryFragmentOtherLeafVideo struct {
	Typename           string `json:"__typename"`
	MoreVideoFields    `json:"-"`
	ContentFieldsVideo `json:"-"`
}

// GetTypename returns InnerQueryFragmentOtherLeafVideo.Typename, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafVideo) GetTypename() string { return v.Typename }

// GetId returns InnerQueryFragmentOtherLeafVideo.Id, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafVideo) GetId() *testutil.ID { return v.MoreVideoFields.Id }

// GetParent returns InnerQueryFragmentOtherLeafVideo.Parent, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafVideo) GetParent() *MoreVideoFieldsParentTopic {
	return v.MoreVideoFields.Parent
}

// GetName returns InnerQueryFragmentOtherLeafVideo.Name, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafVideo) GetName() string { return v.ContentFieldsVideo.Name }

// GetUrl returns InnerQueryFragmentOtherLeafVideo.Url, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentOtherLeafVideo) GetUrl() string { return v.ContentFieldsVideo.Url }

func (v *InnerQueryFragmentOtherLeafVideo) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragmentOtherLeafVideo
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragmentOtherLeafVideo = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.MoreVideoFields)
	if err != nil {
		return err
	}
	err = json.Unmarshal(
		b, &v.ContentFieldsVideo)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalInnerQueryFragmentOtherLeafVideo struct {
	Typename string `json:"__typename"`

	Id *testutil.ID `json:"id"`

	Parent *MoreVideoFieldsParentTopic `json:"parent"`

	Name string `json:"name"`

	Url string `json:"url"`
}

func (v *InnerQueryFragmentOtherLeafVideo) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragmentOtherLeafVideo) __premarshalJSON() (*__premarshalInnerQueryFragmentOtherLeafVideo, error) {
	var retval __premarshalInnerQueryFragmentOtherLeafVideo

	retval.Typename = v.Typename
	retval.Id = v.MoreVideoFields.Id
	retval.Parent = v.MoreVideoFields.Parent
	retval.Name = v.ContentFieldsVideo.Name
	retval.Url = v.ContentFieldsVideo.Url
	return &retval, nil
}

// InnerQueryFragmentRandomItemArticle includes the requested fields of the GraphQL type Article.
type InnerQueryFragmentRandomItemArticle struct {
	Typename string `json:"__typename"`
	// ID is the identifier of the content.
	Id                   testutil.ID `json:"id"`
	Name                 string      `json:"name"`
	ContentFieldsArticle `json:"-"`
}

// GetTypename returns InnerQueryFragmentRandomItemArticle.Typename, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemArticle) GetTypename() string { return v.Typename }

// GetId returns InnerQueryFragmentRandomItemArticle.Id, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemArticle) GetId() testutil.ID { return v.Id }

// GetName returns InnerQueryFragmentRandomItemArticle.Name, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemArticle) GetName() string { return v.Name }

// GetUrl returns InnerQueryFragmentRandomItemArticle.Url, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemArticle) GetUrl() string { return v.ContentFieldsArticle.Url }

func (v *InnerQueryFragmentRandomItemArticle) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragmentRandomItemArticle
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragmentRandomItemArticle = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.ContentFieldsArticle)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalInnerQueryFragmentRandomItemArticle struct {
	Typename string `json:"__typename"`

	Id testutil.ID `json:"id"`

	Name string `json:"name"`

	Url string `json:"url"`
}

func (v *InnerQueryFragmentRandomItemArticle) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragmentRandomItemArticle) __premarshalJSON() (*__premarshalInnerQueryFragmentRandomItemArticle, error) {
	var retval __premarshalInnerQueryFragmentRandomItemArticle

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.Name = v.Name
	retval.Url = v.ContentFieldsArticle.Url
	return &retval, nil
}

// InnerQueryFragmentRandomItemContent includes the requested fields of the GraphQL interface Content.
//
// InnerQueryFragmentRandomItemContent is implemented by the following types:
// InnerQueryFragmentRandomItemArticle
// InnerQueryFragmentRandomItemTopic
// InnerQueryFragmentRandomItemVideo
// The GraphQL type's documentation follows.
//
// Content is implemented by various types like Article, Video, and Topic.
type InnerQueryFragmentRandomItemContent interface {
	implementsGraphQLInterfaceInnerQueryFragmentRandomItemContent()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
	// GetId returns the interface-field "id" from its implementation.
	// The GraphQL interface field's documentation follows.
	//
	// ID is the identifier of the content.
	GetId() testutil.ID
	// GetName returns the interface-field "name" from its implementation.
	GetName() string
	ContentFields
}

func (v *InnerQueryFragmentRandomItemArticle) implementsGraphQLInterfaceInnerQueryFragmentRandomItemContent() {
}
func (v *InnerQueryFragmentRandomItemTopic) implementsGraphQLInterfaceInnerQueryFragmentRandomItemContent() {
}
func (v *InnerQueryFragmentRandomItemVideo) implementsGraphQLInterfaceInnerQueryFragmentRandomItemContent() {
}

func __unmarshalInnerQueryFragmentRandomItemContent(b []byte, v *InnerQueryFragmentRandomItemContent) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Article":
		*v = new(InnerQueryFragmentRandomItemArticle)
		return json.Unmarshal(b, *v)
	case "Topic":
		*v = new(InnerQueryFragmentRandomItemTopic)
		return json.Unmarshal(b, *v)
	case "Video":
		*v = new(InnerQueryFragmentRandomItemVideo)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Content.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for InnerQueryFragmentRandomItemContent: "%v"`, tn.TypeName)
	}
}

func __marshalInnerQueryFragmentRandomItemContent(v *InnerQueryFragmentRandomItemContent) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *InnerQueryFragmentRandomItemArticle:
		typename = "Article"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalInnerQueryFragmentRandomItemArticle
		}{typename, premarshaled}
		return json.Marshal(result)
	case *InnerQueryFragmentRandomItemTopic:
		typename = "Topic"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalInnerQueryFragmentRandomItemTopic
		}{typename, premarshaled}
		return json.Marshal(result)
	case *InnerQueryFragmentRandomItemVideo:
		typename = "Video"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalInnerQueryFragmentRandomItemVideo
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for InnerQueryFragmentRandomItemContent: "%T"`, v)
	}
}

// InnerQueryFragmentRandomItemTopic includes the requested fields of the GraphQL type Topic.
type InnerQueryFragmentRandomItemTopic struct {
	Typename string `json:"__typename"`
	// ID is the identifier of the content.
	Id                 testutil.ID `json:"id"`
	Name               string      `json:"name"`
	ContentFieldsTopic `json:"-"`
}

// GetTypename returns InnerQueryFragmentRandomItemTopic.Typename, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemTopic) GetTypename() string { return v.Typename }

// GetId returns InnerQueryFragmentRandomItemTopic.Id, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemTopic) GetId() testutil.ID { return v.Id }

// GetName returns InnerQueryFragmentRandomItemTopic.Name, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemTopic) GetName() string { return v.Name }

// GetUrl returns InnerQueryFragmentRandomItemTopic.Url, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemTopic) GetUrl() string { return v.ContentFieldsTopic.Url }

func (v *InnerQueryFragmentRandomItemTopic) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragmentRandomItemTopic
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragmentRandomItemTopic = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.ContentFieldsTopic)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalInnerQueryFragmentRandomItemTopic struct {
	Typename string `json:"__typename"`

	Id testutil.ID `json:"id"`

	Name string `json:"name"`

	Url string `json:"url"`
}

func (v *InnerQueryFragmentRandomItemTopic) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragmentRandomItemTopic) __premarshalJSON() (*__premarshalInnerQueryFragmentRandomItemTopic, error) {
	var retval __premarshalInnerQueryFragmentRandomItemTopic

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.Name = v.Name
	retval.Url = v.ContentFieldsTopic.Url
	return &retval, nil
}

// InnerQueryFragmentRandomItemVideo includes the requested fields of the GraphQL type Video.
type InnerQueryFragmentRandomItemVideo struct {
	Typename string `json:"__typename"`
	// ID is the identifier of the content.
	Id                 testutil.ID `json:"id"`
	Name               string      `json:"name"`
	VideoFields        `json:"-"`
	ContentFieldsVideo `json:"-"`
}

// GetTypename returns InnerQueryFragmentRandomItemVideo.Typename, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemVideo) GetTypename() string { return v.Typename }

// GetId returns InnerQueryFragmentRandomItemVideo.Id, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemVideo) GetId() testutil.ID { return v.Id }

// GetName returns InnerQueryFragmentRandomItemVideo.Name, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemVideo) GetName() string { return v.Name }

// GetUrl returns InnerQueryFragmentRandomItemVideo.Url, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemVideo) GetUrl() string { return v.VideoFields.Url }

// GetDuration returns InnerQueryFragmentRandomItemVideo.Duration, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemVideo) GetDuration() int { return v.VideoFields.Duration }

// GetThumbnail returns InnerQueryFragmentRandomItemVideo.Thumbnail, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomItemVideo) GetThumbnail() VideoFieldsThumbnail {
	return v.VideoFields.Thumbnail
}

func (v *InnerQueryFragmentRandomItemVideo) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragmentRandomItemVideo
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragmentRandomItemVideo = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.VideoFields)
	if err != nil {
		return err
	}
	err = json.Unmarshal(
		b, &v.ContentFieldsVideo)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalInnerQueryFragmentRandomItemVideo struct {
	Typename string `json:"__typename"`

	Id testutil.ID `json:"id"`

	Name string `json:"name"`

	Url string `json:"url"`

	Duration int `json:"duration"`

	Thumbnail VideoFieldsThumbnail `json:"thumbnail"`
}

func (v *InnerQueryFragmentRandomItemVideo) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragmentRandomItemVideo) __premarshalJSON() (*__premarshalInnerQueryFragmentRandomItemVideo, error) {
	var retval __premarshalInnerQueryFragmentRandomItemVideo

	retval.Typename = v.Typename
	retval.Id = v.Id
	retval.Name = v.Name
	retval.Url = v.VideoFields.Url
	retval.Duration = v.VideoFields.Duration
	retval.Thumbnail = v.VideoFields.Thumbnail
	return &retval, nil
}

// InnerQueryFragmentRandomLeafArticle includes the requested fields of the GraphQL type Article.
type InnerQueryFragmentRandomLeafArticle struct {
	Typename             string `json:"__typename"`
	ContentFieldsArticle `json:"-"`
}

// GetTypename returns InnerQueryFragmentRandomLeafArticle.Typename, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafArticle) GetTypename() string { return v.Typename }

// GetName returns InnerQueryFragmentRandomLeafArticle.Name, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafArticle) GetName() string { return v.ContentFieldsArticle.Name }

// GetUrl returns InnerQueryFragmentRandomLeafArticle.Url, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafArticle) GetUrl() string { return v.ContentFieldsArticle.Url }

func (v *InnerQueryFragmentRandomLeafArticle) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragmentRandomLeafArticle
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragmentRandomLeafArticle = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.ContentFieldsArticle)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalInnerQueryFragmentRandomLeafArticle struct {
	Typename string `json:"__typename"`

	Name string `json:"name"`

	Url string `json:"url"`
}

func (v *InnerQueryFragmentRandomLeafArticle) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragmentRandomLeafArticle) __premarshalJSON() (*__premarshalInnerQueryFragmentRandomLeafArticle, error) {
	var retval __premarshalInnerQueryFragmentRandomLeafArticle

	retval.Typename = v.Typename
	retval.Name = v.ContentFieldsArticle.Name
	retval.Url = v.ContentFieldsArticle.Url
	return &retval, nil
}

// InnerQueryFragmentRandomLeafLeafContent includes the requested fields of the GraphQL interface LeafContent.
//
// InnerQueryFragmentRandomLeafLeafContent is implemented by the following types:
// InnerQueryFragmentRandomLeafArticle
// InnerQueryFragmentRandomLeafVideo
// The GraphQL type's documentation follows.
//
// LeafContent represents content items that can't have child-nodes.
type InnerQueryFragmentRandomLeafLeafContent interface {
	implementsGraphQLInterfaceInnerQueryFragmentRandomLeafLeafContent()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() string
}

func (v *InnerQueryFragmentRandomLeafArticle) implementsGraphQLInterfaceInnerQueryFragmentRandomLeafLeafContent() {
}
func (v *InnerQueryFragmentRandomLeafVideo) implementsGraphQLInterfaceInnerQueryFragmentRandomLeafLeafContent() {
}

func __unmarshalInnerQueryFragmentRandomLeafLeafContent(b []byte, v *InnerQueryFragmentRandomLeafLeafContent) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Article":
		*v = new(InnerQueryFragmentRandomLeafArticle)
		return json.Unmarshal(b, *v)
	case "Video":
		*v = new(InnerQueryFragmentRandomLeafVideo)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing LeafContent.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for InnerQueryFragmentRandomLeafLeafContent: "%v"`, tn.TypeName)
	}
}

func __marshalInnerQueryFragmentRandomLeafLeafContent(v *InnerQueryFragmentRandomLeafLeafContent) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *InnerQueryFragmentRandomLeafArticle:
		typename = "Article"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalInnerQueryFragmentRandomLeafArticle
		}{typename, premarshaled}
		return json.Marshal(result)
	case *InnerQueryFragmentRandomLeafVideo:
		typename = "Video"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalInnerQueryFragmentRandomLeafVideo
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for InnerQueryFragmentRandomLeafLeafContent: "%T"`, v)
	}
}

// InnerQueryFragmentRandomLeafVideo includes the requested fields of the GraphQL type Video.
type InnerQueryFragmentRandomLeafVideo struct {
	Typename           string `json:"__typename"`
	VideoFields        `json:"-"`
	MoreVideoFields    `json:"-"`
	ContentFieldsVideo `json:"-"`
}

// GetTypename returns InnerQueryFragmentRandomLeafVideo.Typename, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafVideo) GetTypename() string { return v.Typename }

// GetId returns InnerQueryFragmentRandomLeafVideo.Id, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafVideo) GetId() testutil.ID { return v.VideoFields.Id }

// GetName returns InnerQueryFragmentRandomLeafVideo.Name, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafVideo) GetName() string { return v.VideoFields.Name }

// GetUrl returns InnerQueryFragmentRandomLeafVideo.Url, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafVideo) GetUrl() string { return v.VideoFields.Url }

// GetDuration returns InnerQueryFragmentRandomLeafVideo.Duration, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafVideo) GetDuration() int { return v.VideoFields.Duration }

// GetThumbnail returns InnerQueryFragmentRandomLeafVideo.Thumbnail, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafVideo) GetThumbnail() VideoFieldsThumbnail {
	return v.VideoFields.Thumbnail
}

// GetParent returns InnerQueryFragmentRandomLeafVideo.Parent, and is useful for accessing the field via an interface.
func (v *InnerQueryFragmentRandomLeafVideo) GetParent() *MoreVideoFieldsParentTopic {
	return v.MoreVideoFields.Parent
}

func (v *InnerQueryFragmentRandomLeafVideo) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*InnerQueryFragmentRandomLeafVideo
		graphql.NoUnmarshalJSON
	}
	firstPass.InnerQueryFragmentRandomLeafVideo = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.VideoFields)
	if err != nil {
		return err
	}
	err = json.Unmarshal(
		b, &v.MoreVideoFields)
	if err != nil {
		return err
	}
	err = json.Unmarshal(
		b, &v.ContentFieldsVideo)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalInnerQueryFragmentRandomLeafVideo struct {
	Typename string `json:"__typename"`

	Id testutil.ID `json:"id"`

	Name string `json:"name"`

	Url string `json:"url"`

	Duration int `json:"duration"`

	Thumbnail VideoFieldsThumbnail `json:"thumbnail"`

	Parent *MoreVideoFieldsParentTopic `json:"parent"`
}

func (v *InnerQueryFragmentRandomLeafVideo) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *InnerQueryFragmentRandomLeafVideo) __premarshalJSON() (*__premarshalInnerQueryFragmentRandomLeafVideo, error) {
	var retval __premarshalInnerQueryFragmentRandomLeafVideo

	retval.Typename = v.Typename
	retval.Id = v.VideoFields.Id
	retval.Name = v.VideoFields.Name
	retval.Url = v.VideoFields.Url
	retval.Duration = v.VideoFields.Duration
	retval.Thumbnail = v.VideoFields.Thumbnail
	retval.Parent = v.MoreVideoFields.Parent
	return &retval, nil
}

// MoreVideoFields includes the GraphQL fields of Video requested by the fragment MoreVideoFields.
type MoreVideoFields struct {
	// ID is documented in the Content interface.
	Id     *testutil.ID                `json:"id"`
	Parent *MoreVideoFieldsParentTopic `json:"parent"`
}

// GetId returns MoreVideoFields.Id, and is useful for accessing the field via an interface.
func (v *MoreVideoFields) GetId() *testutil.ID { return v.Id }

// GetParent returns MoreVideoFields.Parent, and is useful for accessing the field via an interface.
func (v *MoreVideoFields) GetParent() *MoreVideoFieldsParentTopic { return v.Parent }

// MoreVideoFieldsParentTopic includes the requested fields of the GraphQL type Topic.
type MoreVideoFieldsParentTopic struct {
	Name               *string `json:"name"`
	Url                *string `json:"url"`
	ContentFieldsTopic `json:"-"`
	Children           []MoreVideoFieldsParentTopicChildrenContent `json:"-"`
}

// GetName returns MoreVideoFieldsParentTopic.Name, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopic) GetName() *string { return v.Name }

// GetUrl returns MoreVideoFieldsParentTopic.Url, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopic) GetUrl() *string { return v.Url }

// GetChildren returns MoreVideoFieldsParentTopic.Children, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopic) GetChildren() []MoreVideoFieldsParentTopicChildrenContent {
	return v.Children
}

func (v *MoreVideoFieldsParentTopic) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*MoreVideoFieldsParentTopic
		Children []json.RawMessage `json:"children"`
		graphql.NoUnmarshalJSON
	}
	firstPass.MoreVideoFieldsParentTopic = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.ContentFieldsTopic)
	if err != nil {
		return err
	}

	{
		dst := &v.Children
		src := firstPass.Children
		*dst = make(
			[]MoreVideoFieldsParentTopicChildrenContent,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			if len(src) != 0 && string(src) != "null" {
				err = __unmarshalMoreVideoFieldsParentTopicChildrenContent(
					src, dst)
				if err != nil {
					return fmt.Errorf(
						"unable to unmarshal MoreVideoFieldsParentTopic.Children: %w", err)
				}
			}
		}
	}
	return nil
}

type __premarshalMoreVideoFieldsParentTopic struct {
	Name *string `json:"name"`

	Url *string `json:"url"`

	Children []json.RawMessage `json:"children"`
}

func (v *MoreVideoFieldsParentTopic) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *MoreVideoFieldsParentTopic) __premarshalJSON() (*__premarshalMoreVideoFieldsParentTopic, error) {
	var retval __premarshalMoreVideoFieldsParentTopic

	retval.Name = v.Name
	retval.Url = v.Url
	{

		dst := &retval.Children
		src := v.Children
		*dst = make(
			[]json.RawMessage,
			len(src))
		for i, src := range src {
			dst := &(*dst)[i]
			var err error
			*dst, err = __marshalMoreVideoFieldsParentTopicChildrenContent(
				&src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal MoreVideoFieldsParentTopic.Children: %w", err)
			}
		}
	}
	return &retval, nil
}

// MoreVideoFieldsParentTopicChildrenArticle includes the requested fields of the GraphQL type Article.
type MoreVideoFieldsParentTopicChildrenArticle struct {
	Typename *string `json:"__typename"`
}

// GetTypename returns MoreVideoFieldsParentTopicChildrenArticle.Typename, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenArticle) GetTypename() *string { return v.Typename }

// MoreVideoFieldsParentTopicChildrenContent includes the requested fields of the GraphQL interface Content.
//
// MoreVideoFieldsParentTopicChildrenContent is implemented by the following types:
// MoreVideoFieldsParentTopicChildrenArticle
// MoreVideoFieldsParentTopicChildrenTopic
// MoreVideoFieldsParentTopicChildrenVideo
// The GraphQL type's documentation follows.
//
// Content is implemented by various types like Article, Video, and Topic.
type MoreVideoFieldsParentTopicChildrenContent interface {
	implementsGraphQLInterfaceMoreVideoFieldsParentTopicChildrenContent()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() *string
}

func (v *MoreVideoFieldsParentTopicChildrenArticle) implementsGraphQLInterfaceMoreVideoFieldsParentTopicChildrenContent() {
}
func (v *MoreVideoFieldsParentTopicChildrenTopic) implementsGraphQLInterfaceMoreVideoFieldsParentTopicChildrenContent() {
}
func (v *MoreVideoFieldsParentTopicChildrenVideo) implementsGraphQLInterfaceMoreVideoFieldsParentTopicChildrenContent() {
}

func __unmarshalMoreVideoFieldsParentTopicChildrenContent(b []byte, v *MoreVideoFieldsParentTopicChildrenContent) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "Article":
		*v = new(MoreVideoFieldsParentTopicChildrenArticle)
		return json.Unmarshal(b, *v)
	case "Topic":
		*v = new(MoreVideoFieldsParentTopicChildrenTopic)
		return json.Unmarshal(b, *v)
	case "Video":
		*v = new(MoreVideoFieldsParentTopicChildrenVideo)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing Content.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for MoreVideoFieldsParentTopicChildrenContent: "%v"`, tn.TypeName)
	}
}

func __marshalMoreVideoFieldsParentTopicChildrenContent(v *MoreVideoFieldsParentTopicChildrenContent) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *MoreVideoFieldsParentTopicChildrenArticle:
		typename = "Article"

		result := struct {
			TypeName string `json:"__typename"`
			*MoreVideoFieldsParentTopicChildrenArticle
		}{typename, v}
		return json.Marshal(result)
	case *MoreVideoFieldsParentTopicChildrenTopic:
		typename = "Topic"

		result := struct {
			TypeName string `json:"__typename"`
			*MoreVideoFieldsParentTopicChildrenTopic
		}{typename, v}
		return json.Marshal(result)
	case *MoreVideoFieldsParentTopicChildrenVideo:
		typename = "Video"

		premarshaled, err := v.__premarshalJSON()
		if err != nil {
			return nil, err
		}
		result := struct {
			TypeName string `json:"__typename"`
			*__premarshalMoreVideoFieldsParentTopicChildrenVideo
		}{typename, premarshaled}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for MoreVideoFieldsParentTopicChildrenContent: "%T"`, v)
	}
}

// MoreVideoFieldsParentTopicChildrenTopic includes the requested fields of the GraphQL type Topic.
type MoreVideoFieldsParentTopicChildrenTopic struct {
	Typename *string `json:"__typename"`
}

// GetTypename returns MoreVideoFieldsParentTopicChildrenTopic.Typename, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenTopic) GetTypename() *string { return v.Typename }

// MoreVideoFieldsParentTopicChildrenVideo includes the requested fields of the GraphQL type Video.
type MoreVideoFieldsParentTopicChildrenVideo struct {
	Typename    *string `json:"__typename"`
	VideoFields `json:"-"`
}

// GetTypename returns MoreVideoFieldsParentTopicChildrenVideo.Typename, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenVideo) GetTypename() *string { return v.Typename }

// GetId returns MoreVideoFieldsParentTopicChildrenVideo.Id, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenVideo) GetId() testutil.ID { return v.VideoFields.Id }

// GetName returns MoreVideoFieldsParentTopicChildrenVideo.Name, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenVideo) GetName() string { return v.VideoFields.Name }

// GetUrl returns MoreVideoFieldsParentTopicChildrenVideo.Url, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenVideo) GetUrl() string { return v.VideoFields.Url }

// GetDuration returns MoreVideoFieldsParentTopicChildrenVideo.Duration, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenVideo) GetDuration() int { return v.VideoFields.Duration }

// GetThumbnail returns MoreVideoFieldsParentTopicChildrenVideo.Thumbnail, and is useful for accessing the field via an interface.
func (v *MoreVideoFieldsParentTopicChildrenVideo) GetThumbnail() VideoFieldsThumbnail {
	return v.VideoFields.Thumbnail
}

func (v *MoreVideoFieldsParentTopicChildrenVideo) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*MoreVideoFieldsParentTopicChildrenVideo
		graphql.NoUnmarshalJSON
	}
	firstPass.MoreVideoFieldsParentTopicChildrenVideo = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.VideoFields)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalMoreVideoFieldsParentTopicChildrenVideo struct {
	Typename *string `json:"__typename"`

	Id testutil.ID `json:"id"`

	Name string `json:"name"`

	Url string `json:"url"`

	Duration int `json:"duration"`

	Thumbnail VideoFieldsThumbnail `json:"thumbnail"`
}

func (v *MoreVideoFieldsParentTopicChildrenVideo) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *MoreVideoFieldsParentTopicChildrenVideo) __premarshalJSON() (*__premarshalMoreVideoFieldsParentTopicChildrenVideo, error) {
	var retval __premarshalMoreVideoFieldsParentTopicChildrenVideo

	retval.Typename = v.Typename
	retval.Id = v.VideoFields.Id
	retval.Name = v.VideoFields.Name
	retval.Url = v.VideoFields.Url
	retval.Duration = v.VideoFields.Duration
	retval.Thumbnail = v.VideoFields.Thumbnail
	return &retval, nil
}

// QueryFragment includes the GraphQL fields of Query requested by the fragment QueryFragment.
// The GraphQL type's documentation follows.
//
// Query's description is probably ignored by almost all callers.
type QueryFragment struct {
	InnerQueryFragment `json:"-"`
}

// GetRandomItem returns QueryFragment.RandomItem, and is useful for accessing the field via an interface.
func (v *QueryFragment) GetRandomItem() InnerQueryFragmentRandomItemContent {
	return v.InnerQueryFragment.RandomItem
}

// GetRandomLeaf returns QueryFragment.RandomLeaf, and is useful for accessing the field via an interface.
func (v *QueryFragment) GetRandomLeaf() InnerQueryFragmentRandomLeafLeafContent {
	return v.InnerQueryFragment.RandomLeaf
}

// GetOtherLeaf returns QueryFragment.OtherLeaf, and is useful for accessing the field via an interface.
func (v *QueryFragment) GetOtherLeaf() InnerQueryFragmentOtherLeafLeafContent {
	return v.InnerQueryFragment.OtherLeaf
}

func (v *QueryFragment) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*QueryFragment
		graphql.NoUnmarshalJSON
	}
	firstPass.QueryFragment = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.InnerQueryFragment)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalQueryFragment struct {
	RandomItem json.RawMessage `json:"randomItem"`

	RandomLeaf json.RawMessage `json:"randomLeaf"`

	OtherLeaf json.RawMessage `json:"otherLeaf"`
}

func (v *QueryFragment) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *QueryFragment) __premarshalJSON() (*__premarshalQueryFragment, error) {
	var retval __premarshalQueryFragment

	{

		dst := &retval.RandomItem
		src := v.InnerQueryFragment.RandomItem
		var err error
		*dst, err = __marshalInnerQueryFragmentRandomItemContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal QueryFragment.InnerQueryFragment.RandomItem: %w", err)
		}
	}
	{

		dst := &retval.RandomLeaf
		src := v.InnerQueryFragment.RandomLeaf
		var err error
		*dst, err = __marshalInnerQueryFragmentRandomLeafLeafContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal QueryFragment.InnerQueryFragment.RandomLeaf: %w", err)
		}
	}
	{

		dst := &retval.OtherLeaf
		src := v.InnerQueryFragment.OtherLeaf
		var err error
		*dst, err = __marshalInnerQueryFragmentOtherLeafLeafContent(
			&src)
		if err != nil {
			return nil, fmt.Errorf(
				"unable to marshal QueryFragment.InnerQueryFragment.OtherLeaf: %w", err)
		}
	}
	return &retval, nil
}

// VideoFields includes the GraphQL fields of Video requested by the fragment VideoFields.
type VideoFields struct {
	// ID is documented in the Content interface.
	Id                 testutil.ID          `json:"id"`
	Name               string               `json:"name"`
	Url                string               `json:"url"`
	Duration           int                  `json:"duration"`
	Thumbnail          VideoFieldsThumbnail `json:"thumbnail"`
	ContentFieldsVideo `json:"-"`
}

// GetId returns VideoFields.Id, and is useful for accessing the field via an interface.
func (v *VideoFields) GetId() testutil.ID { return v.Id }

// GetName returns VideoFields.Name, and is useful for accessing the field via an interface.
func (v *VideoFields) GetName() string { return v.Name }

// GetUrl returns VideoFields.Url, and is useful for accessing the field via an interface.
func (v *VideoFields) GetUrl() string { return v.Url }

// GetDuration returns VideoFields.Duration, and is useful for accessing the field via an interface.
func (v *VideoFields) GetDuration() int { return v.Duration }

// GetThumbnail returns VideoFields.Thumbnail, and is useful for accessing the field via an interface.
func (v *VideoFields) GetThumbnail() VideoFieldsThumbnail { return v.Thumbnail }

func (v *VideoFields) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*VideoFields
		graphql.NoUnmarshalJSON
	}
	firstPass.VideoFields = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	err = json.Unmarshal(
		b, &v.ContentFieldsVideo)
	if err != nil {
		return err
	}
	return nil
}

type __premarshalVideoFields struct {
	Id testutil.ID `json:"id"`

	Name string `json:"name"`

	Url string `json:"url"`

	Duration int `json:"duration"`

	Thumbnail VideoFieldsThumbnail `json:"thumbnail"`
}

func (v *VideoFields) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *VideoFields) __premarshalJSON() (*__premarshalVideoFields, error) {
	var retval __premarshalVideoFields

	retval.Id = v.Id
	retval.Name = v.Name
	retval.Url = v.Url
	retval.Duration = v.Duration
	retval.Thumbnail = v.Thumbnail
	return &retval, nil
}

// VideoFieldsThumbnail includes the requested fields of the GraphQL type Thumbnail.
type VideoFieldsThumbnail struct {
	Id testutil.ID `json:"id"`
}

// GetId returns VideoFieldsThumbnail.Id, and is useful for accessing the field via an interface.
func (v *VideoFieldsThumbnail) GetId() testutil.ID { return v.Id }

// The query or mutation executed by ComplexNamedFragments.
const ComplexNamedFragments_Operation = `
query ComplexNamedFragments {
	... on Query {
		... QueryFragment
	}
}
fragment QueryFragment on Query {
	... InnerQueryFragment
}
fragment InnerQueryFragment on Query {
	randomItem {
		__typename
		id
		name
		... VideoFields
		... ContentFields
	}
	randomLeaf {
		__typename
		... VideoFields
		... MoreVideoFields
		... ContentFields
	}
	otherLeaf: randomLeaf {
		__typename
		... on Video {
			... MoreVideoFields
			... ContentFields
		}
		... ContentFields
	}
}
fragment VideoFields on Video {
	id
	name
	url
	duration
	thumbnail {
		id
	}
	... ContentFields
}
fragment ContentFields on Content {
	name
	url
}
fragment MoreVideoFields on Video {
	id
	parent {
		name
		url
		... ContentFields
		children {
			__typename
			... VideoFields
		}
	}
}
`

func ComplexNamedFragments(
	client graphql.Client,
) (*ComplexNamedFragmentsResponse, error) {
	req := &graphql.Request{
		OpName: "ComplexNamedFragments",
		Query:  ComplexNamedFragments_Operation,
	}
	var err error

	var data ComplexNamedFragmentsResponse
	resp := &graphql.Response{Data: &data}

	err = client.MakeRequest(
		nil,
		req,
		resp,
	)

	return &data, err
}

