//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cHud.cpp
// Project: Shooting Star
// Author: Tuomas Peippo
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cHud.hpp"
#include "cDisplayManager.hpp"
#include "cTextureManager.hpp"
#include "cTextureFont.hpp"
#include "cWorld.hpp"
#include "cWeapon.hpp"
#include "cDisplayManager.hpp"
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================

//! Constructor
cHud::cHud (cPointer<cPlayer> &player1, cPointer<cPlayer> &player2):
mDisplayManager (cDisplayManager::GetInstance ()),
mTexManager (cTextureManager::GetInstance ()),
mWorld (cWorld::GetInstance ()),
mPlayer1 (player1),
mPlayer2 (player2)
{

};

//! Destructor
cHud::~cHud (void)
{

};

//! Return singleton
void
cHud::LoadTextures (void)
{
	mpFont = new cTextureFont("font_11x20.png", 11, 20);
	mHudP1 = mTexManager.LoadTexture ("hud_p1.png");
	mHudP2 = mTexManager.LoadTexture ("hud_p2.png");
	mWeaponLogos = mTexManager.LoadTexture ("weaponlogos.png");
}

//! Render
void
cHud::Render (void)
{
	int sHeight, sWidth;

	glPushMatrix ();

	sHeight = 600;
	sWidth = 800;
	
	glEnable (GL_TEXTURE_2D);
	if ( mPlayer2.IsValid () && mPlayer2->IsAlive () )
	{
		glPushMatrix ();
			glColor3f (1.0f, 1.0f, 1.0f);
				glTranslatef ( 0.0f, sHeight - 128.0f,  0.0f);
			glBindTexture (GL_TEXTURE_2D, mHudP2 );	
			glBegin (GL_QUADS);
				glTexCoord2f(0.0f, 0.0f); glVertex2f( 0.0f, 0.0f );
				glTexCoord2f(1.0f, 0.0f); glVertex2f( 256.0f, 0.0f );
				glTexCoord2f(1.0f, 1.0f); glVertex2f( 256.0f, 128.0f );
				glTexCoord2f(0.0f, 1.0f); glVertex2f( 0.0f, 128.0f );
			glEnd ();
			
			glColor3f (1.0f, 1.0f, 0.0f);
	
			// Health & armor
			glPushMatrix ();
				glTranslatef (32.0f, 48.0f, 0.0f);
				mpFont->Print ("%3i",mPlayer2->GetArmor());
				glTranslatef (61.0f, 0.0f, 0.0f);
				mpFont->Print ("%3i", mPlayer2->GetHealth ());
			glPopMatrix ();
	
			cWeapon *pWeapon = mPlayer2->GetCurrentWeapon ();
			if ( pWeapon != NULL )
			{
				// Ammo & clips
				glPushMatrix ();
					int ammo, clips;
					pWeapon->GetAmmo (ammo, clips);
					glTranslatef (143.0f, 92.0f, 0.0f);
					if ( pWeapon->GetState () == cWeapon::State_Ready )
						mpFont->Print ("%3i", ammo);
					else
						mpFont->Print ("%2i%%", int ((1.0f - pWeapon->GetReloadStatus ()) * 100.0f));
					glTranslatef (0.0f, 25.0f, 0.0f);
					mpFont->Print ("%3i", clips);
				glPopMatrix ();
					
				glColor3f (1.0f, 1.0f, 1.0f);
				glTranslatef (10.0f, 54.0f, 0.0f);
				RenderWeaponLogo (pWeapon->GetName ());
			}
			
		glPopMatrix ();
	}
	
	if ( mPlayer1->IsAlive () )
	{		
		glPushMatrix ();
			glColor3f (1.0f, 1.0f, 1.0f);
			glTranslatef ( sWidth-256.0f, sHeight - 128.0f,  0.0f);
			glBindTexture (GL_TEXTURE_2D, mHudP1 );
			glBegin (GL_QUADS);
				glTexCoord2f(0.0f, 0.0f); glVertex2f( 0.0f, 0.0f );
				glTexCoord2f(1.0f, 0.0f); glVertex2f( 256.0f, 0.0f );
				glTexCoord2f(1.0f, 1.0f); glVertex2f( 256.0f, 128.0f );
				glTexCoord2f(0.0f, 1.0f); glVertex2f( 0.0f, 128.0f );
			glEnd ();  
			
			glColor3f (1.0f, 1.0f, 0.0f);
	
			// Health & armor
			glPushMatrix ();
				glTranslatef (129.0f, 50.0f, 0.0f);
				mpFont->Print ("%3i",mPlayer1->GetArmor ()) ;
				glTranslatef (61.0f, 0.0f, 0.0f);
				mpFont->Print ("%3i", mPlayer1->GetHealth ());
			glPopMatrix ();
	
			cWeapon *pWeapon = mPlayer1->GetCurrentWeapon ();
			if ( pWeapon != NULL )
			{
				// Ammo & clips
				glPushMatrix ();
					int ammo, clips;
					pWeapon->GetAmmo (ammo, clips);
					glTranslatef (80.0f, 94.0f, 0.0f);
					if ( pWeapon->GetState () == cWeapon::State_Ready )
						mpFont->Print ("%-3i", ammo);
					else
						mpFont->Print ("%2i%%", int ((1.0f - pWeapon->GetReloadStatus ()) * 100.0f));
					glTranslatef (0.0f, 25.0f, 0.0f);
					mpFont->Print ("%-3i", clips);
				glPopMatrix ();
					
				glColor3f (1.0f, 1.0f, 1.0f);
				glTranslatef (118.0f, 54.0f, 0.0f);
				RenderWeaponLogo (pWeapon->GetName ());
			}
	
		glPopMatrix ();
	}

	glColor4f (1.0f, 1.0f, 1.0f, 1.0f);
		
	glPopMatrix ();
}

void 
cHud::RenderWeaponLogo (string name)
{
	// Render weapon logo
	float logoOffsetX = 0.0f;
	float logoOffsetY = 0.0f;

	if ( name == string ("Pistol") )
		logoOffsetY = 0.0f;
	else if ( name == string ("Shotgun") )
		logoOffsetY = 0.25f;
	else if ( name == string ("Flame thrower") )
		logoOffsetY = 0.50f;
	else if ( name == string ("Rocket launcher") )
		logoOffsetY = 0.75f;
	else if ( name == string ("Machine gun") )
		logoOffsetX = 0.50f;
	
	glBindTexture (GL_TEXTURE_2D, mWeaponLogos);
	glBegin (GL_QUADS);
		glTexCoord2f (logoOffsetX, logoOffsetY);
		glVertex2f (0.0f, 0.0f);
		glTexCoord2f (logoOffsetX, logoOffsetY + 0.25f);
		glVertex2f (0.0f, 64.0f);
		glTexCoord2f (logoOffsetX + 0.5f, logoOffsetY + 0.25f);	
		glVertex2f (128.0f, 64.0f);
		glTexCoord2f (logoOffsetX + 0.5f, logoOffsetY);			
		glVertex2f (128.0f, 0.0f);
	glEnd (); 		
}

//==============================================================================
// EOF
//==============================================================================
