[DO NOT MODIFY THIS FILE MANUALLY. It is generated by src/third_party/tools/gen_thirdpartyreadme.py]: #

# MongoDB Third Party Dependencies

MongoDB depends on third party libraries to implement some
functionality. This document describes which libraries are depended
upon, and how. It is maintained by and for humans, and so while it is a
best effort attempt to describe the server's dependencies, it is subject
to change as libraries are added or removed.

## Server Vendored Libraries

This is the list of third party libraries vendored into the server
codebase, and the upstream source where updates may be obtained. These
sources are periodically consulted, and the existence of new versions is
reflected in this list. A ticket is filed in Jira if a determination is
made to upgrade a vendored library.

Whenever a vendored library is included in released binary artifacts, is
not authored by MongoDB, and has a license which requires reproduction,
a notice will be included in
`THIRD-PARTY-NOTICES`.

| Name                                                 | License                           | Vendored Version                         | Emits persisted data | Distributed in Release Binaries |
| ---------------------------------------------------- | --------------------------------- | ---------------------------------------- | -------------------- | ------------------------------- |
| [Abseil Common Libraries (C++)]                      | Apache-2.0                        | 20211102.0                               |                      | ✗                               |
| [Asio C++ Library]                                   | BSL-1.0                           | 1.12.2                                   |                      | ✗                               |
| [benchmark]                                          | Apache-2.0                        | v1.5.2                                   |                      |                                 |
| [Boost C++ Libraries]                                | BSL-1.0                           | 1.79.0                                   |                      | ✗                               |
| [c-ares]                                             | MIT                               | 1.19.1                                   |                      |                                 |
| [Cyrus SASL]                                         | BSD-Attribution-HPND-disclaimer   | 2.1.28                                   |                      |                                 |
| [fmt]                                                | MIT                               | 7.1.3                                    |                      | ✗                               |
| [github.com/facebook/folly]                          | Apache-2.0                        | v2025.04.21.00                           |                      | ✗                               |
| [gperftools]                                         | BSD-3-Clause                      | 2.9.1                                    |                      | ✗                               |
| [gRPC (C++)]                                         | Apache-2.0                        | 1.46.6                                   |                      |                                 |
| [immer]                                              | BSL-1.0                           | 0.8.0                                    |                      | ✗                               |
| [Intel® Decimal Floating-Point Math Library]         | BSD-3-Clause                      | v2.0U1                                   |                      | ✗                               |
| [International Components for Unicode C/C++ (ICU4C)] | Unicode-3.0                       | 57.1                                     | ✗                    | ✗                               |
| [JSON Schema Store]                                  | Apache-2.0                        | 6847cfc3a17a04a7664474212db50c627e1e3408 |                      |                                 |
| [JSON-Schema-Test-Suite]                             | MIT                               | 728066f9c5c258ba3b1804a22a5b998f2ec77ec0 |                      |                                 |
| [libmongocrypt]                                      | Apache-2.0                        | e656245b7ebc742df210c8156b9aac41bdd5d113 | ✗                    | ✗                               |
| [librdkafka - The Apache Kafka C/C++ library]        | BSD-2-Clause                      | 2.0.2                                    |                      | ✗                               |
| [LibTomCrypt]                                        | Unlicense                         | 1.18.2                                   | ✗                    | ✗                               |
| [libunwind]                                          | MIT                               | v1.6.2                                   |                      | ✗                               |
| [linenoise]                                          | BSD-2-Clause                      | 6cdc775807e57b2c3fd64bd207814f8ee1fe35f3 |                      | ✗                               |
| [MongoDB C Driver]                                   | Apache-2.0                        | 1.27.6                                   | ✗                    | ✗                               |
| [Mozilla Firefox ESR]                                | MPL-2.0                           | 128.11.0esr                              |                      | ✗                               |
| [MurmurHash3]                                        | Public Domain                     | a6bd3ce7be8ad147ea820a7cf6229a975c0c96bb |                      | ✗                               |
| [nlohmann/json]                                      | MIT                               | 3.10.5                                   |                      |                                 |
| [PCRE2 - Perl-Compatible Regular Expressions]        | BSD-3-Clause WITH PCRE2-exception | 10.40                                    |                      | ✗                               |
| [Protobuf]                                           | BSD-3-Clause                      | v3.19.5                                  |                      | ✗                               |
| [pypi/asn1crypto]                                    | MIT                               | 1.5.1                                    |                      |                                 |
| [pypi/concurrencytest]                               | GPL-3.0-or-later                  | 0.1.2                                    |                      |                                 |
| [pypi/discover]                                      | BSD-3-Clause                      | 0.4.0                                    |                      |                                 |
| [pypi/extras]                                        | MIT                               | 0.0.3                                    |                      |                                 |
| [pypi/ocspbuilder]                                   | MIT                               | 0.10.2                                   |                      |                                 |
| [pypi/ocspresponder]                                 | Apache-2.0                        | 0.5.0                                    |                      |                                 |
| [pypi/oscrypto]                                      | MIT                               | 1.3.0                                    |                      |                                 |
| [pypi/python-subunit]                                | (Apache-2.0 OR BSD-3-Clause)      | 0.0.16                                   |                      |                                 |
| [pypi/testscenarios]                                 | BSD-3-Clause                      | 0.4                                      |                      |                                 |
| [pypi/testtools]                                     | MIT                               | 0.9.34                                   |                      |                                 |
| [re2]                                                | BSD-3-Clause                      | 2021-09-01                               |                      |                                 |
| [S2 Geometry Library]                                | Apache-2.0                        | c872048da5d1                             | ✗                    | ✗                               |
| [SafeInt]                                            | MIT                               | 3.0.26                                   |                      | ✗                               |
| [SCons - a Software Construction tool]               | MIT                               | 4.9.1                                    |                      |                                 |
| [snappy]                                             | BSD-3-Clause                      | 1.1.7                                    | ✗                    | ✗                               |
| [Snowball Stemming Algorithms (libstemmer)]          | BSD-3-Clause                      | 7b264ffa0f767c579d052fd8142558dc8264d795 | ✗                    | ✗                               |
| [timelib]                                            | MIT                               | 2022.10                                  |                      | ✗                               |
| [Unicode Character Database]                         | Unicode-DFS-2016                  | 8.0.0                                    | ✗                    | ✗                               |
| [valgrind.h]                                         | BSD-4-Clause                      | 3.17.0                                   |                      | ✗                               |
| [variant]                                            | BSL-1.0                           | v1.4.0                                   | unknown              | ✗                               |
| [WiredTiger]                                         | GPL-2.0-only OR GPL-3.0-only      | mongodb-7.0.22                           | ✗                    | ✗                               |
| [yaml-cpp]                                           | MIT                               | 0.6.3                                    |                      | ✗                               |
| [zlib]                                               | Zlib                              | 1.2.13                                   | ✗                    | ✗                               |
| [Zstandard (zstd)]                                   | BSD-3-Clause OR GPL-2.0-only      | 1.5.2                                    | ✗                    | ✗                               |

[Abseil Common Libraries (C++)]: https://github.com/abseil/abseil-cpp
[Asio C++ Library]: https://github.com/chriskohlhoff/asio
[Boost C++ Libraries]: http://www.boost.org/
[Cyrus SASL]: https://www.cyrusimap.org/sasl/
[Intel® Decimal Floating-Point Math Library]: https://software.intel.com/en-us/articles/intel-decimal-floating-point-math-library
[International Components for Unicode C/C++ (ICU4C)]: http://site.icu-project.org/download/
[JSON Schema Store]: https://www.schemastore.org/json/
[JSON-Schema-Test-Suite]: https://github.com/json-schema-org/JSON-Schema-Test-Suite
[LibTomCrypt]: https://github.com/libtom/libtomcrypt/releases
[MongoDB C Driver]: https://github.com/mongodb/mongo-c-driver
[Mozilla Firefox ESR]: https://www.mozilla.org/en-US/security/known-vulnerabilities/firefox-esr
[MurmurHash3]: https://github.com/aappleby/smhasher/blob/a6bd3ce/
[PCRE2 - Perl-Compatible Regular Expressions]: http://www.pcre.org/
[Protobuf]: https://github.com/protocolbuffers/protobuf
[S2 Geometry Library]: https://github.com/google/s2geometry
[SCons - a Software Construction tool]: https://github.com/SCons/scons
[SafeInt]: https://github.com/dcleblanc/SafeInt
[Snowball Stemming Algorithms (libstemmer)]: https://github.com/snowballstem/snowball
[Unicode Character Database]: http://www.unicode.org/versions/enumeratedversions.html
[WiredTiger]: https://source.wiredtiger.com/
[Zstandard (zstd)]: https://github.com/facebook/zstd
[benchmark]: https://github.com/google/benchmark
[c-ares]: https://c-ares.org/
[fmt]: http://fmtlib.net/
[gRPC (C++)]: https://github.com/grpc/grpc
[github.com/facebook/folly]: https://github.com/facebook/folly
[gperftools]: https://github.com/gperftools/gperftools
[immer]: https://github.com/arximboldi/immer
[libmongocrypt]: https://github.com/mongodb/libmongocrypt
[librdkafka - The Apache Kafka C/C++ library]: https://github.com/confluentinc/librdkafka
[libunwind]: http://www.github.com/libunwind/libunwind
[linenoise]: https://github.com/antirez/linenoise
[nlohmann/json]: https://github.com/nlohmann/json
[pypi/asn1crypto]: https://github.com/wbond/asn1crypto
[pypi/concurrencytest]: https://pypi.org/project/concurrencytest/
[pypi/discover]: https://pypi.org/project/discover/
[pypi/extras]: https://github.com/testing-cabal/extras
[pypi/ocspbuilder]: https://github.com/wbond/ocspbuilder
[pypi/ocspresponder]: https://github.com/threema-ch/ocspresponder
[pypi/oscrypto]: https://github.com/wbond/oscrypto
[pypi/python-subunit]: https://github.com/testing-cabal/subunit
[pypi/testscenarios]: https://pypi.org/project/testscenarios/
[pypi/testtools]: https://github.com/testing-cabal/testtools
[re2]: https://github.com/google/re2
[snappy]: https://github.com/google/snappy/releases
[timelib]: https://github.com/derickr/timelib
[valgrind.h]: http://valgrind.org/downloads/current.html
[variant]: https://github.com/mpark/variant
[yaml-cpp]: https://github.com/jbeder/yaml-cpp/releases
[zlib]: https://zlib.net/

## WiredTiger Vendored Test Libraries

The following libraries are transitively included by WiredTiger,
and are used by that component for testing. They don't appear in
released binary artifacts.

| Name                       |
| -------------------------- |
| nlohmann/json@3.10.5       |
| pypi/concurrencytest@0.1.2 |
| pypi/discover@0.4.0        |
| pypi/extras@0.0.3          |
| pypi/python-subunit@0.0.16 |
| pypi/testscenarios@0.4     |
| pypi/testtools@0.9.34      |

## Dynamically Linked Libraries

Sometimes MongoDB needs to load libraries provided and managed by the
runtime environment. These libraries are not vendored into the MongoDB
source directory, and are not compiled into release artifacts. Because
they are provided by the runtime environment, the precise versions of
these libraries cannot be known in advance. Further, these libraries may
themselves load other libraries. The full set of transitively linked
libraries will depend on the runtime environment, and cannot be outlined
here. On Windows and Mac OS, other libraries and components provided by
the Operating System may be loaded.

For Windows Enterprise, we may ship precompiled DLLs containing some of
these libraries. Releases prepared in this fashion will include a copy
of these libraries' license in a file named
`THIRD-PARTY-NOTICES.windows`.

| Name       | Enterprise Only |                    Has Windows DLLs                     |
| :--------- | :-------------: | :-----------------------------------------------------: |
| Cyrus SASL |       Yes       |                           Yes                           |
| libldap    |       Yes       |                           No                            |
| net-snmp   |       Yes       |                           Yes                           |
| OpenSSL    |       No        | Yes<sup>\[<a href="#note_ssl" id="ref_ssl">3</a>]</sup> |
| libcurl    |       No        |                           No                            |

## Notes:

1. <a id="note_vg" href="#ref_vg">^</a>
   The majority of Valgrind is licensed under the GPL, with the exception of a single
   header file which is licensed under a BSD license. This BSD licensed header is the only
   file from Valgrind which is vendored and consumed by MongoDB.

2. <a id="note_wt" href="#ref_wt">^</a>
   WiredTiger is maintained by MongoDB in a separate repository. As a part of our
   development process, we periodically ingest the latest snapshot of that repository.

3. <a id="note_ssl" href="#ref_ssl">^</a>
   OpenSSL is only shipped as a dependency of the MongoDB tools written in Go. The MongoDB
   shell and server binaries use Windows' cryptography APIs.