#!/usr/bin/perl -w

my %left;  my %right;
my %pleft; my %pright;

my $DEFAULT_MATRIX_COST = 10000;
my $DEFAULT_WORD_COST = 8000;

sub convMatrix 
{
    my ($file, $ofile) = @_;
    my $line = 0; 
    my $lmax = 0;
    my $rmax = 0;

    open(F, $file) || die "$!: $file\n";
    while (<F>) {
	chomp;
	if (/^\"([^\"]+)\",\"([^\"]+)\",\"([^\"]+)\",(\d+)/) {
	    my $r = $2;
	    my $l = $3;
	    $right{$r} = 1 if ($r !~ /^(ʸ|ʸƬ)/);	
	    $left{$l} = 1  if ($l !~ /^(ʸ|ʸƬ)/);
	    $pleft{$l} = $line;
	    $pright{$r} = $line;
	    $line++;
	} else {
	    warn "cannt parse $_\n";
	}
    }
    close(F);

    my $id = 1;
    for (sort keys %left) {
	$left{$_} = $id;
	++$id;
    }
    $lmax = $id;

    $id = 1;
    for (sort keys %right) {
	$right{$_} = $id;
	++$id;
    }
    $rmax = $id;

    my %matrix;
    open(F, $file) || die "$!: $file\n";
    while (<F>) {
	chomp;
	if (/^\"([^\"]+)\",\"([^\"]+)\",\"([^\"]+)\",(\d+)/) {
	    my $r = $2;
	    my $l = $3;
	    my $c = $4;
	    $r = ($r =~ /^(ʸ|ʸƬ)/) ? 0 : $right{$r};
	    $l = ($l =~ /^(ʸ|ʸƬ)/) ? 0 : $left{$l};
#	    print "[$r][$l] -> $c\n";
	    $matrix{$r}{$l} = $c;
	} else {
	    warn "cannt parse $_\n";
	}
    }
    close(F);

    open (S, "> $ofile") || die "$! $ofile\n";
    printf S "%d %d\n", $rmax, $lmax;
    for (my $r = 0; $r < $rmax; ++$r) {
	for (my $l = 0; $l < $lmax; ++$l) {
	    my $c = $matrix{$r}{$l};
	    $c = $DEFAULT_MATRIX_COST if (! defined $c);
	    print S "$r $l $c\n";
	}
    }
    close(S);
}

sub getid 
{
    my ($feature, $ids, $priority) = @_;
    my @l = @{$feature};
    
    my @trial = (
	"$l[0],$l[1],$l[2],$l[3],$l[4],$l[5],$l[6]",
	"$l[0],$l[1],$l[2],$l[3],$l[4],*,$l[6]",
	"$l[0],$l[1],$l[2],$l[3],*,$l[5],$l[6]",
	"$l[0],$l[1],$l[2],$l[3],$l[4],$l[5],*",
	"$l[0],$l[1],$l[2],$l[3],*,$l[5],*",
	"$l[0],$l[1],$l[2],$l[3],$l[4],*,*",
	"$l[0],$l[1],$l[2],$l[3],*,*,$l[6]",
	"$l[0],$l[1],$l[2],$l[3],*,*,*",
	"$l[0],$l[1],$l[2],*,*,*,*",    
	"$l[0],$l[1],*,*,*,*,*",    
	"$l[0],*,*,*,*,*,*");
    
    my $max = -1;
    my $maxn = -1;    
    for (@trial) {
	my $n = $$ids{$_};
	my $p = $$priority{$_};
	if (defined $n && defined $p) {
	    if ($max < $p) {
		$maxn = $n;
		$max = $p;
	    }
	}
    }
    
    return 1 if ($maxn == -1);
    return $maxn;
}

sub convDic 
{
    my ($file, $ofile) = @_;
    open(F, $file) || die "$!: $file\n";
    open(S, ">$ofile") || die "$!: $ofile\n";
    while (<F>) {
	chomp;
	my @t = split /,/, $_;
	my $w = shift @t;
	my $c = shift @t;
	my $lid = &getid(\@t, \%left, \%pleft);
	my $rid = &getid(\@t, \%right, \%pright);
	my $key = join ",", @t;
#    print "$w,$lid,$rid,$c,$key\n";
	print S "$w,$lid,$rid,$c,$t[6]\n";
    }
    close(F);
    close(S);
}

sub main
{
    &convMatrix("connect.csv", "matrix.def");
    &convDic("dic.csv", "dic.csv2");
}

main ();
